/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.hintparsercommon;

import com.alibaba.common.lang.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class TDDLHintParser {
    public static Map<String, String> parseHint(String sqlHint) {
        sqlHint = StringUtil.substringBetween((String)sqlHint, (String)"/*+", (String)"*/");
        String[] hints = StringUtil.split((String)sqlHint, (String)";");
        HashMap<String, String> hintMap = new HashMap<String, String>(hints.length);
        for (String hint : hints) {
            if (hint == null) {
                throw new IllegalArgumentException("hint is null");
            }
            String[] pair = StringUtil.split((String)hint, (String)":");
            if (pair.length != 2) {
                throw new IllegalArgumentException("\u53c2\u6570\u4e2a\u6570\u9519\u8bef\uff0c\u952e\u503c\u5bf9\u4e0d\u4e3a2;" + hint);
            }
            String key = pair[0];
            key = key.trim();
            String value = pair[1];
            value = value.trim();
            hintMap.put(key, value);
        }
        return hintMap;
    }

    public static boolean containTDDLHint(String sql) {
        if (sql == null) {
            return false;
        }
        return sql.trim().startsWith("/*+");
    }

    static String substringBetween(String str, String open, String close) {
        return TDDLHintParser.substringBetween(str, open, close, 0);
    }

    public static String removeHint(String sql) {
        if (TDDLHintParser.containTDDLHint(sql)) {
            int index = sql.indexOf("*/");
            return sql.substring(index + 2);
        }
        return sql;
    }

    public static void main(String[] args) {
        long l = System.currentTimeMillis();
        String s = "/*+ db:{db1} */sql";
        for (int i = 0; i < 50000; ++i) {
            TDDLHintParser.removeHint(s);
        }
        System.out.println(System.currentTimeMillis() - l);
    }

    private static String substringBetween(String str, String open, String close, int fromIndex) {
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = (str = str.trim()).indexOf(open, fromIndex);
        if (start != -1) {
            int end = str.indexOf(close, start + open.length());
            if (end != -1) {
                return str.substring(start + open.length(), end);
            }
            throw new IllegalArgumentException("can't find end :" + close);
        }
        throw new IllegalArgumentException("can't find start :" + open);
    }
}

