/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.support.SqlLobValue;

public class ArgPreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final Object[] args;

    public ArgPreparedStatementSetter(Object[] args) {
        this.args = args;
    }

    public void setValues(PreparedStatement ps) throws SQLException {
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object arg = this.args[i];
                if (arg instanceof SqlParameterValue) {
                    SqlParameterValue paramValue = (SqlParameterValue)arg;
                    Object inValue = ArgPreparedStatementSetter.adaptSqlTypeValue(paramValue.getSqlType(), paramValue.getValue());
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (SqlParameter)paramValue, (Object)inValue);
                    continue;
                }
                StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)Integer.MIN_VALUE, (Object)arg);
            }
        }
    }

    private static Object adaptSqlTypeValue(int sqlType, Object inValue) {
        if (sqlType == 2005 && inValue instanceof String) {
            return new SqlLobValue((String)inValue);
        }
        if (sqlType == 2004 && inValue instanceof byte[]) {
            return new SqlLobValue((byte[])inValue);
        }
        return inValue;
    }

    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters((Object[])this.args);
    }
}

