/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.support.SqlLobValue;

public class ArgTypePreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final Object[] args;
    private final int[] argTypes;

    public ArgTypePreparedStatementSetter(Object[] args, int[] argTypes) {
        if (args != null && argTypes == null || args == null && argTypes != null || args != null && args.length != argTypes.length) {
            throw new InvalidDataAccessApiUsageException("args and argTypes parameters must match");
        }
        this.args = args;
        this.argTypes = argTypes;
    }

    public void setValues(PreparedStatement ps) throws SQLException {
        int argIndx = 1;
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object arg = this.args[i];
                if (arg instanceof Collection && this.argTypes[i] != 2003) {
                    Collection entries = (Collection)arg;
                    for (Object entry : entries) {
                        Object inValue = ArgTypePreparedStatementSetter.adaptSqlTypeValue(this.argTypes[i], entry);
                        StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)argIndx++, (int)this.argTypes[i], (Object)inValue);
                    }
                    continue;
                }
                Object inValue = ArgTypePreparedStatementSetter.adaptSqlTypeValue(this.argTypes[i], arg);
                StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)argIndx++, (int)this.argTypes[i], (Object)inValue);
            }
        }
    }

    private static Object adaptSqlTypeValue(int sqlType, Object inValue) {
        if (sqlType == 2005 && inValue instanceof String) {
            return new SqlLobValue((String)inValue);
        }
        if (sqlType == 2004 && inValue instanceof byte[]) {
            return new SqlLobValue((byte[])inValue);
        }
        return inValue;
    }

    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters((Object[])this.args);
    }
}

