/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.jdbc;

import com.taobao.tddl.common.jdbc.QueryForMapHandler;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class MetaDataQueryForMapHandler
implements QueryForMapHandler {
    private static final Log log = LogFactory.getLog(MetaDataQueryForMapHandler.class);
    private ConcurrentHashMap<String, QueryForMapHandler.TableMetaData> tableMetaDatas = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ColumnMapRowMapper> rowMappers = new ConcurrentHashMap();

    @Override
    public Map<String, Object> queryForMap(JdbcTemplate jdbcTemplate, String tableName, String selectColumns, String whereSql, Object[] args) {
        tableName = tableName.toLowerCase();
        QueryForMapHandler.TableMetaData tmd = this.tableMetaDatas.get(tableName);
        StringBuilder sql = new StringBuilder("select ");
        if (tmd == null) {
            sql.append(selectColumns == null ? "*" : selectColumns);
        } else {
            sql.append(tmd.commaColumnNames);
        }
        sql.append(" from ").append(tableName).append(" ").append(whereSql);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql=[" + sql.toString() + "], args=" + Arrays.asList(args)));
        }
        try {
            return (Map)this.convert(jdbcTemplate.queryForObject(sql.toString(), args, (RowMapper)this.getRowMapper(tableName)));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (DataAccessException e) {
            log.error((Object)("sql=[" + sql.toString() + "], args=" + Arrays.asList(args)), (Throwable)e);
            throw e;
        }
    }

    @Override
    public QueryForMapHandler.TableMetaData getTableMetaData(String tableName) {
        if (this.tableMetaDatas.get(tableName) == null) {
            throw new IllegalStateException("Must be called after queryForMap called at least once on table " + tableName);
        }
        return this.tableMetaDatas.get(tableName);
    }

    private ColumnMapRowMapper getRowMapper(String tableName) {
        ColumnMapRowMapper rowMapper = this.rowMappers.get(tableName);
        if (rowMapper == null) {
            rowMapper = new CachedColumnMapRowMapper(tableName);
            this.rowMappers.putIfAbsent(tableName, rowMapper);
            return this.rowMappers.get(tableName);
        }
        return rowMapper;
    }

    private void initMetaData(String tableName, ResultSetMetaData rsmd) {
        try {
            int columnCount = rsmd.getColumnCount();
            String[] columnNames = new String[columnCount];
            QueryForMapHandler.ColumnMetaData[] columns = new QueryForMapHandler.ColumnMetaData[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                columnNames[i - 1] = rsmd.getColumnName(i).toLowerCase();
                int sqlType = rsmd.getColumnType(i);
                if (sqlType == 91) {
                    sqlType = 93;
                }
                int scale = rsmd.getScale(i);
                String className = rsmd.getColumnClassName(i);
                columns[i - 1] = new QueryForMapHandler.ColumnMetaData(sqlType, scale, className);
            }
            QueryForMapHandler.TableMetaData tmd = new QueryForMapHandler.TableMetaData(columnNames, columns);
            this.tableMetaDatas.putIfAbsent(tableName, tmd);
        }
        catch (SQLException e) {
            log.warn((Object)"Fetch Metadata from resultSet failed.", (Throwable)e);
        }
    }

    private <T> T convert(Object obj) {
        return (T)obj;
    }

    private class CachedColumnMapRowMapper
    extends ColumnMapRowMapper {
        private final String tableName;

        public CachedColumnMapRowMapper(String tableName) {
            this.tableName = tableName;
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            QueryForMapHandler.TableMetaData tmd = (QueryForMapHandler.TableMetaData)MetaDataQueryForMapHandler.this.tableMetaDatas.get(this.tableName);
            if (tmd == null) {
                MetaDataQueryForMapHandler.this.initMetaData(this.tableName, rs.getMetaData());
                tmd = (QueryForMapHandler.TableMetaData)MetaDataQueryForMapHandler.this.tableMetaDatas.get(this.tableName);
                if (tmd == null) {
                    log.warn((Object)"MetaData is still null after initMetaData().");
                    return super.mapRow(rs, rowNum);
                }
            }
            Map mapOfColValues = super.createColumnMap(tmd.columns.length);
            for (int i = 1; i <= tmd.columns.length; ++i) {
                String key = this.getColumnKey(tmd.columnNames[i - 1]);
                Object obj = this.getResultSetValue(tmd, rs, i);
                mapOfColValues.put(key, obj);
            }
            return mapOfColValues;
        }

        protected String getColumnKey(String columnName) {
            return columnName.toLowerCase();
        }

        private Object getResultSetValue(QueryForMapHandler.TableMetaData tmd, ResultSet rs, int index) throws SQLException {
            Object obj = rs.getObject(index);
            if (obj instanceof Blob) {
                obj = rs.getBytes(index);
            } else if (obj instanceof Clob) {
                obj = rs.getString(index);
            } else if (obj != null && obj.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
                obj = rs.getTimestamp(index);
            } else if (obj != null && obj.getClass().getName().startsWith("oracle.sql.DATE")) {
                String metaDataClassName = tmd.columns[index - 1].className;
                obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index) : rs.getDate(index);
            } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(tmd.columns[index - 1].className)) {
                obj = rs.getTimestamp(index);
            }
            return obj;
        }
    }
}

