/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.jdbc;

import com.taobao.tddl.common.jdbc.ArgTypePreparedStatementSetter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;

public interface QueryForMapHandler {
    public Map<String, Object> queryForMap(JdbcTemplate var1, String var2, String var3, String var4, Object[] var5);

    public TableMetaData getTableMetaData(String var1);

    public static class UseCachedMetaDataSetter
    extends ArgTypePreparedStatementSetter {
        private static int[] getArgTypes(ColumnMetaData[] columns) {
            int[] argTypes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                argTypes[i] = columns[i] == null ? Integer.MIN_VALUE : columns[i].sqlType;
            }
            return argTypes;
        }

        public UseCachedMetaDataSetter(ColumnMetaData[] columns, Object[] args) {
            super(args, UseCachedMetaDataSetter.getArgTypes(columns));
        }
    }

    public static class TableMetaData {
        private final Map<String, ColumnMetaData> columnMetaDataMap;
        public final String[] columnNames;
        public final ColumnMetaData[] columns;
        public final String commaColumnNames;

        public TableMetaData(String[] columnNames, ColumnMetaData[] columns) {
            if (columnNames == null || columnNames.length == 0 || columns == null || columns.length == 0 || columnNames.length != columns.length) {
                throw new IllegalArgumentException("columnNames or columns is null or empty or not match");
            }
            this.columnNames = new String[columnNames.length];
            this.columns = new ColumnMetaData[columns.length];
            System.arraycopy(columnNames, 0, this.columnNames, 0, columnNames.length);
            System.arraycopy(columns, 0, this.columns, 0, columns.length);
            StringBuilder sb = new StringBuilder();
            this.columnMetaDataMap = new HashMap<String, ColumnMetaData>(this.columnNames.length);
            for (int i = 0; i < this.columnNames.length; ++i) {
                sb.append(",").append(this.columnNames[i]);
                this.columnMetaDataMap.put(this.columnNames[i], this.columns[i]);
            }
            this.commaColumnNames = sb.substring(1);
        }

        public ColumnMetaData getColumnMetaData(String columnName) {
            return this.columnMetaDataMap.get(columnName);
        }
    }

    public static class ColumnMetaData {
        public final int sqlType;
        public final int scale;
        public final String className;

        public ColumnMetaData(int sqlType, int scale, String className) {
            this.sqlType = sqlType;
            this.scale = scale;
            this.className = className;
        }
    }
}

