/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.jdbc.conurl;

import com.alibaba.common.lang.StringUtil;
import com.taobao.tddl.common.jdbc.conurl.ConnectionURL;
import com.taobao.tddl.common.jdbc.conurl.MySqlConnectionURL;
import com.taobao.tddl.common.jdbc.conurl.OracleConnectionURL;

public abstract class ConnectionURLParser {
    static String ORACLE_FIX = "jdbc:oracle:";
    static String ORACLE_THIN_FIX = "jdbc:oracle:thin:@";
    static String ORACLE_OCI_FIX = "jdbc:oracle:oci:@";
    static String MYSQL_FIX = "jdbc:mysql://";

    public static ConnectionURL parserConnectionURL(String url) {
        ConnectionURL connectionURL = null;
        if (StringUtil.isBlank((String)url)) {
            return connectionURL;
        }
        if (StringUtil.contains((String)url, (String)ORACLE_FIX)) {
            OracleConnectionURL oracleConUrl = new OracleConnectionURL();
            if (StringUtil.contains((String)url, (String)ORACLE_THIN_FIX)) {
                String dbinfo = StringUtil.substringAfterLast((String)url, (String)"@");
                String[] ipPortAndSid = StringUtil.split((String)dbinfo, (String)":");
                oracleConUrl.setIp(ipPortAndSid[0]);
                oracleConUrl.setPort(ipPortAndSid[1]);
                oracleConUrl.setDbName(ipPortAndSid[2]);
                oracleConUrl.setConType(0);
            } else if (StringUtil.contains((String)url, (String)ORACLE_OCI_FIX)) {
                if (StringUtil.contains((String)url, (String)"(")) {
                    String ip = StringUtil.substringBefore((String)StringUtil.substringAfter((String)url, (String)"HOST="), (String)")");
                    String port = StringUtil.substringBefore((String)StringUtil.substringAfter((String)url, (String)"PORT="), (String)")");
                    oracleConUrl.setIp(ip);
                    oracleConUrl.setPort(port);
                    if (StringUtil.contains((String)url, (String)"SID=")) {
                        oracleConUrl.setConType(1);
                        oracleConUrl.setDbName(StringUtil.substringBefore((String)StringUtil.substringAfter((String)url, (String)"SID="), (String)")"));
                    } else {
                        oracleConUrl.setConType(2);
                        oracleConUrl.setDbName(StringUtil.substringBefore((String)StringUtil.substringAfter((String)url, (String)"SERVICE_NAME="), (String)")"));
                    }
                } else {
                    oracleConUrl.setDbName(StringUtil.substringAfterLast((String)url, (String)"@"));
                    oracleConUrl.setConType(3);
                }
            }
            connectionURL = oracleConUrl;
        } else if (StringUtil.contains((String)url, (String)MYSQL_FIX)) {
            MySqlConnectionURL mySqlConURL = new MySqlConnectionURL();
            mySqlConURL.setPramStr(StringUtil.substringAfter((String)url, (String)"?"));
            String dbInfoString = StringUtil.substringBefore((String)url, (String)"?");
            String dbName = StringUtil.substringAfterLast((String)dbInfoString, (String)"/");
            mySqlConURL.setDbName(dbName);
            String hostString = StringUtil.substringBeforeLast((String)dbInfoString, (String)"/");
            hostString = StringUtil.substringAfterLast((String)hostString, (String)MYSQL_FIX);
            String[] ipAndPort = StringUtil.split((String)hostString, (String)":");
            mySqlConURL.setIp(ipAndPort[0]);
            mySqlConURL.setPort(ipAndPort[1]);
            connectionURL = mySqlConURL;
        }
        return connectionURL;
    }
}

