/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.jdbc.conurl;

import com.taobao.tddl.common.jdbc.conurl.ConnectionURL;
import com.taobao.tddl.interact.rule.bean.DBType;
import java.text.MessageFormat;

public class OracleConnectionURL
extends ConnectionURL {
    public static final int THIN_TYPE = 0;
    public static final int OCI_IP_PORT_SID_TYPE = 1;
    public static final int OCI_IP_PORT_NAME_TYPE = 2;
    public static final int OCI_SID_TYPE = 3;
    private static MessageFormat THIN_FORMAT = new MessageFormat("jdbc:oracle:thin:@{0}:{1}:{2}");
    private static MessageFormat OCI_IP_PORT_SID_FORMAT = new MessageFormat("jdbc:oracle:oci:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST={0})(PORT={1})))(CONNECT_DATA=(SERVER=DEDICAT)(SID={2})))");
    private static MessageFormat OCI_IP_PORT_NAME_FORMAT = new MessageFormat("jdbc:oracle:oci:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST={0})(PORT={1})))(CONNECT_DATA=(SERVER=DEDICAT)(SERVICE_NAME={2})))");
    private static MessageFormat OCI_SID_FORMAT = new MessageFormat("jdbc:oracle:oci:@{0}");
    private int conType;

    @Override
    public String renderURL() {
        String url = null;
        switch (this.getConType()) {
            case 0: {
                url = THIN_FORMAT.format(new String[]{this.getIp(), this.getPort(), this.getDbName()});
                break;
            }
            case 1: {
                url = OCI_IP_PORT_SID_FORMAT.format(new String[]{this.getIp(), this.getPort(), this.getDbName()});
                break;
            }
            case 2: {
                url = OCI_IP_PORT_NAME_FORMAT.format(new String[]{this.getIp(), this.getPort(), this.getDbName()});
                break;
            }
            case 3: {
                url = OCI_SID_FORMAT.format(new String[]{this.getDbName()});
            }
        }
        return url;
    }

    @Override
    public DBType getDbType() {
        return DBType.ORACLE;
    }

    public int getConType() {
        return this.conType;
    }

    public void setConType(int conType) {
        this.conType = conType;
    }
}

