/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.mockdatasource;

import com.taobao.tddl.common.exception.runtime.NotSupportException;
import com.taobao.tddl.common.mockdatasource.MockDataBaseMetaData;
import com.taobao.tddl.common.mockdatasource.MockDataSource;
import com.taobao.tddl.common.mockdatasource.MockPreparedStatement;
import com.taobao.tddl.common.mockdatasource.MockStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public class MockConnection
implements Connection {
    private MockDataSource mockDataSource;
    private long timeToClose = 0L;
    private int closeInvokingTimes = 0;
    private boolean isClosed = false;
    private boolean autoCommit = true;
    private int commitInvokingTimes = 0;
    private int getMetadataInvokingTimes = 0;
    int transactionIsolation = -1;
    private boolean isReadOnly;
    private int rollbackInvotingTimes = 0;

    @Override
    public void clearWarnings() throws SQLException {
        throw new NotSupportException("");
    }

    public MockConnection(String method, MockDataSource mockDataSource) {
        this.mockDataSource = mockDataSource;
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mockDataSource, method, null, null));
    }

    @Override
    public void close() throws SQLException {
        try {
            Thread.sleep(this.timeToClose);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.closeInvokingTimes;
        this.isClosed = true;
    }

    protected void checkClose() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("closed");
        }
    }

    @Override
    public void commit() throws SQLException {
        this.mockDataSource.checkState();
        this.checkClose();
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mockDataSource, "commit", null, null));
        ++this.commitInvokingTimes;
    }

    private static void checkPreException(String name) throws SQLException {
        SQLException e = MockDataSource.popPreException(name);
        if (e != null) {
            throw e;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.mockDataSource.checkState();
        MockConnection.checkPreException("createStatement");
        return new MockStatement("createStatement", this.mockDataSource);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.mockDataSource.checkState();
        MockConnection.checkPreException("createStatement");
        return new MockStatement("createStatement#int_int", this.mockDataSource);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.mockDataSource.checkState();
        MockConnection.checkPreException("createStatement");
        return new MockStatement("createStatement#int_int_int", this.mockDataSource);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.mockDataSource.checkState();
        this.checkClose();
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.mockDataSource.checkState();
        this.checkClose();
        ++this.getMetadataInvokingTimes;
        return new MockDataBaseMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.mockDataSource.checkState();
        this.checkClose();
        return this.transactionIsolation;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public boolean isClosed() throws SQLException {
        this.mockDataSource.checkState();
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.mockDataSource.checkState();
        return this.isReadOnly;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.mockDataSource.checkState();
        MockConnection.checkPreException("prepareStatement");
        return new MockPreparedStatement("prepareStatement", this.mockDataSource, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.mockDataSource.checkState();
        MockConnection.checkPreException("prepareStatement");
        return new MockPreparedStatement("prepareStatement#string_int", this.mockDataSource, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.mockDataSource.checkState();
        MockConnection.checkPreException("prepareStatement");
        return new MockPreparedStatement("prepareStatement#string_int[", this.mockDataSource, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.mockDataSource.checkState();
        MockConnection.checkPreException("prepareStatement");
        return new MockPreparedStatement("prepareStatement#string_String[", this.mockDataSource, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.mockDataSource.checkState();
        MockConnection.checkPreException("prepareStatement");
        return new MockPreparedStatement("prepareStatement#string_int_int", this.mockDataSource, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.mockDataSource.checkState();
        MockConnection.checkPreException("prepareStatement");
        return new MockPreparedStatement("prepareStatement#string_int_int_int", this.mockDataSource, sql);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.mockDataSource.checkState();
        throw new NotSupportException("");
    }

    @Override
    public void rollback() throws SQLException {
        this.mockDataSource.checkState();
        this.checkClose();
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mockDataSource, "rollback", null, null));
        ++this.rollbackInvotingTimes;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.mockDataSource.checkState();
        this.checkClose();
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mockDataSource, "rollback#savepoint", null, new Object[]{savepoint}));
        ++this.rollbackInvotingTimes;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.mockDataSource.checkState();
        this.checkClose();
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mockDataSource, "setAutoCommit", null, new Object[]{autoCommit}));
        this.autoCommit = autoCommit;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.mockDataSource.checkState();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.mockDataSource.checkState();
        this.transactionIsolation = level;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }
}

