/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.mockdatasource;

import com.taobao.tddl.common.exception.runtime.NotSupportException;
import com.taobao.tddl.common.mockdatasource.MockConnection;
import com.taobao.tddl.interact.rule.bean.DBType;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class MockDataSource
implements DataSource,
Cloneable {
    private int timeToObtainConnection = 0;
    private int getConnectionInvokingTimes = 0;
    private String name;
    private String dbIndex;
    private boolean isClosed;
    private DBType dbType = DBType.MYSQL;
    private static ThreadLocal<ExecuteInfo> RESULT = new ThreadLocal();
    private static ThreadLocal<List<ExecuteInfo>> TRACE = new ThreadLocal();
    private static ThreadLocal<List<QueryResult>> PREDATA = new ThreadLocal();
    private static ThreadLocal<List<Integer>> PREAffectedRow = new ThreadLocal();
    private static ThreadLocal<Map<String, List<SQLException>>> PREException = new ThreadLocal<Map<String, List<SQLException>>>(){

        @Override
        protected Map<String, List<SQLException>> initialValue() {
            HashMap<String, List<SQLException>> exceptions = new HashMap<String, List<SQLException>>(4);
            exceptions.put(MockDataSource.m_getConnection, new ArrayList(0));
            exceptions.put(MockDataSource.m_prepareStatement, new ArrayList(0));
            exceptions.put(MockDataSource.m_createStatement, new ArrayList(0));
            exceptions.put(MockDataSource.m_executeQuery, new ArrayList(0));
            exceptions.put(MockDataSource.m_executeUpdate, new ArrayList(0));
            return exceptions;
        }
    };
    public static final String m_getConnection = "getConnection";
    public static final String m_prepareStatement = "prepareStatement";
    public static final String m_createStatement = "createStatement";
    public static final String m_executeQuery = "executeQuery";
    public static final String m_executeUpdate = "executeUpdate";

    public MockDataSource() {
    }

    public MockDataSource(String dbIndex, String name) {
        this.dbIndex = dbIndex;
        this.name = name;
    }

    public void checkState() throws SQLException {
        if (this.isClosed) {
            throw this.genFatalSQLException();
        }
    }

    public SQLException genFatalSQLException() throws SQLException {
        if (DBType.MYSQL.equals((Object)this.dbType)) {
            return new SQLException("dsClosed", "08001");
        }
        if (DBType.ORACLE.equals((Object)this.dbType)) {
            return new SQLException("dsClosed", "28");
        }
        throw new RuntimeException("\u6709\u4e86\u65b0\u7684dbType\u800c\u8fd9\u91cc\u6ca1\u6709\u66f4\u65b0");
    }

    public static void reset() {
        RESULT.set(null);
        TRACE.set(null);
        PREDATA.set(null);
        PREAffectedRow.set(null);
        for (Map.Entry<String, List<SQLException>> e : PREException.get().entrySet()) {
            e.getValue().clear();
        }
    }

    public static void clearTrace() {
        List<ExecuteInfo> trace = TRACE.get();
        if (trace != null) {
            trace.clear();
        }
        PREDATA.set(null);
    }

    public static void showTrace() {
        MockDataSource.showTrace("");
    }

    public static void showTrace(String msg) {
        List<ExecuteInfo> trace = TRACE.get();
        if (trace == null) {
            return;
        }
        System.out.println("Invoke trace on MockDataSource:" + msg);
        for (ExecuteInfo info : trace) {
            System.out.println(info.toString());
        }
    }

    public static ExecuteInfo getResult() {
        return RESULT.get();
    }

    public static List<ExecuteInfo> getTrace() {
        return TRACE.get();
    }

    public static boolean hasTrace(String dbIndex, String sqlHead) {
        List<ExecuteInfo> trace = TRACE.get();
        if (trace != null) {
            for (ExecuteInfo info : trace) {
                if (info.sql == null || !dbIndex.equals(info.ds.dbIndex) || sqlHead.length() > info.sql.length() || !sqlHead.equalsIgnoreCase(info.sql.substring(0, sqlHead.length()))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasTrace(String dbIndex, String dsName, String sqlHead) {
        List<ExecuteInfo> trace = TRACE.get();
        if (trace != null) {
            for (ExecuteInfo info : trace) {
                if (info.sql == null || !dbIndex.equals(info.ds.dbIndex) || !info.ds.name.equals(dsName) || sqlHead.length() > info.sql.length() || !sqlHead.equalsIgnoreCase(info.sql.substring(0, sqlHead.length()))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasMethod(String dbIndex, String method) {
        List<ExecuteInfo> trace = TRACE.get();
        if (trace != null) {
            for (ExecuteInfo info : trace) {
                if (!dbIndex.equals(info.ds.dbIndex) || !method.equals(info.method)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasMethod(String dbIndex, String dsName, String method) {
        List<ExecuteInfo> trace = TRACE.get();
        if (trace != null) {
            for (ExecuteInfo info : trace) {
                if (!dbIndex.equals(info.ds.dbIndex) || !method.equals(info.method) || !info.ds.name.equals(dsName)) continue;
                return true;
            }
        }
        return false;
    }

    public static void record(ExecuteInfo info) {
        RESULT.set(info);
        if (TRACE.get() == null) {
            TRACE.set(new ArrayList());
        }
        TRACE.get().add(info);
    }

    public static void addPreData(String arow) {
        MockDataSource.addPreData(new QueryResult(arow));
    }

    public static void addPreData(QueryResult queryResult) {
        if (PREDATA.get() == null) {
            PREDATA.set(new ArrayList(5));
        }
        PREDATA.get().add(queryResult);
    }

    public static void addPreAffectedRow(int preAffectedRow) {
        if (PREAffectedRow.get() == null) {
            PREAffectedRow.set(new ArrayList(1));
        }
        PREAffectedRow.get().add(preAffectedRow);
    }

    static QueryResult popPreData() {
        List<QueryResult> preData = PREDATA.get();
        if (preData == null || preData.isEmpty()) {
            return null;
        }
        return PREDATA.get().remove(0);
    }

    static int popPreAffectedRow() {
        List<Integer> preAffectedRow = PREAffectedRow.get();
        if (preAffectedRow == null || preAffectedRow.isEmpty()) {
            return 1;
        }
        return PREAffectedRow.get().remove(0);
    }

    public static void addPreException(String key, SQLException e) {
        PREException.get().get(key).add(e);
    }

    public static SQLException popPreException(String key) {
        List<SQLException> pre = PREException.get().get(key);
        return pre.size() == 0 ? null : pre.remove(0);
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Thread.sleep(this.timeToObtainConnection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.getConnectionInvokingTimes;
        return new MockConnection(m_getConnection, this);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            Thread.sleep(this.timeToObtainConnection);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.getConnectionInvokingTimes;
        return new MockConnection("getConnection#username_password", this);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new NotSupportException("");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDbIndex() {
        return this.dbIndex;
    }

    public void setDbIndex(String dbIndex) {
        this.dbIndex = dbIndex;
    }

    public MockDataSource clone() throws CloneNotSupportedException {
        return (MockDataSource)super.clone();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    public String toString() {
        return super.toString().substring(this.getClass().getPackage().getName().length() + 1) + "{dbIndex:" + this.dbIndex + ",name:" + this.name + "}";
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public static class QueryResult {
        public final Map<String, Integer> columns;
        public final List<Object[]> rows;

        public QueryResult(Map<String, Integer> columns, List<Object[]> values) {
            this.columns = columns;
            this.rows = values;
        }

        public QueryResult(String row) {
            String[] cols = row.split(",");
            this.columns = new HashMap<String, Integer>(cols.length);
            ArrayList<Object> colvalues = new ArrayList<Object>(cols.length);
            for (int i = 0; i < cols.length; ++i) {
                String col = cols[i];
                String[] nv = col.split("\\:");
                this.columns.put(nv[0], i);
                if (nv[1].startsWith("'") && nv[1].endsWith("'")) {
                    colvalues.add(nv[1].substring(1, nv[1].length() - 1));
                    continue;
                }
                if (nv[1].endsWith("NULL")) {
                    colvalues.add(null);
                    continue;
                }
                colvalues.add(Long.parseLong(nv[1]));
            }
            this.rows = new ArrayList<Object[]>(1);
            this.rows.add(colvalues.toArray(new Object[colvalues.size()]));
        }
    }

    public static class ExecuteInfo {
        public MockDataSource ds;
        public String method;
        public String sql;
        public Object[] args;

        public ExecuteInfo(MockDataSource dataSource, String method, String sql, Object[] args) {
            this.ds = dataSource;
            this.method = method;
            this.sql = sql;
            this.args = args;
        }

        public String toString() {
            return "ExecuteInfo:{ds:" + this.ds + ",method:" + this.method + ",sql:" + this.sql + ",args:" + Arrays.toString(this.args) + "}";
        }
    }
}

