/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.mockdatasource;

import com.taobao.tddl.common.mockdatasource.MockDataSource;
import com.taobao.tddl.common.mockdatasource.MockStatement;
import com.taobao.tddl.common.mockdatasource.param.ParameterContext;
import com.taobao.tddl.common.mockdatasource.param.ParameterHandler;
import com.taobao.tddl.common.mockdatasource.param.ParameterMethod;
import com.taobao.tddl.common.mockdatasource.param.SetArrayHandler;
import com.taobao.tddl.common.mockdatasource.param.SetAsciiStreamHandler;
import com.taobao.tddl.common.mockdatasource.param.SetBigDecimalHandler;
import com.taobao.tddl.common.mockdatasource.param.SetBinaryStreamHandler;
import com.taobao.tddl.common.mockdatasource.param.SetBlobHandler;
import com.taobao.tddl.common.mockdatasource.param.SetBooleanHandler;
import com.taobao.tddl.common.mockdatasource.param.SetByteHandler;
import com.taobao.tddl.common.mockdatasource.param.SetBytesHandler;
import com.taobao.tddl.common.mockdatasource.param.SetCharacterStreamHandler;
import com.taobao.tddl.common.mockdatasource.param.SetClobHandler;
import com.taobao.tddl.common.mockdatasource.param.SetDate1Handler;
import com.taobao.tddl.common.mockdatasource.param.SetDate2Handler;
import com.taobao.tddl.common.mockdatasource.param.SetDoubleHandler;
import com.taobao.tddl.common.mockdatasource.param.SetFloatHandler;
import com.taobao.tddl.common.mockdatasource.param.SetIntHandler;
import com.taobao.tddl.common.mockdatasource.param.SetLongHandler;
import com.taobao.tddl.common.mockdatasource.param.SetNull1Handler;
import com.taobao.tddl.common.mockdatasource.param.SetNull2Handler;
import com.taobao.tddl.common.mockdatasource.param.SetObject1Handler;
import com.taobao.tddl.common.mockdatasource.param.SetObject2Handler;
import com.taobao.tddl.common.mockdatasource.param.SetObject3Handler;
import com.taobao.tddl.common.mockdatasource.param.SetRefHandler;
import com.taobao.tddl.common.mockdatasource.param.SetShortHandler;
import com.taobao.tddl.common.mockdatasource.param.SetStringHandler;
import com.taobao.tddl.common.mockdatasource.param.SetTime1Handler;
import com.taobao.tddl.common.mockdatasource.param.SetTime2Handler;
import com.taobao.tddl.common.mockdatasource.param.SetTimestamp1Handler;
import com.taobao.tddl.common.mockdatasource.param.SetTimestamp2Handler;
import com.taobao.tddl.common.mockdatasource.param.SetURLHandler;
import com.taobao.tddl.common.mockdatasource.param.SetUnicodeStreamHandler;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockPreparedStatement
extends MockStatement
implements PreparedStatement {
    private static final Log log = LogFactory.getLog(MockPreparedStatement.class);
    private static final Map<ParameterMethod, ParameterHandler> parameterHandlers = new HashMap<ParameterMethod, ParameterHandler>(30);
    private int autoGeneratedKeys = -1;
    private int[] columnIndexes;
    private String[] columnNames;
    private Map<Integer, ParameterContext> parameterSettings = new TreeMap<Integer, ParameterContext>();
    List<Object> batchedArgs;

    public MockPreparedStatement(String method, MockDataSource mockDataSource, String sql) {
        super(method, mockDataSource, sql);
    }

    private PreparedStatement prepareStatementInternal(Connection connection, String targetSql) throws SQLException {
        PreparedStatement ps = this.getResultSetType() != -1 && this.getResultSetConcurrency() != -1 && this.getResultSetHoldability() != -1 ? connection.prepareStatement(targetSql, this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability()) : (this.getResultSetType() != -1 && this.getResultSetConcurrency() != -1 ? connection.prepareStatement(targetSql, this.getResultSetType(), this.getResultSetConcurrency()) : (this.autoGeneratedKeys != -1 ? connection.prepareStatement(targetSql, this.autoGeneratedKeys) : (this.columnIndexes != null ? connection.prepareStatement(targetSql, this.columnIndexes) : (this.columnNames != null ? connection.prepareStatement(targetSql, this.columnNames) : connection.prepareStatement(targetSql)))));
        return ps;
    }

    private void changeParameters(Map<Integer, Object> changedParameters) {
        for (Map.Entry<Integer, Object> entry : changedParameters.entrySet()) {
            ParameterContext context = this.parameterSettings.get(entry.getKey() + 1);
            if (context.getParameterMethod() == ParameterMethod.setNull1 || context.getParameterMethod() == ParameterMethod.setNull2) continue;
            context.getArgs()[1] = entry.getValue();
        }
    }

    private void setParameters(PreparedStatement ps) throws SQLException {
        for (ParameterContext context : this.parameterSettings.values()) {
            parameterHandlers.get((Object)context.getParameterMethod()).setParameter(ps, context.getArgs());
        }
    }

    private List<Object> getParameters() {
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (ParameterContext context : this.parameterSettings.values()) {
            if (context.getParameterMethod() != ParameterMethod.setNull1 && context.getParameterMethod() != ParameterMethod.setNull2) {
                parameters.add(context.getArgs()[1]);
                continue;
            }
            parameters.add(null);
        }
        return parameters;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameterSettings.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        return this.executerHandler.executeSql("ps.execute", this.sql);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("invoke executeQuery, sql = " + this.sql));
        }
        this.checkClosed();
        SQLException e = MockDataSource.popPreException("executeQuery");
        if (e != null) {
            throw e;
        }
        return this.executerHandler.execute("ps.executeQuery", this.sql);
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("invoke executeUpdate, sql = " + this.sql));
        }
        this.checkClosed();
        SQLException e = MockDataSource.popPreException("executeUpdate");
        if (e != null) {
            throw e;
        }
        return super.updateInternal("ps.executeUpdate", this.sql);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedOperationException("getMetaData");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException("getParameterMetaData");
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setArray, new Object[]{i, x}));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setAsciiStream, new Object[]{parameterIndex, x, length}));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBigDecimal, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBinaryStream, new Object[]{parameterIndex, x, length}));
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setBlob, new Object[]{i, x}));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBoolean, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setByte, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBytes, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setCharacterStream, new Object[]{parameterIndex, reader, length}));
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setClob, new Object[]{i, x}));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setDate1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setDate2, new Object[]{parameterIndex, x, cal}));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setDouble, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setFloat, new Object[]{parameterIndex, Float.valueOf(x)}));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setInt, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setLong, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setNull1, new Object[]{parameterIndex, sqlType}));
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.parameterSettings.put(paramIndex, new ParameterContext(ParameterMethod.setNull2, new Object[]{paramIndex, sqlType, typeName}));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setObject1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setObject2, new Object[]{parameterIndex, x, targetSqlType}));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setObject3, new Object[]{parameterIndex, x, targetSqlType, scale}));
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setRef, new Object[]{i, x}));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setShort, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setString, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTime1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTime2, new Object[]{parameterIndex, x, cal}));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTimestamp1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTimestamp2, new Object[]{parameterIndex, x, cal}));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setURL, new Object[]{parameterIndex, x}));
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setUnicodeStream, new Object[]{parameterIndex, x, length}));
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList<Object>();
        }
        ArrayList<ParameterContext> batchedParameterSettings = new ArrayList<ParameterContext>();
        batchedParameterSettings.addAll(this.parameterSettings.values());
        this.batchedArgs.add(batchedParameterSettings);
    }

    private static void setBatchParameters(PreparedStatement ps, List<ParameterContext> batchedParameters) throws SQLException {
        for (ParameterContext context : batchedParameters) {
            parameterHandlers.get((Object)context.getParameterMethod()).setParameter(ps, context.getArgs());
        }
    }

    private static List<Object> getBatchParameters(List<ParameterContext> batchedParameters) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        for (ParameterContext context : batchedParameters) {
            parameters.add(context.getArgs()[1]);
        }
        return parameters;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.mds.checkState();
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mds, "executeBatch", this.sql, null));
        return new int[]{-1, -1};
    }

    @Override
    public void clearBatch() throws SQLException {
        super.clearBatch();
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public void setAutoGeneratedKeys(int autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public void setColumnIndexes(int[] columnIndexes) {
        this.columnIndexes = columnIndexes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    static {
        parameterHandlers.put(ParameterMethod.setArray, new SetArrayHandler());
        parameterHandlers.put(ParameterMethod.setAsciiStream, new SetAsciiStreamHandler());
        parameterHandlers.put(ParameterMethod.setBigDecimal, new SetBigDecimalHandler());
        parameterHandlers.put(ParameterMethod.setBinaryStream, new SetBinaryStreamHandler());
        parameterHandlers.put(ParameterMethod.setBlob, new SetBlobHandler());
        parameterHandlers.put(ParameterMethod.setBoolean, new SetBooleanHandler());
        parameterHandlers.put(ParameterMethod.setByte, new SetByteHandler());
        parameterHandlers.put(ParameterMethod.setBytes, new SetBytesHandler());
        parameterHandlers.put(ParameterMethod.setCharacterStream, new SetCharacterStreamHandler());
        parameterHandlers.put(ParameterMethod.setClob, new SetClobHandler());
        parameterHandlers.put(ParameterMethod.setDate1, new SetDate1Handler());
        parameterHandlers.put(ParameterMethod.setDate2, new SetDate2Handler());
        parameterHandlers.put(ParameterMethod.setDouble, new SetDoubleHandler());
        parameterHandlers.put(ParameterMethod.setFloat, new SetFloatHandler());
        parameterHandlers.put(ParameterMethod.setInt, new SetIntHandler());
        parameterHandlers.put(ParameterMethod.setLong, new SetLongHandler());
        parameterHandlers.put(ParameterMethod.setNull1, new SetNull1Handler());
        parameterHandlers.put(ParameterMethod.setNull2, new SetNull2Handler());
        parameterHandlers.put(ParameterMethod.setObject1, new SetObject1Handler());
        parameterHandlers.put(ParameterMethod.setObject2, new SetObject2Handler());
        parameterHandlers.put(ParameterMethod.setObject3, new SetObject3Handler());
        parameterHandlers.put(ParameterMethod.setRef, new SetRefHandler());
        parameterHandlers.put(ParameterMethod.setShort, new SetShortHandler());
        parameterHandlers.put(ParameterMethod.setString, new SetStringHandler());
        parameterHandlers.put(ParameterMethod.setTime1, new SetTime1Handler());
        parameterHandlers.put(ParameterMethod.setTime2, new SetTime2Handler());
        parameterHandlers.put(ParameterMethod.setTimestamp1, new SetTimestamp1Handler());
        parameterHandlers.put(ParameterMethod.setTimestamp2, new SetTimestamp2Handler());
        parameterHandlers.put(ParameterMethod.setUnicodeStream, new SetUnicodeStreamHandler());
        parameterHandlers.put(ParameterMethod.setURL, new SetURLHandler());
    }
}

