/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.mockdatasource;

import com.taobao.tddl.common.mockdatasource.MockDataSource;
import com.taobao.tddl.common.mockdatasource.MockResultSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockResultSet
implements ResultSet {
    private final MockDataSource mds;
    private ResultSetMetaData resultSetMetaData;
    public final Map<String, Integer> columns;
    public final List<Object[]> rows;
    private int cursor = -1;
    private boolean closed;
    private int closeInvocatingTimes = 0;
    private int nextInvokingTimes = 0;
    private long nextSleepTime = 0L;

    public MockResultSet(MockDataSource mockDataSource, Map<String, Integer> columns, List<Object[]> values) {
        this.mds = mockDataSource;
        this.columns = columns;
        this.rows = values;
        this.resultSetMetaData = new MockResultSetMetaData(columns);
    }

    public MockResultSet(MockDataSource mockDataSource, MockDataSource.QueryResult res) {
        this.mds = mockDataSource;
        if (res != null) {
            this.columns = res.columns;
            this.rows = res.rows;
        } else {
            this.columns = new HashMap<String, Integer>(0);
            this.rows = new ArrayList<Object[]>(0);
        }
        this.resultSetMetaData = new MockResultSetMetaData(this.columns);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new UnsupportedOperationException("absolute");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException("afterLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new UnsupportedOperationException("beforeFirst");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("cancelRowUpdates");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("clearWarnings");
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
        ++this.closeInvocatingTimes;
    }

    protected void checkClose() throws SQLException {
        if (this.closed) {
            throw new SQLException("closed");
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("deleteRow");
    }

    public void closeInternal(boolean removeThis) throws SQLException {
        throw new UnsupportedOperationException("closeInternal");
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        throw new UnsupportedOperationException("findColumn");
    }

    @Override
    public boolean first() throws SQLException {
        throw new UnsupportedOperationException("first");
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return (Array)this.getObject(i);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new UnsupportedOperationException("getArray(String colName)");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("getAsciiStream(int columnIndex)");
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getAsciiStream(String columnName)");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.getObject(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getBigDecimal(String columnName)");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new UnsupportedOperationException("getBigDecimal(int columnIndex, int scale)");
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new UnsupportedOperationException("getBigDecimal(String columnName, int scale)");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return (InputStream)this.getObject(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getBinaryStream(String columnName)");
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return (Blob)this.getObject(i);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new UnsupportedOperationException("getBlob(String colName)");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return (Boolean)this.getObject(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getBoolean(String columnName)");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (Byte)this.getObject(columnIndex);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getByte(String columnName)");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.getObject(columnIndex);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getBytes(String columnName)");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return (Reader)this.getObject(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getCharacterStream(String columnName)");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return (Clob)this.getObject(i);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new UnsupportedOperationException("getClob(String colName)");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new UnsupportedOperationException("getConcurrency");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("getCursorName");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getObject(columnIndex);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getDate(String columnName)");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("getDate(int columnIndex, Calendar cal)");
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("getDate(String columnName, Calendar cal)");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("getDouble(int columnIndex)");
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getDouble(String columnName)");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException("getFetchDirection");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException("getFetchSize");
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("getFloat(int columnIndex)");
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getFloat(String columnName)");
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Long value = (Long)this.rows.get(this.cursor)[columnIndex - 1];
        return value.intValue();
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getInt(String columnName)");
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Long value = (Long)this.rows.get(this.cursor)[columnIndex - 1];
        return value;
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getLong(String columnName)");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mds, "ResultSet.getMetaData", null, null));
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.rows.get(this.cursor)[columnIndex - 1];
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.rows.get(this.cursor)[this.columns.get(columnName) - 1];
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("getObject(int i, Map<String, Class<?>> map)");
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("getObject(String colName, Map<String, Class<?>> map)");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new UnsupportedOperationException("getRef(int i)");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new UnsupportedOperationException("getRef(String colName)");
    }

    @Override
    public int getRow() throws SQLException {
        throw new UnsupportedOperationException("getRow");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (Short)this.getObject(columnIndex);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return (Short)this.getObject(columnName);
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException("getStatement");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)this.getObject(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return (String)this.getObject(columnName);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getObject(columnIndex);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return (Time)this.getObject(columnName);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("getTime(int columnIndex, Calendar cal)");
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("getTime(String columnName, Calendar cal)");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getObject(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return (Timestamp)this.getObject(columnName);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("getTimestamp(int columnIndex, Calendar cal)");
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new UnsupportedOperationException("getTimestamp(String columnName, Calendar cal)");
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("getURL(int columnIndex)");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getURL(String columnName)");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("getUnicodeStream(int columnIndex)");
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getUnicodeStream(String columnName)");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("getWarnings");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException("insertRow");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new UnsupportedOperationException("isAfterLast");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new UnsupportedOperationException("isBeforeFirst");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new UnsupportedOperationException("isFirst");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException("isLast");
    }

    @Override
    public boolean last() throws SQLException {
        throw new UnsupportedOperationException("last");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException("moveToCurrentRow");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException("moveToInsertRow");
    }

    protected boolean hasNext() {
        ++this.cursor;
        return this.cursor < this.rows.size();
    }

    @Override
    public boolean next() throws SQLException {
        try {
            Thread.sleep(this.nextSleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ++this.nextInvokingTimes;
        return this.hasNext();
    }

    @Override
    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException("previous");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("refreshRow");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new UnsupportedOperationException("relative");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException("rowDeleted");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException("rowInserted");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException("rowUpdated");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException("setFetchDirection");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException("setFetchSize");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("updateArray(int columnIndex, Array x)");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException("updateArray(String columnName, Array x)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("updateAsciiStream(int columnIndex, InputStream x, int length)");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("updateAsciiStream(String columnName, InputStream x, int length)");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("updateBigDecimal(int columnIndex, BigDecimal x)");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("updateBigDecimal(String columnName, BigDecimal x)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("updateBinaryStream(int columnIndex, InputStream x, int length)");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("updateBinaryStream(String columnName, InputStream x, int length)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("updateBlob(int columnIndex, Blob x)");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new UnsupportedOperationException("updateBlob(String columnName, Blob x)");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException("updateBoolean(int columnIndex, boolean x)");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new UnsupportedOperationException("updateBoolean(String columnName, boolean x)");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException("updateByte(int columnIndex, byte x)");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new UnsupportedOperationException("updateByte(String columnName, byte x)");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("updateBytes(int columnIndex, byte[] x)");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("updateBytes(String columnName, byte[] x)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException("updateCharacterStream(int columnIndex, Reader x, int length)");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("updateCharacterStream(String columnName, Reader reader, int length)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("updateClob(int columnIndex, Clob x)");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new UnsupportedOperationException("updateClob(String columnName, Clob x)");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException("updateDate(int columnIndex, Date x)");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new UnsupportedOperationException("updateDate(String columnName, Date x)");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException("updateDouble(int columnIndex, double x)");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new UnsupportedOperationException("updateDouble(String columnName, double x)");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException("updateFloat(int columnIndex, float x)");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new UnsupportedOperationException("updateFloat(String columnName, float x)");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException("updateInt(int columnIndex, int x)");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new UnsupportedOperationException("updateInt(String columnName, int x)");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException("updateLong(int columnIndex, long x)");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new UnsupportedOperationException("updateLong(String columnName, long x)");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("updateNull(int columnIndex)");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new UnsupportedOperationException("updateNull(String columnName)");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException("updateObject(int columnIndex, Object x)");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new UnsupportedOperationException("updateObject(String columnName, Object x)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException("updateObject(int columnIndex, Object x, int scale)");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException("updateObject(String columnName, Object x, int scale)");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("updateRef(int columnIndex, Ref x)");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException("updateRef(String columnName, Ref x)");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("updateRow");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException("updateShort(int columnIndex, short x)");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new UnsupportedOperationException("updateShort(String columnName, short x)");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException("updateString(int columnIndex, String x)");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new UnsupportedOperationException("updateString(String columnName, String x)");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException("updateTime(int columnIndex, Time x)");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new UnsupportedOperationException("updateTime(String columnName, Time x)");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("updateTimestamp(int columnIndex, Timestamp x)");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("updateTimestamp(String columnName, Timestamp x)");
    }

    @Override
    public boolean wasNull() throws SQLException {
        Object[] objects = this.rows.get(this.cursor);
        return null == objects[objects.length - 1];
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return null;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }
}

