/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.mockdatasource;

import com.taobao.tddl.common.exception.runtime.NotSupportException;
import com.taobao.tddl.common.mockdatasource.ExecuteHandler;
import com.taobao.tddl.common.mockdatasource.MockDataSource;
import com.taobao.tddl.common.mockdatasource.MockResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MockStatement
implements Statement {
    private static final Log logger = LogFactory.getLog(MockStatement.class);
    protected MockDataSource mds;
    protected String sql;
    protected List<String> sqls = new ArrayList<String>();
    protected int queryTimeOut;
    protected int fetchSize;
    protected int maxRows;
    private int closeInvokingTimes = 0;
    private boolean isClosed;
    private boolean success = true;
    private int executeSqlInvokingTimes = 0;
    protected ExecuteHandler executerHandler = new ExecuteHandler(){

        @Override
        public ResultSet execute(String method, String tsql) {
            MockStatement.this.sql = tsql;
            MockStatement.this.executeSqlInvokingTimes++;
            logger.warn((Object)("[executerHandler]" + MockStatement.this.sql));
            MockDataSource.record(new MockDataSource.ExecuteInfo(MockStatement.this.mds, method, MockStatement.this.sql, null));
            return new MockResultSet(MockStatement.this.mds, MockDataSource.popPreData());
        }

        @Override
        public boolean executeSql(String method, String tsql) {
            MockStatement.this.sql = tsql;
            MockStatement.this.executeSqlInvokingTimes++;
            logger.warn((Object)("[executerHandler]" + MockStatement.this.sql));
            MockDataSource.record(new MockDataSource.ExecuteInfo(MockStatement.this.mds, method, MockStatement.this.sql, null));
            return true;
        }
    };
    private long insertSleepTime = 0L;

    public MockStatement(String method, MockDataSource mockDataSource, String sql) {
        this.sql = sql;
        this.mds = mockDataSource;
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mds, method, null, null));
    }

    public MockStatement(String method, MockDataSource mockDataSource) {
        this.mds = mockDataSource;
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mds, method, null, null));
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.mds.checkState();
        this.sqls.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.mds.checkState();
        throw new NotSupportException("");
    }

    @Override
    public void clearBatch() throws SQLException {
        this.mds.checkState();
        this.sqls.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public void close() throws SQLException {
        this.mds.checkState();
        ++this.closeInvokingTimes;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("closed");
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.mds.checkState();
        this.sql = sql;
        ++this.executeSqlInvokingTimes;
        logger.warn((Object)("[execute(String)]" + sql));
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mds, "execute", this.sql, null));
        return this.success;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.mds.checkState();
        this.sql = sql;
        ++this.executeSqlInvokingTimes;
        logger.warn((Object)("[execute(String,int)]" + sql));
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mds, "execute_sql_int", this.sql, null));
        return this.success;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.mds.checkState();
        return this.executerHandler.executeSql("execute#sql_int[", sql);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.mds.checkState();
        return this.executerHandler.executeSql("execute#sql_string[", sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.mds.checkState();
        logger.warn((Object)("[executeBatch]" + this.sql));
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mds, "executeBatch", this.sql, null));
        return new int[]{-1, -1};
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.mds.checkState();
        return this.executerHandler.execute("executeQuery", sql);
    }

    protected int updateInternal(String method, String sql) {
        try {
            Thread.sleep(this.insertSleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.sql = sql;
        MockDataSource.record(new MockDataSource.ExecuteInfo(this.mds, method, this.sql, null));
        logger.warn((Object)("[UpdateHandler]" + sql));
        return MockDataSource.popPreAffectedRow();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.mds.checkState();
        return this.updateInternal("executeUpdate", sql);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.mds.checkState();
        return this.updateInternal("executeUpdate#sql_int", sql);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.mds.checkState();
        return this.updateInternal("executeUpdate#sql_int[", sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.mds.checkState();
        return this.updateInternal("executeUpdate#sql_string[", sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeOut;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.mds.checkState();
        return new MockResultSet(this.mds, MockDataSource.popPreData());
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new NotSupportException("");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeOut = seconds;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getCloseInvokingTimes() {
        return this.closeInvokingTimes;
    }

    public void setCloseInvokingTimes(int closeInvokingTimes) {
        this.closeInvokingTimes = closeInvokingTimes;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getExecuteSqlInvokingTimes() {
        return this.executeSqlInvokingTimes;
    }

    public void setExecuteSqlInvokingTimes(int executeSqlInvokingTimes) {
        this.executeSqlInvokingTimes = executeSqlInvokingTimes;
    }

    public ExecuteHandler getExecuterHandler() {
        return this.executerHandler;
    }

    public void setExecuterHandler(ExecuteHandler executerHandler) {
        this.executerHandler = executerHandler;
    }

    public long getInsertSleepTime() {
        return this.insertSleepTime;
    }

    public void setInsertSleepTime(long insertSleepTime) {
        this.insertSleepTime = insertSleepTime;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }
}

