/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.monitor;

import com.alibaba.common.lang.StringUtil;
import com.taobao.tddl.common.monitor.TimeComputer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractTimeComputer
implements TimeComputer {
    private List<Date> getDates(Calendar ca) {
        Calendar newCal = (Calendar)ca.clone();
        ArrayList<Date> re = new ArrayList<Date>();
        for (String time : this.getTimes()) {
            String[] pieces = StringUtil.split((String)time, (String)":");
            newCal.set(11, Integer.parseInt(pieces[0]));
            newCal.set(12, Integer.parseInt(pieces[1]));
            newCal.set(13, Integer.parseInt(pieces[2]));
            re.add(newCal.getTime());
        }
        newCal.add(5, 1);
        newCal.set(11, 0);
        newCal.set(12, 0);
        newCal.set(13, 0);
        re.add(newCal.getTime());
        return re;
    }

    private TreeMap<Long, Date> getMostNearTimeIntervalMap(Calendar ca) {
        TreeMap<Long, Date> map = new TreeMap<Long, Date>();
        Date now = ca.getTime();
        List<Date> halfTimes = this.getDates(ca);
        for (Date halfTime : halfTimes) {
            map.put(halfTime.getTime() - now.getTime(), halfTime);
        }
        return map;
    }

    long getMostNearTimeInterval(Calendar ca) {
        TreeMap<Long, Date> map = this.getMostNearTimeIntervalMap(ca);
        for (Map.Entry<Long, Date> entry : map.entrySet()) {
            if (entry.getKey() <= 0L) continue;
            return entry.getKey();
        }
        return map.lastKey();
    }

    @Override
    public long getMostNearTimeInterval() {
        Calendar ca = Calendar.getInstance();
        return this.getMostNearTimeInterval(ca);
    }

    @Override
    public Date getMostNearTime() {
        Calendar ca = Calendar.getInstance();
        return this.getMostNearTime(ca);
    }

    protected Date getMostNearTime(Calendar ca) {
        TreeMap<Long, Date> map = this.getMostNearTimeIntervalMap(ca);
        for (Map.Entry<Long, Date> entry : map.entrySet()) {
            if (entry.getKey() <= 0L) continue;
            return entry.getValue();
        }
        return map.get(map.lastKey());
    }

    abstract List<String> getTimes();
}

