/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.monitor;

import com.taobao.tddl.common.monitor.TimeComputer;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CycleExecuteTimer {
    private Log logger = LogFactory.getLog(CycleExecuteTimer.class);
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private long time;
    private TimeUnit timeUnit;
    private Runnable task;
    private String taskName;
    private volatile boolean isRun;
    private TimeComputer timeComputer;
    private Thread waitThread;

    private CycleExecuteTimer() {
    }

    public CycleExecuteTimer(String taskName, Runnable task, long time, TimeUnit timeUnit, TimeComputer timeComputer) {
        this.time = time;
        this.timeUnit = timeUnit;
        this.task = task;
        this.taskName = taskName;
        this.timeComputer = timeComputer;
    }

    public void start() {
        if (this.isRun) {
            this.logger.warn((Object)(this.taskName + "\u4efb\u52a1\u5df2\u7ecf\u5728\u8fd0\u884c"));
            return;
        }
        this.isRun = true;
        this.rotateExecute();
    }

    private void rotateExecute() {
        long interval = -1L;
        if (this.timeComputer != null) {
            Date startTime = this.timeComputer.getMostNearTime();
            interval = this.timeComputer.getMostNearTimeInterval();
            this.logger.warn((Object)(this.taskName + "\u4efb\u52a1\u5c06\u5728" + startTime + "\u5f00\u59cb\uff0c\u8ddd\u79bb\u5f00\u59cb\u65f6\u95f4\u8fd8\u6709\uff1a" + interval + "\u6beb\u79d2"));
        }
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!CycleExecuteTimer.this.isRun) {
                    CycleExecuteTimer.this.logger.warn((Object)(CycleExecuteTimer.this.taskName + "\u4efb\u52a1\u5df2\u505c\u6b62\u3002"));
                    return;
                }
                try {
                    CycleExecuteTimer.this.task.run();
                }
                catch (Exception e) {
                    CycleExecuteTimer.this.logger.error((Object)(CycleExecuteTimer.this.taskName + "\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff01"), (Throwable)e);
                }
            }
        }, interval == -1L ? 0L : interval, this.time, this.timeUnit);
    }

    public void stop() {
        if (this.waitThread != null) {
            this.waitThread.interrupt();
            this.waitThread = null;
        }
        this.isRun = false;
    }
}

