/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.monitor.stat;

import com.taobao.tddl.common.monitor.stat.StatLogWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractStatLogWriter
extends StatLogWriter {
    protected static ExecutorService flushExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thd = new Thread(r, "BufferedStatLogWriter-Flush-Executor");
            thd.setDaemon(true);
            return thd;
        }
    });
    protected static Timer flushTimer = new Timer("BufferedStatLogWriter-Flush-Timer", true);

    public static class LogCounter
    implements Comparable<LogCounter> {
        private final LogKey logKey;
        private final Object[] fields;
        private final AtomicLong count = new AtomicLong();
        private final AtomicLong value = new AtomicLong();
        private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
        private final AtomicLong max = new AtomicLong(Long.MIN_VALUE);

        public LogCounter(LogKey logKey, Object[] fields) {
            this.logKey = logKey;
            this.fields = fields;
        }

        public final LogKey getLogKey() {
            return this.logKey;
        }

        public final Object[] getFields() {
            return this.fields;
        }

        @Override
        public int compareTo(LogCounter obj) {
            long c2;
            if (this == obj) {
                return 0;
            }
            if (obj == null) {
                return 1;
            }
            long c1 = this.count.get();
            return c1 < (c2 = obj.count.get()) ? -1 : (c1 == c2 ? 0 : 1);
        }

        public void stat(long c, long v) {
            this.count.addAndGet(c);
            this.value.addAndGet(v);
            long vmin = this.min.get();
            while (v < vmin && !this.min.compareAndSet(vmin, v)) {
                vmin = this.min.get();
            }
            long vmax = this.max.get();
            while (v > vmax && this.max.compareAndSet(vmax, v)) {
                vmax = this.max.get();
            }
        }

        public void clear() {
            this.count.lazySet(0L);
            this.value.lazySet(0L);
            this.min.lazySet(Long.MAX_VALUE);
            this.max.lazySet(Long.MIN_VALUE);
        }

        public final long getCount() {
            return this.count.get();
        }

        public final long getValue() {
            return this.value.get();
        }

        public final long getMin() {
            return this.min.get();
        }

        public final long getMax() {
            return this.max.get();
        }

        public long[] getValues() {
            return new long[]{this.count.get(), this.value.get(), this.min.get(), this.max.get()};
        }
    }

    public static final class LogKey
    implements Comparable<LogKey> {
        private final Object[] keys;
        private final int hashCode;

        public LogKey(Object[] keys) {
            this.hashCode = Arrays.hashCode(keys);
            this.keys = keys;
        }

        public Object[] getKeys() {
            return this.keys;
        }

        @Override
        public int compareTo(LogKey obj) {
            if (this == obj) {
                return 0;
            }
            if (obj == null) {
                return 1;
            }
            return ArrayComparator.INSTANCE.compare(this.keys, obj.keys);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogKey other = (LogKey)obj;
            return Arrays.equals(this.keys, other.keys);
        }
    }

    public static final class ArrayComparator
    implements Comparator<Object[]> {
        public static final ArrayComparator INSTANCE = new ArrayComparator();

        @Override
        public int compare(Object[] a1, Object[] a2) {
            if (a1 == a2) {
                return 0;
            }
            if (a1 == null) {
                return -1;
            }
            if (a2 == null) {
                return 1;
            }
            UniversalComparator comparator = UniversalComparator.INSTANCE;
            int min = a1.length < a2.length ? a1.length : a2.length;
            for (int i = 0; i < min; ++i) {
                int cmp = comparator.compare(a1[i], a2[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return a1.length - a2.length;
        }
    }

    public static final class UniversalComparator
    implements Comparator<Object> {
        public static final UniversalComparator INSTANCE = new UniversalComparator();

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getClass() == o2.getClass() && o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return System.identityHashCode(o1) - System.identityHashCode(o2);
        }
    }
}

