/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.monitor.stat;

import com.taobao.tddl.common.monitor.stat.AbstractStatLogWriter;
import com.taobao.tddl.common.monitor.stat.StatLogWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class BufferedLogWriter
extends AbstractStatLogWriter {
    protected static final Logger logger = Logger.getLogger(BufferedLogWriter.class);
    protected volatile int flushInterval = 300;
    protected volatile int minKeySize = 1024;
    protected volatile int maxKeySize = 65536;
    protected volatile ConcurrentHashMap<AbstractStatLogWriter.LogKey, AbstractStatLogWriter.LogCounter> map;
    protected final StatLogWriter nestLog;
    protected volatile TimerTask flushTask = null;
    protected final Lock flushLock = new ReentrantLock();
    protected volatile boolean flushing = false;

    public BufferedLogWriter(int flushInterval, int minKeySize, int maxKeySize, StatLogWriter nestLog) {
        this.map = new ConcurrentHashMap(minKeySize, 0.75f, 32);
        this.flushInterval = flushInterval;
        this.minKeySize = minKeySize;
        this.maxKeySize = maxKeySize;
        this.nestLog = nestLog;
        this.schdeuleFlush();
    }

    public BufferedLogWriter(int minKeySize, int maxKeySize, StatLogWriter nestLog) {
        this.map = new ConcurrentHashMap(minKeySize, 0.75f, 32);
        this.minKeySize = minKeySize;
        this.maxKeySize = maxKeySize;
        this.nestLog = nestLog;
        this.schdeuleFlush();
    }

    public BufferedLogWriter(StatLogWriter nestLog) {
        this.map = new ConcurrentHashMap(this.minKeySize, 0.75f, 32);
        this.nestLog = nestLog;
        this.schdeuleFlush();
    }

    public void setMinKeySize(int minKeySize) {
        this.minKeySize = minKeySize;
    }

    public int getMinKeySize() {
        return this.minKeySize;
    }

    public void setMaxKeySize(int maxKeySize) {
        this.maxKeySize = maxKeySize;
    }

    public int getMaxKeySize() {
        return this.maxKeySize;
    }

    public void setFlushInterval(int flushInterval) {
        if (this.flushInterval != flushInterval) {
            this.flushInterval = flushInterval;
            this.schdeuleFlush();
        }
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    @Override
    public void write(Object[] keys, Object[] fields, long ... values) {
        if (values.length != 2) {
            throw new IllegalArgumentException("Only support 2 values!");
        }
        ConcurrentHashMap<AbstractStatLogWriter.LogKey, AbstractStatLogWriter.LogCounter> map = this.map;
        AbstractStatLogWriter.LogKey logKey = new AbstractStatLogWriter.LogKey(keys);
        AbstractStatLogWriter.LogCounter counter = map.get(logKey);
        if (counter == null) {
            AbstractStatLogWriter.LogCounter newCounter = new AbstractStatLogWriter.LogCounter(logKey, fields == null ? keys : fields);
            newCounter.stat(values[0], values[1]);
            counter = map.putIfAbsent(logKey, newCounter);
            if (counter == null) {
                this.insureMaxSize();
                return;
            }
        }
        counter.stat(values[0], values[1]);
    }

    protected void insureMaxSize() {
        if (this.map.size() > this.maxKeySize) {
            this.flush(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush(final boolean flushAll) {
        if (!this.flushing && this.flushLock.tryLock()) {
            try {
                this.flushing = true;
                flushExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (flushAll) {
                                BufferedLogWriter.this.flushAll();
                            } else {
                                BufferedLogWriter.this.flushLRU();
                            }
                        }
                        finally {
                            BufferedLogWriter.this.flushing = false;
                        }
                    }
                });
            }
            finally {
                this.flushLock.unlock();
            }
            return true;
        }
        return false;
    }

    private final synchronized void schdeuleFlush() {
        TimerTask cancelTask = this.flushTask;
        this.flushTask = new TimerTask(){

            @Override
            public void run() {
                BufferedLogWriter.this.flush(true);
            }
        };
        if (cancelTask != null) {
            cancelTask.cancel();
        }
        long flushPriod = this.flushInterval * 1000;
        flushTimer.scheduleAtFixedRate(this.flushTask, flushPriod, flushPriod);
    }

    private final int flushLog(Map<AbstractStatLogWriter.LogKey, AbstractStatLogWriter.LogCounter> logs) {
        int count = 0;
        for (Map.Entry<AbstractStatLogWriter.LogKey, AbstractStatLogWriter.LogCounter> entry : logs.entrySet()) {
            AbstractStatLogWriter.LogCounter counter = entry.getValue();
            this.nestLog.write(entry.getKey().getKeys(), counter.getFields(), counter.getValues());
            ++count;
        }
        return count;
    }

    private final void flushLog(AbstractStatLogWriter.LogKey logKey, AbstractStatLogWriter.LogCounter counter) {
        this.nestLog.write(logKey.getKeys(), counter.getFields(), counter.getValues());
    }

    protected void flushAll() {
        long flushMillis = System.currentTimeMillis();
        int initKeySize = Math.max(this.minKeySize, (int)((float)this.map.size() / 0.75f));
        ConcurrentHashMap<AbstractStatLogWriter.LogKey, AbstractStatLogWriter.LogCounter> map = this.map;
        this.map = new ConcurrentHashMap(initKeySize, 0.75f, 32);
        LockSupport.parkNanos(5000L);
        int count = this.flushLog(map);
        if (count > 0 && logger.isDebugEnabled()) {
            logger.debug((Object)("flushAll: " + map.size() + " logs in " + (System.currentTimeMillis() - flushMillis) + " milliseconds."));
        }
    }

    protected void flushLRU() {
        AbstractStatLogWriter.LogCounter removed;
        long flushMillis = System.currentTimeMillis();
        ConcurrentHashMap<AbstractStatLogWriter.LogKey, AbstractStatLogWriter.LogCounter> map = this.map;
        int keep = this.maxKeySize * 2 / 3;
        int flush = map.size() - keep;
        int count = 0;
        for (Map.Entry entry : map.entrySet()) {
            if (flush <= 0) break;
            AbstractStatLogWriter.LogKey logKey = (AbstractStatLogWriter.LogKey)entry.getKey();
            AbstractStatLogWriter.LogCounter counter = (AbstractStatLogWriter.LogCounter)entry.getValue();
            if (counter.getCount() >= 2L || (removed = (AbstractStatLogWriter.LogCounter)map.remove(logKey)) == null) continue;
            this.flushLog(logKey, removed);
            --flush;
            ++count;
        }
        if ((flush = map.size() - keep) > 0) {
            Object[] counters = map.values().toArray();
            Arrays.sort(counters);
            for (int i = 0; i < Math.min(flush, counters.length); ++i) {
                AbstractStatLogWriter.LogCounter counter = (AbstractStatLogWriter.LogCounter)counters[i];
                AbstractStatLogWriter.LogKey logKey = counter.getLogKey();
                removed = (AbstractStatLogWriter.LogCounter)map.remove(logKey);
                if (removed == null) continue;
                this.flushLog(logKey, counter);
                ++count;
            }
        }
        if (count > 0 && logger.isDebugEnabled()) {
            logger.debug((Object)("flushLRU: " + count + " logs in " + (System.currentTimeMillis() - flushMillis) + " milliseconds."));
        }
    }
}

