/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.monitor.stat;

import com.taobao.tddl.common.monitor.stat.AbstractStatLogWriter;
import com.taobao.tddl.common.monitor.stat.BufferedLogWriter;
import com.taobao.tddl.common.monitor.stat.StatLogWriter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class SoftRefLogWriter
extends AbstractStatLogWriter {
    protected static final Logger logger = Logger.getLogger(BufferedLogWriter.class);
    protected volatile int flushInterval = 300;
    protected volatile boolean softRef = true;
    protected volatile ConcurrentHashMap<AbstractStatLogWriter.LogKey, Reference<AbstractStatLogWriter.LogCounter>> map;
    private final ReferenceQueue<AbstractStatLogWriter.LogCounter> queue = new ReferenceQueue();
    protected final StatLogWriter nestLog;
    protected volatile TimerTask flushTask = null;
    protected final Lock flushLock = new ReentrantLock();
    protected volatile boolean flushing = false;

    public SoftRefLogWriter(boolean softRef, int flushInterval, StatLogWriter nestLog) {
        this.map = new ConcurrentHashMap(1024, 0.75f, 32);
        this.flushInterval = flushInterval;
        this.softRef = softRef;
        this.nestLog = nestLog;
        this.schdeuleFlush();
    }

    public SoftRefLogWriter(boolean softRef, StatLogWriter nestLog) {
        this.map = new ConcurrentHashMap(1024, 0.75f, 32);
        this.softRef = softRef;
        this.nestLog = nestLog;
        this.schdeuleFlush();
    }

    public SoftRefLogWriter(StatLogWriter nestLog) {
        this.map = new ConcurrentHashMap(1024, 0.75f, 32);
        this.nestLog = nestLog;
        this.schdeuleFlush();
    }

    public void setFlushInterval(int flushInterval) {
        if (this.flushInterval != flushInterval) {
            this.flushInterval = flushInterval;
            this.schdeuleFlush();
        }
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public boolean isSoftRef() {
        return this.softRef;
    }

    public void setSoftRef(boolean softRef) {
        this.softRef = softRef;
    }

    protected final Reference<AbstractStatLogWriter.LogCounter> createLogRef(AbstractStatLogWriter.LogKey logKey, AbstractStatLogWriter.LogCounter counter) {
        return this.softRef ? new SoftRefLogCounter(logKey, counter, this.queue) : new WeakRefLogCounter(logKey, counter, this.queue);
    }

    protected final void expungeLogRef() {
        Reference<AbstractStatLogWriter.LogCounter> entry;
        long expungeMillis = System.currentTimeMillis();
        int count = 0;
        while ((entry = this.queue.poll()) != null) {
            if (entry instanceof SoftRefLogCounter) {
                this.map.remove(((SoftRefLogCounter)entry).logKey);
                ++count;
                continue;
            }
            if (!(entry instanceof WeakRefLogCounter)) continue;
            this.map.remove(((WeakRefLogCounter)entry).logKey);
            ++count;
        }
        if (count > 0 && logger.isDebugEnabled()) {
            logger.debug((Object)("expungeLogRef: " + count + " logs in " + (System.currentTimeMillis() - expungeMillis) + " milliseconds."));
        }
    }

    public AbstractStatLogWriter.LogCounter getCounter(Object[] keys, Object[] fields) {
        ConcurrentHashMap<AbstractStatLogWriter.LogKey, Reference<AbstractStatLogWriter.LogCounter>> map = this.map;
        AbstractStatLogWriter.LogKey logKey = new AbstractStatLogWriter.LogKey(keys);
        while (true) {
            AbstractStatLogWriter.LogCounter newCounter;
            Reference<AbstractStatLogWriter.LogCounter> entry;
            if ((entry = map.get(logKey)) == null && (entry = map.putIfAbsent(logKey, this.createLogRef(logKey, newCounter = new AbstractStatLogWriter.LogCounter(logKey, fields == null ? keys : fields)))) == null) {
                this.expungeLogRef();
                return newCounter;
            }
            AbstractStatLogWriter.LogCounter counter = entry.get();
            if (counter != null) {
                return counter;
            }
            map.remove(logKey);
        }
    }

    @Override
    public void write(Object[] keys, Object[] fields, long ... values) {
        if (values.length != 2) {
            throw new IllegalArgumentException("Only support 2 values!");
        }
        ConcurrentHashMap<AbstractStatLogWriter.LogKey, Reference<AbstractStatLogWriter.LogCounter>> map = this.map;
        AbstractStatLogWriter.LogKey logKey = new AbstractStatLogWriter.LogKey(keys);
        while (true) {
            AbstractStatLogWriter.LogCounter counter;
            Reference<AbstractStatLogWriter.LogCounter> entry;
            if ((entry = map.get(logKey)) == null) {
                AbstractStatLogWriter.LogCounter newCounter = new AbstractStatLogWriter.LogCounter(logKey, fields == null ? keys : fields);
                newCounter.stat(values[0], values[1]);
                entry = map.putIfAbsent(logKey, this.createLogRef(logKey, newCounter));
                if (entry == null) {
                    this.expungeLogRef();
                    return;
                }
            }
            if ((counter = entry.get()) != null) {
                counter.stat(values[0], values[1]);
                return;
            }
            map.remove(logKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush() {
        if (!this.flushing && this.flushLock.tryLock()) {
            try {
                this.flushing = true;
                flushExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            SoftRefLogWriter.this.flushAll();
                        }
                        finally {
                            SoftRefLogWriter.this.flushing = false;
                        }
                    }
                });
            }
            finally {
                this.flushLock.unlock();
            }
            return true;
        }
        return false;
    }

    private final synchronized void schdeuleFlush() {
        TimerTask cancelTask = this.flushTask;
        this.flushTask = new TimerTask(){

            @Override
            public void run() {
                SoftRefLogWriter.this.flush();
            }
        };
        if (cancelTask != null) {
            cancelTask.cancel();
        }
        long flushPriod = this.flushInterval * 1000;
        flushTimer.scheduleAtFixedRate(this.flushTask, flushPriod, flushPriod);
    }

    protected void flushAll() {
        long flushMillis = System.currentTimeMillis();
        this.expungeLogRef();
        ConcurrentHashMap<AbstractStatLogWriter.LogKey, Reference<AbstractStatLogWriter.LogCounter>> map = this.map;
        int count = 0;
        for (Map.Entry<AbstractStatLogWriter.LogKey, Reference<AbstractStatLogWriter.LogCounter>> entry : map.entrySet()) {
            AbstractStatLogWriter.LogCounter counter = entry.getValue().get();
            if (counter == null || counter.getCount() <= 0L) continue;
            AbstractStatLogWriter.LogKey logKey = entry.getKey();
            this.nestLog.write(logKey.getKeys(), counter.getFields(), counter.getValues());
            counter.clear();
            ++count;
        }
        if (count > 0 && logger.isDebugEnabled()) {
            logger.debug((Object)("flushAll: " + count + " logs in " + (System.currentTimeMillis() - flushMillis) + " milliseconds."));
        }
    }

    protected static final class SoftRefLogCounter
    extends SoftReference<AbstractStatLogWriter.LogCounter> {
        final AbstractStatLogWriter.LogKey logKey;

        public SoftRefLogCounter(AbstractStatLogWriter.LogKey logKey, AbstractStatLogWriter.LogCounter counter, ReferenceQueue<AbstractStatLogWriter.LogCounter> queue) {
            super(counter, queue);
            this.logKey = logKey;
        }
    }

    protected static final class WeakRefLogCounter
    extends WeakReference<AbstractStatLogWriter.LogCounter> {
        final AbstractStatLogWriter.LogKey logKey;

        public WeakRefLogCounter(AbstractStatLogWriter.LogKey logKey, AbstractStatLogWriter.LogCounter counter, ReferenceQueue<AbstractStatLogWriter.LogCounter> queue) {
            super(counter, queue);
            this.logKey = logKey;
        }
    }
}

