/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.sequence;

import com.taobao.tddl.common.sequence.LocalEntityResolver;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

public class Config {
    public static final int DEFAULT = 1;
    public static final int Long2DATE = 2;
    private Route tableRoute;
    private Route databaseRoute;
    private boolean positionRight = true;
    private boolean overFlowCheck = true;
    private int totalSize = 0;
    private int type;

    public Route getTableRoute() {
        return this.tableRoute;
    }

    public void setTablerRoute(Route tablerRoute) {
        this.tableRoute = tablerRoute;
    }

    public Route getDatabaseRoute() {
        return this.databaseRoute;
    }

    public void setDatabaseRoute(Route databaseRoute) {
        this.databaseRoute = databaseRoute;
    }

    public void setPositionRight(boolean positionRight) {
        this.positionRight = positionRight;
    }

    public boolean isPositionRight() {
        return this.positionRight;
    }

    public static Config createConfig(Node generator) throws ConfigException {
        Config config = new Config();
        String typeStr = generator.valueOf("@type");
        if (typeStr == null || "".equals(typeStr) || "default".equals(typeStr)) {
            config.setType(1);
        } else if ("long2date".equals(typeStr)) {
            config.setType(2);
        } else {
            throw new ConfigException("unsupported generator type!");
        }
        Node route = generator.selectSingleNode("route");
        if (route != null) {
            Node table;
            String position = route.valueOf("@position");
            if ("right".equals(position) || "".equals(position)) {
                config.setPositionRight(true);
            } else if ("left".equals(position)) {
                config.setPositionRight(false);
            } else {
                throw new ConfigException();
            }
            String overFlowCheckStr = route.valueOf("@overflowcheck");
            if ("on".equals(overFlowCheckStr) || "".equals(overFlowCheckStr)) {
                config.setOverFlowCheck(true);
            } else if ("off".equals(overFlowCheckStr)) {
                config.setOverFlowCheck(false);
            } else {
                throw new ConfigException();
            }
            String totalSizeStr = route.valueOf("@size");
            if (totalSizeStr != null && !"".equals(totalSizeStr)) {
                try {
                    config.setTotalSize(Integer.parseInt(totalSizeStr));
                }
                catch (NumberFormatException e) {
                    throw new ConfigException();
                }
            }
            Node database = route.selectSingleNode("database");
            int routeSize = 0;
            if (database != null) {
                Route dbRoute = new Route();
                try {
                    dbRoute.setSize(Integer.parseInt(database.valueOf("@size")));
                    routeSize += dbRoute.getSize();
                }
                catch (NumberFormatException e) {
                    throw new ConfigException();
                }
                dbRoute.setExpression(Route.ExpressionFactory.create(database.selectSingleNode("*")));
                config.setDatabaseRoute(dbRoute);
            }
            if ((table = route.selectSingleNode("table")) != null) {
                Route tableRoute = new Route();
                try {
                    tableRoute.setSize(Integer.parseInt(table.valueOf("@size")));
                    routeSize += tableRoute.getSize();
                }
                catch (NumberFormatException e) {
                    throw new ConfigException();
                }
                tableRoute.setExpression(Route.ExpressionFactory.create(table.selectSingleNode("*")));
                config.setTablerRoute(tableRoute);
            }
            if (config.isOverFlowCheck() && routeSize > 8) {
                throw new ConfigException("\u6563\u5e93\u6563\u8868\u4fe1\u606f\u6240\u5360\u7528\u7684id\u4f4d\u6570(\u5341\u8fdb\u5236)\u4e0d\u80fd\u8d85\u8fc78");
            }
            if (config.getTotalSize() != 0 && routeSize != 0 && config.getTotalSize() != routeSize) {
                throw new ConfigException();
            }
        }
        return config;
    }

    public void setOverFlowCheck(boolean overFlowCheck) {
        this.overFlowCheck = overFlowCheck;
    }

    public boolean isOverFlowCheck() {
        return this.overFlowCheck;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static class ConfigException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ConfigException() {
        }

        public ConfigException(String msg) {
            super(msg);
        }
    }

    public static class Route {
        private int size;
        private Expression<?> expression;

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public Expression<?> getExpression() {
            return this.expression;
        }

        public void setExpression(Expression<?> expression) {
            this.expression = expression;
        }

        public static class ExpressionFactory {
            static Expression<?> create(Node node) throws ConfigException {
                if (node == null) {
                    return new SimpleExp();
                }
                if ("mod".equals(node.getName())) {
                    try {
                        return new ModExp(Integer.parseInt(node.getText()));
                    }
                    catch (NumberFormatException e) {
                        throw new ConfigException();
                    }
                }
                if ("dayofyear".equals(node.getName())) {
                    return new DayOfYear();
                }
                if ("dayofmonth".equals(node.getName())) {
                    return new DayOfMonth();
                }
                if ("dayofweek".equals(node.getName())) {
                    return new DayOfWeek();
                }
                if ("monthofyear".equals(node.getName())) {
                    return new MonthOfYear();
                }
                if ("dayofweek-sun-is-7".equals(node.getName())) {
                    return new DayOfWeek_sun_is_7();
                }
                if ("monthofyear-january-is-1".equals(node.getName())) {
                    return new MonthOfYear_JanuaryIs1();
                }
                throw new ConfigException();
            }
        }

        public static class MonthOfYear_JanuaryIs1
        extends AbstractExpression<Date> {
            @Override
            public int execute(Date arg) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(arg);
                return cal.get(2) + 1;
            }
        }

        public static class MonthOfYear
        extends AbstractExpression<Date> {
            @Override
            public int execute(Date arg) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(arg);
                return cal.get(2);
            }
        }

        public static class DayOfWeek_sun_is_7
        extends AbstractExpression<Date> {
            @Override
            public int execute(Date arg) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(arg);
                int ret = cal.get(7) - 1;
                if (ret == 0) {
                    ret = 7;
                }
                return ret;
            }
        }

        public static class DayOfWeek
        extends AbstractExpression<Date> {
            @Override
            public int execute(Date arg) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(arg);
                return cal.get(7);
            }
        }

        public static class DayOfMonth
        extends AbstractExpression<Date> {
            @Override
            public int execute(Date arg) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(arg);
                return cal.get(5);
            }
        }

        public static class DayOfYear
        extends AbstractExpression<Date> {
            public boolean isLeapYear(int year) {
                if (year % 4 == 0) {
                    if (year % 100 == 0) {
                        return year % 400 == 0;
                    }
                    return true;
                }
                return false;
            }

            @Override
            public int execute(Date arg) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(arg);
                int dayofyear = cal.get(6);
                return dayofyear;
            }
        }

        public static class ModExp
        extends AbstractExpression<Integer> {
            private int arg0;

            ModExp(int arg0) {
                this.arg0 = arg0;
            }

            @Override
            public int execute(Integer arg) {
                return arg % this.arg0;
            }
        }

        public static class SimpleExp
        extends AbstractExpression<Integer> {
            @Override
            public int execute(Integer arg) {
                return arg;
            }
        }

        public static abstract class AbstractExpression<ArgType>
        implements Expression<ArgType> {
        }

        public static interface Expression<ArgType> {
            public int execute(ArgType var1);
        }
    }

    public static class Factory {
        private Map<String, Config> configs = new TreeMap<String, Config>();

        public Factory(String path) throws DocumentException, ConfigException {
            SAXReader reader = new SAXReader(true);
            reader.setEntityResolver((EntityResolver)new LocalEntityResolver());
            Document root = reader.read(this.getClass().getResource(path));
            List nodes = root.selectNodes("/generators/generator");
            for (Object nodeObj : nodes) {
                Node node = (Node)nodeObj;
                this.configs.put(node.valueOf("@id").toLowerCase(), Config.createConfig(node));
            }
        }

        public Config newInstance(String id) {
            return this.configs.get(id.toLowerCase());
        }
    }
}

