/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.sequence;

import com.taobao.tddl.common.sequence.Config;
import com.taobao.tddl.common.sequence.IDParse;

public class IDParseImp
implements IDParse<Long, Integer, Integer> {
    private Config config;

    public IDParseImp(Config config) {
        this.config = config;
    }

    @Override
    public IDParse.DetachID<Long, Integer, Integer> parse(Long id) {
        int routeBits;
        IDParse.DetachID<Long, Integer, Integer> detachID = new IDParse.DetachID<Long, Integer, Integer>();
        Config.Route dbRoute = this.config.getDatabaseRoute();
        Config.Route tableRoute = this.config.getTableRoute();
        int size = (dbRoute == null ? 0 : dbRoute.getSize()) + (tableRoute == null ? 0 : tableRoute.getSize());
        if (this.config.isPositionRight()) {
            detachID.setId(id / pow10[size]);
            routeBits = (int)(id % pow10[size]);
        } else {
            detachID.setId(size == 0 ? id : id % pow10[19 - size]);
            routeBits = (int)(size == 0 ? 0L : id / pow10[19 - size]);
        }
        if (dbRoute == null) {
            detachID.setDatabaseArg(null);
        } else {
            detachID.setDatabaseArg((int)(tableRoute == null ? (long)routeBits : (long)routeBits / pow10[tableRoute.getSize()]));
        }
        if (tableRoute == null) {
            detachID.setTableArg(null);
        } else {
            detachID.setTableArg((int)((long)routeBits % pow10[tableRoute.getSize()]));
        }
        return detachID;
    }
}

