/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.sync;

import com.taobao.tddl.common.sync.BucketSwitcher;
import com.taobao.tddl.common.sync.NoStrictBucketSwitcher;

public class MatrixBucketSwitcher<T> {
    private final BucketSwitcher.BucketTaker<T> bucketTaker;
    private volatile int bucketSize;
    private volatile Buckets<T> buckets;
    private volatile long checker_time = 150000L;

    public MatrixBucketSwitcher(BucketSwitcher.BucketTaker<T> taker, int bucketSize, int height, int width) {
        this.bucketTaker = taker;
        this.bucketSize = bucketSize;
        this.buckets = new Buckets<T>(this.bucketTaker, bucketSize, height, width);
    }

    public MatrixBucketSwitcher(BucketSwitcher.BucketTaker<T> taker, int bucketSize, int height) {
        this(taker, bucketSize, height, 8);
    }

    public MatrixBucketSwitcher(BucketSwitcher.BucketTaker<T> taker, int bucketSize) {
        this(taker, bucketSize, 4, 8);
    }

    public MatrixBucketSwitcher(BucketSwitcher.BucketTaker<T> taker) {
        this(taker, 64, 4, 8);
    }

    public void pourin(T task, int m, int n) {
        this.buckets.bucketSwitchers[m][n].pourin(task);
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public void setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
    }

    public void setChecker_time(long checker_time) {
        this.checker_time = checker_time;
    }

    public long getChecker_time() {
        return this.checker_time;
    }

    public synchronized void setHeight(int newHeight) {
        Buckets<T> local_buckets = this.buckets;
        if (newHeight == local_buckets.height) {
            return;
        }
        this.buckets = new Buckets<T>(local_buckets, this.bucketTaker, this.bucketSize, newHeight, local_buckets.width);
    }

    public int getHeight() {
        return this.buckets.height;
    }

    public synchronized void setWidth(int newWidth) {
        Buckets<T> local_buckets = this.buckets;
        if (newWidth == local_buckets.width) {
            return;
        }
        this.buckets = new Buckets<T>(local_buckets, this.bucketTaker, this.bucketSize, local_buckets.height, newWidth);
    }

    public synchronized void reSize(int newHeight, int newWidth) {
        Buckets<T> local_buckets = this.buckets;
        if (newHeight == local_buckets.height && newWidth == local_buckets.width) {
            return;
        }
        this.buckets = new Buckets<T>(local_buckets, this.bucketTaker, this.bucketSize, newHeight, newWidth);
    }

    public int getWidth() {
        return this.buckets.width;
    }

    private static class Buckets<T> {
        final int height;
        final int width;
        final NoStrictBucketSwitcher<T>[][] bucketSwitchers;

        Buckets(BucketSwitcher.BucketTaker<T> bucketTaker, int bucketSize, int height, int width) {
            this.height = height;
            this.width = width;
            this.bucketSwitchers = new NoStrictBucketSwitcher[height][];
            for (int i = 0; i < height; ++i) {
                this.bucketSwitchers[i] = new NoStrictBucketSwitcher[width];
                for (int j = 0; j < width; ++j) {
                    this.bucketSwitchers[i][j] = new NoStrictBucketSwitcher<T>(bucketTaker, bucketSize);
                }
            }
        }

        Buckets(Buckets<T> oldBuckets, BucketSwitcher.BucketTaker<T> bucketTaker, int bucketSize, int height, int width) {
            this(bucketTaker, bucketSize, height, width);
            NoStrictBucketSwitcher<T>[][] oldBucketSwitchers = oldBuckets.bucketSwitchers;
            for (int i = 0; i < oldBucketSwitchers.length; ++i) {
                for (int j = 0; j < oldBucketSwitchers[i].length; ++j) {
                    oldBucketSwitchers[i][i].getChecker().interrupt();
                }
            }
        }
    }
}

