/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.sync;

import com.taobao.tddl.common.sync.BucketSwitcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NoStrictBucketSwitcher<T>
implements BucketSwitcher<T> {
    private volatile int bucketSize;
    private final Lock full = new ReentrantLock();
    private final BucketSwitcher.BucketTaker<T> bucketTaker;
    private volatile boolean taked;
    private final Thread checker;
    private volatile long checker_time = 150000L;
    private volatile Bucket<T> bucket;

    public NoStrictBucketSwitcher(BucketSwitcher.BucketTaker<T> taker) {
        this(taker, 64);
    }

    public NoStrictBucketSwitcher(BucketSwitcher.BucketTaker<T> taker, int bucketSize) {
        this.bucketTaker = taker;
        this.bucketSize = bucketSize;
        this.bucket = new Bucket(bucketSize);
        this.checker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    if (!NoStrictBucketSwitcher.this.taked) {
                        Collection fulledBucket = null;
                        NoStrictBucketSwitcher.this.full.lock();
                        try {
                            Bucket local_bucket = NoStrictBucketSwitcher.this.bucket;
                            if (local_bucket.index.get() != 0) {
                                fulledBucket = NoStrictBucketSwitcher.this.takeAway();
                            }
                        }
                        finally {
                            NoStrictBucketSwitcher.this.full.unlock();
                        }
                        if (fulledBucket != null) {
                            NoStrictBucketSwitcher.this.bucketTaker.takeAway(fulledBucket);
                        }
                    }
                    NoStrictBucketSwitcher.this.taked = false;
                    try {
                        1.sleep(NoStrictBucketSwitcher.this.checker_time);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        this.checker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pourin(T task) {
        while (true) {
            Bucket<T> local_bucket = this.bucket;
            int next = local_bucket.index.getAndIncrement();
            if (next < local_bucket.array.length) {
                local_bucket.array[next] = task;
                local_bucket.size.incrementAndGet();
                return;
            }
            Collection<T> fulledBucket = null;
            this.full.lock();
            try {
                local_bucket = this.bucket;
                if (local_bucket.size.get() == local_bucket.array.length) {
                    fulledBucket = this.takeAway();
                }
            }
            finally {
                this.full.unlock();
            }
            if (fulledBucket == null) continue;
            this.bucketTaker.takeAway(fulledBucket);
        }
    }

    protected Collection<T> takeAway() {
        Bucket<T> oldBucket = this.bucket;
        int size = oldBucket.index.get();
        if (size > oldBucket.array.length) {
            size = oldBucket.array.length;
        }
        ArrayList fulledBucket = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object tmp_Item = oldBucket.array[i];
            if (tmp_Item == null) continue;
            fulledBucket.add(tmp_Item);
        }
        this.bucket = new Bucket(this.bucketSize);
        this.taked = true;
        return fulledBucket;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public synchronized void setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
    }

    public synchronized void setChecker_time(long checker_time) {
        this.checker_time = checker_time;
    }

    public long getChecker_time() {
        return this.checker_time;
    }

    public Thread getChecker() {
        return this.checker;
    }

    private static class Bucket<T> {
        final T[] array;
        final AtomicInteger index;
        final AtomicInteger size;

        Bucket(int size) {
            this.array = new Object[size];
            this.index = new AtomicInteger(0);
            this.size = new AtomicInteger(0);
        }
    }
}

