/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.sync;

import com.taobao.tddl.common.sync.BucketSwitcher;
import com.taobao.tddl.common.sync.MatrixBucketSwitcher;
import com.taobao.tddl.common.sync.RowBasedReplicater;
import com.taobao.tddl.common.sync.RowBasedReplicationContext;
import com.taobao.tddl.common.sync.SyncUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import javax.sql.DataSource;

public class RowBasedReplicaterUseIn
extends RowBasedReplicater {
    private volatile int deleteInSize = 1280;
    private volatile int updateInSize = 64;
    private volatile int syncDatabase = 4;
    private volatile int syncTable = 8;
    private volatile Switchers switchers;

    @Override
    public void init() {
        super.init();
        this.switchers = new Switchers(this.deleteSyncLogExecutor, this.deleteInSize, this.updateSyncLogExecutor, this.updateInSize, this.syncDatabase, this.syncTable);
    }

    @Override
    public void onTaskCompleted(RowBasedReplicationContext context, boolean success) {
        DataSource dataSource = context.getSyncLogJdbcTemplate().getDataSource();
        int tableNum = SyncUtils.getSyncLogTableSuffix(context.getSyncLogId());
        Switchers local_switchers = this.switchers;
        int dbNum = local_switchers.getDbNum(dataSource);
        if (success) {
            local_switchers.deleteBucketSwitcher.pourin(context, dbNum, tableNum);
        } else {
            local_switchers.updateBucketSwitcher.pourin(context, dbNum, tableNum);
        }
    }

    public synchronized void setSyncDatabase(int syncDatabase) {
        if (this.syncDatabase == syncDatabase) {
            return;
        }
        this.syncDatabase = syncDatabase;
        if (this.switchers != null) {
            this.switchers = new Switchers(this.deleteSyncLogExecutor, this.deleteInSize, this.updateSyncLogExecutor, this.updateInSize, syncDatabase, this.syncTable);
        }
    }

    public synchronized int getSyncDatabase() {
        return this.syncDatabase;
    }

    public synchronized void setSyncTable(int syncTable) {
        if (this.syncTable == syncTable) {
            return;
        }
        this.syncTable = syncTable;
        if (this.switchers != null) {
            this.switchers = new Switchers(this.deleteSyncLogExecutor, this.deleteInSize, this.updateSyncLogExecutor, this.updateInSize, this.syncDatabase, syncTable);
        }
    }

    public synchronized int getSyncTable() {
        return this.syncTable;
    }

    public synchronized void setUpdateInSize(int updateInSize) {
        this.updateInSize = updateInSize;
    }

    public synchronized int getUpdateInSize() {
        return this.updateInSize;
    }

    public synchronized void setDeleteInSize(int deleteInSize) {
        this.deleteInSize = deleteInSize;
    }

    public synchronized int getDeleteInSize() {
        return this.deleteInSize;
    }

    static class Switchers {
        final MatrixBucketSwitcher<RowBasedReplicationContext> deleteBucketSwitcher;
        final MatrixBucketSwitcher<RowBasedReplicationContext> updateBucketSwitcher;
        final int syncDatabase;
        final int syncTable;
        final Map<DataSource, Integer> databaseMap;
        volatile int actualMapSize;

        Switchers(ThreadPoolExecutor deleteSyncLogExecutor, final int deleteInSize, ThreadPoolExecutor updateSyncLogExecutor, final int updateInSize, int syncDatabase, int syncTable) {
            this.syncDatabase = syncDatabase;
            this.syncTable = syncTable;
            BucketSwitcher.BucketTaker<RowBasedReplicationContext> deleteBucketTaker = new BucketSwitcher.BucketTaker<RowBasedReplicationContext>((ExecutorService)deleteSyncLogExecutor){

                @Override
                public Runnable createTakeAwayTask(Collection<RowBasedReplicationContext> list) {
                    return new RowBasedReplicater.InDeleteSyncLogTask(list, deleteInSize);
                }
            };
            BucketSwitcher.BucketTaker<RowBasedReplicationContext> updateBucketTaker = new BucketSwitcher.BucketTaker<RowBasedReplicationContext>((ExecutorService)updateSyncLogExecutor){

                @Override
                public Runnable createTakeAwayTask(Collection<RowBasedReplicationContext> list) {
                    return new RowBasedReplicater.InUpdateSyncLogTask(list, updateInSize);
                }
            };
            this.deleteBucketSwitcher = new MatrixBucketSwitcher<RowBasedReplicationContext>(deleteBucketTaker, deleteInSize, syncDatabase, syncTable);
            this.updateBucketSwitcher = new MatrixBucketSwitcher<RowBasedReplicationContext>(updateBucketTaker, updateInSize, syncDatabase, syncTable);
            this.databaseMap = new HashMap<DataSource, Integer>(syncDatabase);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int getDbNum(DataSource dataSource) {
            Integer dbNum = null;
            if (this.actualMapSize == this.syncDatabase) {
                dbNum = this.databaseMap.get(dataSource);
            }
            if (dbNum == null) {
                Switchers switchers = this;
                synchronized (switchers) {
                    dbNum = this.databaseMap.get(dataSource);
                    if (dbNum == null) {
                        dbNum = this.actualMapSize;
                        this.databaseMap.put(dataSource, dbNum);
                        ++this.actualMapSize;
                    }
                }
            }
            return dbNum;
        }
    }
}

