/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.sync;

import com.taobao.tddl.client.util.ThreadLocalMap;
import com.taobao.tddl.common.Monitor;
import com.taobao.tddl.common.jdbc.ArgPreparedStatementSetter;
import com.taobao.tddl.common.jdbc.MetaDataQueryForMapHandler;
import com.taobao.tddl.common.jdbc.QueryForMapHandler;
import com.taobao.tddl.common.sync.RowBasedReplicationContext;
import com.taobao.tddl.common.sync.SlaveInfo;
import com.taobao.tddl.common.sync.SyncUtils;
import com.taobao.tddl.interact.rule.bean.DBType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;

public class RowBasedReplicationExecutor {
    private static long timeoutThreshold = 200L;
    private static final Log log = LogFactory.getLog(RowBasedReplicationExecutor.class);
    private static final long masterAbsentReserveTime = 259200000L;
    private static final QueryForMapHandler queryForMapHandler = new MetaDataQueryForMapHandler();
    private static final int extraListSizePlus = 5;

    public static boolean execute(RowBasedReplicationContext context, boolean isDeleteSyncLog) {
        try {
            Map<String, Object> masterRow = RowBasedReplicationExecutor.getMasterRow(context);
            if (masterRow != null) {
                SlaveInfo[] slaves = context.getSlaveInfos();
                boolean[] isReserveSyncLog = new boolean[]{false};
                long timeConsumingInWritingDatabase = 0L;
                for (SlaveInfo slave : slaves) {
                    if (slave.getSlaveDataHandler() != null) {
                        masterRow = slave.getSlaveDataHandler().handle(masterRow, slave);
                    }
                    if (!slave.isAllowSync()) continue;
                    try {
                        long slavetimeConsumingInWritingDatabase = RowBasedReplicationExecutor.sync(context, masterRow, slave);
                        RowBasedReplicationExecutor.profile(null, context, timeoutThreshold, slavetimeConsumingInWritingDatabase, slave.getIdentity());
                        timeConsumingInWritingDatabase += slavetimeConsumingInWritingDatabase;
                    }
                    catch (Exception e) {
                        log.error((Object)"execute exception", (Throwable)e);
                        if (slave.isBreakOnFail()) {
                            return false;
                        }
                        if (!slave.isRetryOnFail()) continue;
                        isReserveSyncLog[0] = true;
                    }
                }
                RowBasedReplicationExecutor.profile(null, context, timeoutThreshold, timeConsumingInWritingDatabase, "");
                if (isDeleteSyncLog && !isReserveSyncLog[0]) {
                    RowBasedReplicationExecutor.deleteSyncLog(context);
                }
                return !isReserveSyncLog[0];
            }
            log.warn((Object)RowBasedReplicationExecutor.messageNotFoundRow("\u4e3b\u5e93\u8bb0\u5f55\u4e0d\u5b58\u5728", context));
            if (new Date().getTime() - context.getCreateTime().getTime() > 259200000L) {
                if (isDeleteSyncLog) {
                    RowBasedReplicationExecutor.deleteSyncLog(context);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error((Object)"execute exception", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getMasterRow(RowBasedReplicationContext context) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuilder whereSql = new StringBuilder("where ").append(context.getPrimaryKeyColumn()).append(" = ?");
        args.add(context.getPrimaryKeyValue());
        if (context.getMasterDatabaseShardColumn() != null && context.getMasterDatabaseShardValue() != null && !context.getMasterDatabaseShardColumn().equalsIgnoreCase(context.getPrimaryKeyColumn())) {
            whereSql.append(" and ").append(context.getMasterDatabaseShardColumn()).append(" = ?");
            args.add(context.getMasterDatabaseShardValue());
        }
        if (context.getMasterTableShardColumn() != null && context.getMasterTableShardValue() != null && !context.getMasterTableShardColumn().equalsIgnoreCase(context.getPrimaryKeyColumn()) && !context.getMasterTableShardColumn().equalsIgnoreCase(context.getMasterDatabaseShardColumn())) {
            whereSql.append(" and ").append(context.getMasterTableShardColumn()).append(" = ?");
            args.add(context.getMasterTableShardValue());
        }
        try {
            ThreadLocalMap.put("DATASOURCE_INDEX", 0);
            Map<String, Object> map = queryForMapHandler.queryForMap(context.getMasterJdbcTemplate(), context.getMasterLogicTableName(), context.getMasterColumns(), whereSql.toString(), args.toArray());
            return map;
        }
        finally {
            ThreadLocalMap.remove("DATASOURCE_INDEX");
        }
    }

    protected static long sync(RowBasedReplicationContext context, Map<String, Object> masterRow, SlaveInfo slave) {
        switch (context.getSqlType()) {
            case INSERT: {
                if (slave.getSlaveReplicater() != null) {
                    long beforeSlaveTime = System.currentTimeMillis();
                    slave.getSlaveReplicater().insertSlaveRow(masterRow, slave);
                    return System.currentTimeMillis() - beforeSlaveTime;
                }
                return RowBasedReplicationExecutor.insertSlaveRow(context, masterRow, slave, false);
            }
            case UPDATE: {
                if (slave.getSlaveReplicater() != null) {
                    long beforeSlaveTime = System.currentTimeMillis();
                    slave.getSlaveReplicater().updateSlaveRow(masterRow, slave);
                    return System.currentTimeMillis() - beforeSlaveTime;
                }
                return RowBasedReplicationExecutor.updateSlaveRow(context, masterRow, slave);
            }
        }
        throw new RuntimeException("\u4e0d\u671f\u671b\u7684SQL\u7c7b\u578b: " + context.getSqlType());
    }

    private static String messageNotFoundRow(String title, RowBasedReplicationContext context) {
        StringBuilder message = new StringBuilder(title);
        message.append(", \u903b\u8f91\u8868\u540d: [").append(context.getMasterLogicTableName());
        message.append("], \u4e3b\u952e: [").append(context.getPrimaryKeyColumn()).append(" = ").append(context.getPrimaryKeyValue());
        message.append("], \u5206\u5e93\u952e: [").append(context.getMasterDatabaseShardColumn()).append(" = ").append(context.getMasterDatabaseShardValue());
        message.append("], \u5206\u8868\u952e: [").append(context.getMasterTableShardColumn()).append(" = ").append(context.getMasterTableShardValue());
        message.append("]");
        return message.toString();
    }

    protected static long insertSlaveRow(RowBasedReplicationContext context, Map<String, Object> masterRow, SlaveInfo slave, boolean throwOnExist) {
        if (slave.isDisableInsert()) {
            return 0L;
        }
        SqlArgs sqlInfo = RowBasedReplicationExecutor.buildSlaveInsertSql(masterRow, slave);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql = [" + sqlInfo.sql + "], args = " + Arrays.asList(sqlInfo.args)));
        }
        long beforeInsertSlaveDBTime = System.currentTimeMillis();
        try {
            slave.getJdbcTemplate().update(sqlInfo.sql, sqlInfo.args);
            return System.currentTimeMillis() - beforeInsertSlaveDBTime;
        }
        catch (DataAccessException e) {
            if (!throwOnExist && e instanceof DataIntegrityViolationException && e.getCause() instanceof SQLException) {
                SyncUtils.SQLExceptionInfo expInfo = SyncUtils.getSqlState((SQLException)e.getCause());
                if (DBType.MYSQL.equals((Object)slave.getDbType()) && 1062 == expInfo.getErrorCode()) {
                    return System.currentTimeMillis() - beforeInsertSlaveDBTime;
                }
                if (DBType.ORACLE.equals((Object)slave.getDbType()) && 1 == expInfo.getErrorCode()) {
                    return System.currentTimeMillis() - beforeInsertSlaveDBTime;
                }
            }
            RowBasedReplicationExecutor.profile(e, context, timeoutThreshold, System.currentTimeMillis() - beforeInsertSlaveDBTime, slave.getIdentity());
            throw e;
        }
    }

    protected static void profile(Throwable e, RowBasedReplicationContext context, long timeoutThreshold, long write2DBConsumingTime, String suffix) {
        long elapsedTime = System.currentTimeMillis() - context.getAfterMainDBSqlExecuteTime();
        long timeConsumingInThreadPool = context.getReplicationStartTime() - context.getAfterMainDBSqlExecuteTime();
        if (e == null) {
            RowBasedReplicationExecutor.successProfile(context, timeoutThreshold, elapsedTime, write2DBConsumingTime, timeConsumingInThreadPool, suffix);
        } else {
            RowBasedReplicationExecutor.exceptionProfile(context, timeoutThreshold, elapsedTime, write2DBConsumingTime, timeConsumingInThreadPool, suffix);
        }
    }

    private static void exceptionProfile(RowBasedReplicationContext context, long timeoutThreshold, long elapsedTime, long write2DBConsumingTime, long timeConsumingInThreadPool, String suffix) {
        Monitor.add(Monitor.buildTableKey1(context.getMasterLogicTableName()), Monitor.buildReplicationSqlKey2(context.getSql()), "COPY_2_SLAVE_EXCEPTION" + suffix, elapsedTime, 1L);
        Monitor.add(Monitor.buildTableKey1(context.getMasterLogicTableName()), Monitor.buildReplicationSqlKey2(context.getSql()), "COPY_2_SLAVE_EXCEPTION_TIME_CONSUMING_IN_THREADPOOL" + suffix, timeConsumingInThreadPool, 1L);
    }

    private static void successProfile(RowBasedReplicationContext context, long timeoutThreshold, long elapsedTime, long write2DBConsumingTime, long timeConsumingInThreadPool, String suffix) {
        if (elapsedTime > timeoutThreshold) {
            Monitor.add(Monitor.buildTableKey1(context.getMasterLogicTableName()), Monitor.buildReplicationSqlKey2(context.getSql()), "COPY_2_SLAVE_TIMEOUT" + suffix, elapsedTime, 1L);
            Monitor.add(Monitor.buildTableKey1(context.getMasterLogicTableName()), Monitor.buildReplicationSqlKey2(context.getSql()), "COPY_2_SLAVE_TIMEOUT_TIME_CONSUMING_IN_THREADPOOL" + suffix, timeConsumingInThreadPool, 1L);
        } else {
            Monitor.add(Monitor.buildTableKey1(context.getMasterLogicTableName()), Monitor.buildReplicationSqlKey2(context.getSql()), "COPY_2_SLAVE_SUCCESS" + suffix, elapsedTime, 1L);
            Monitor.add(Monitor.buildTableKey1(context.getMasterLogicTableName()), Monitor.buildReplicationSqlKey2(context.getSql()), "COPY_2_SLAVE_SUCCESS_TIME_CONSUMING_IN_THREADPOOL" + suffix, timeConsumingInThreadPool, 1L);
        }
    }

    private static PreparedStatementSetter getPss(String tableName, Object[] args, String[] argNames) {
        QueryForMapHandler.TableMetaData tmd = queryForMapHandler.getTableMetaData(tableName);
        if (tmd == null) {
            log.error((Object)("Can't find cached MetaData for table " + tableName));
            return new ArgPreparedStatementSetter(args);
        }
        if (args != null && argNames != null && argNames.length != args.length) {
            log.error((Object)("Parameters length can't match the parameter name length. table:" + tableName + ",args.length:" + args.length + ",argNames.length:" + argNames.length));
            return new ArgPreparedStatementSetter(args);
        }
        QueryForMapHandler.ColumnMetaData[] argMetas = new QueryForMapHandler.ColumnMetaData[argNames.length];
        for (int i = 0; i < argNames.length; ++i) {
            argMetas[i] = tmd.getColumnMetaData(argNames[i]);
        }
        return new QueryForMapHandler.UseCachedMetaDataSetter(argMetas, args);
    }

    private static long updateSlaveRow(RowBasedReplicationContext context, Map<String, Object> masterRow, SlaveInfo slave) {
        if (slave.isDisableUpdate()) {
            Map<String, Object> slaveRow;
            if (slave.isAutoInsert() && (slaveRow = RowBasedReplicationExecutor.getSlaveRow(context, masterRow, slave)) == null) {
                log.warn((Object)RowBasedReplicationExecutor.messageNotFoundRow(slave.getName() + "\u5206\u5e93\u8bb0\u5f55\u4e0d\u5b58\u5728\u81ea\u52a8\u63d2\u5165", context));
                return RowBasedReplicationExecutor.insertSlaveRow(context, masterRow, slave, false);
            }
            return 0L;
        }
        SqlArgs sqlInfo = RowBasedReplicationExecutor.buildSlaveUpdateSql(context, masterRow, slave);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql = [" + sqlInfo.sql + "], args = " + Arrays.asList(sqlInfo.args)));
        }
        long beforeUpdateSlaveDBTime = System.currentTimeMillis();
        if (DBType.ORACLE.equals((Object)slave.getDbType())) {
            PreparedStatementSetter pss = RowBasedReplicationExecutor.getPss(context.getMasterLogicTableName(), sqlInfo.args, sqlInfo.argNames);
            if (slave.getJdbcTemplate().update(sqlInfo.sql, pss) != 0) {
                Monitor.add("TDDL", "Sync", "UpdateSlaveRow_dup_all", 0L, 1L);
                return System.currentTimeMillis() - beforeUpdateSlaveDBTime;
            }
        } else if (slave.getJdbcTemplate().update(sqlInfo.sql, sqlInfo.args) != 0) {
            Monitor.add("TDDL", "Sync", "UpdateSlaveRow_dup_all", 0L, 1L);
            return System.currentTimeMillis() - beforeUpdateSlaveDBTime;
        }
        Map<String, Object> slaveRow = RowBasedReplicationExecutor.getSlaveRow(context, masterRow, slave);
        RuntimeException exc = null;
        if (slaveRow == null) {
            if (slave.isAutoInsert()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)RowBasedReplicationExecutor.messageNotFoundRow(slave.getName() + "\u5206\u5e93\u8bb0\u5f55\u4e0d\u5b58\u5728\u81ea\u52a8\u63d2\u5165", context));
                }
                return RowBasedReplicationExecutor.insertSlaveRow(context, masterRow, slave, true);
            }
            exc = new RuntimeException(RowBasedReplicationExecutor.messageNotFoundRow(slave.getName() + "\u5206\u5e93\u8bb0\u5f55\u4e0d\u5b58\u5728", context));
            RowBasedReplicationExecutor.profile(exc, context, timeoutThreshold, System.currentTimeMillis() - beforeUpdateSlaveDBTime, slave.getIdentity());
            throw exc;
        }
        if (slave.isNoSyncVersion()) {
            return System.currentTimeMillis() - beforeUpdateSlaveDBTime;
        }
        long masterVersion = RowBasedReplicationExecutor.getSyncVersion(masterRow.get("sync_version"));
        long slaveVersion = RowBasedReplicationExecutor.getSyncVersion(slaveRow.get("sync_version"));
        if (slaveVersion >= masterVersion) {
            log.warn((Object)("\u5206\u5e93\u8bb0\u5f55\u7248\u672c\u53f7\u5927\u4e8e\u7b49\u4e8e\u4e3b\u5e93\u8bb0\u5f55\u7248\u672c\u53f7. masterVersion=" + masterVersion + ",slaveVersion=" + slaveVersion + ",PrimaryKeyValue=" + context.getPrimaryKeyValue()));
            Monitor.add("TDDL", "Sync", "UpdateSlaveRow_dup_all", 1L, 1L);
            return System.currentTimeMillis() - beforeUpdateSlaveDBTime;
        }
        exc = new RuntimeException("\u5206\u5e93\u8bb0\u5f55\u7248\u672c\u53f7\u5c0f\u4e8e\u4e3b\u5e93\u8bb0\u5f55\u7248\u672c\u53f7");
        RowBasedReplicationExecutor.profile(exc, context, timeoutThreshold, System.currentTimeMillis() - beforeUpdateSlaveDBTime, slave.getIdentity());
        throw exc;
    }

    private static SqlArgs buildSlaveInsertSql(Map<String, Object> masterRow, SlaveInfo slave) {
        StringBuilder sql = new StringBuilder();
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        Object[] args = null;
        if (slave.getColumns() == null || slave.getColumns().length == 0) {
            args = new Object[masterRow.size()];
            int count = 0;
            for (Map.Entry<String, Object> entry : masterRow.entrySet()) {
                String columnName = entry.getKey();
                if (count > 0) {
                    columns.append(", ");
                    values.append(", ");
                }
                columns.append(columnName);
                values.append("?");
                if (slave.getColumRanges().containsKey(columnName) && entry.getValue() != null && entry.getValue() instanceof Number) {
                    Long value = ((Number)entry.getValue()).longValue();
                    Long[] range = slave.getColumRanges().get(columnName);
                    Long min = range[0];
                    Long max = range[1];
                    if (max != null && value > max) {
                        args[count++] = max;
                        continue;
                    }
                    if (min != null && value < min) {
                        args[count++] = min;
                        continue;
                    }
                    args[count++] = slave.changeToDefaultOnNull(columnName, entry.getValue());
                    continue;
                }
                args[count++] = slave.changeToDefaultOnNull(columnName, entry.getValue());
            }
        } else {
            args = new Object[slave.getColumns().length];
            int count = 0;
            for (String columnName : slave.getColumns()) {
                if (count > 0) {
                    columns.append(", ");
                    values.append(", ");
                }
                columns.append(columnName);
                values.append("?");
                args[count++] = slave.changeToDefaultOnNull(columnName, masterRow.get(columnName));
            }
        }
        sql.append("insert into ").append(slave.getName()).append(" (");
        sql.append((CharSequence)columns).append(") values (").append((CharSequence)values).append(")");
        return new SqlArgs(sql.toString(), args);
    }

    private static SqlArgs buildSlaveUpdateSql(RowBasedReplicationContext context, Map<String, Object> masterRow, SlaveInfo slave) {
        StringBuilder sql = new StringBuilder("update ").append(slave.getName()).append(" set ");
        ArrayList<Object> args = new ArrayList<Object>();
        ArrayList<String> argnames = new ArrayList<String>();
        String[] cols = slave.getColumns();
        Set<String> colomnNames = cols != null && cols.length != 0 ? Arrays.asList(cols) : masterRow.keySet();
        for (String columnName : colomnNames) {
            sql.append(columnName).append("=? ,");
            args.add(slave.changeToDefaultOnNull(columnName, masterRow.get(columnName)));
            argnames.add(columnName);
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" where ").append(context.getPrimaryKeyColumn()).append(" = ?");
        args.add(masterRow.get(context.getPrimaryKeyColumn()));
        argnames.add(context.getPrimaryKeyColumn());
        if (slave.getDatabaseShardColumn() != null && !slave.getDatabaseShardColumn().equalsIgnoreCase(context.getPrimaryKeyColumn())) {
            sql.append(" and ").append(slave.getDatabaseShardColumn()).append(" = ?");
            args.add(masterRow.get(slave.getDatabaseShardColumn()));
            argnames.add(slave.getDatabaseShardColumn());
        }
        if (slave.getTableShardColumn() != null && !slave.getTableShardColumn().equalsIgnoreCase(context.getPrimaryKeyColumn()) && !slave.getTableShardColumn().equalsIgnoreCase(slave.getDatabaseShardColumn())) {
            sql.append(" and ").append(slave.getTableShardColumn()).append(" = ?");
            args.add(masterRow.get(slave.getTableShardColumn()));
            argnames.add(slave.getTableShardColumn());
        }
        if (!slave.isNoSyncVersion()) {
            switch (slave.getDbType()) {
                case MYSQL: {
                    sql.append(" and ifnull(");
                    break;
                }
                case ORACLE: {
                    sql.append(" and nvl(");
                    break;
                }
                default: {
                    throw new RuntimeException("\u6709\u4e86\u65b0\u7684dbType\u800c\u8fd9\u91cc\u6ca1\u6709\u66f4\u65b0");
                }
            }
            sql.append("sync_version").append(", ?)").append(" < ?");
            args.add(0);
            argnames.add("sync_version");
            args.add(masterRow.get("sync_version"));
            argnames.add("sync_version");
        }
        return new SqlArgs(sql.toString(), args, argnames);
    }

    private static SqlArgs buildSlaveSelectSql(RowBasedReplicationContext context, Map<String, Object> masterRow, SlaveInfo slave) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        String selectCols = slave.isNoSyncVersion() ? "1" : "sync_version";
        sql.append("select ").append(selectCols).append(" from ").append(slave.getName());
        sql.append(" where ").append(context.getPrimaryKeyColumn()).append(" = ?");
        args.add(context.getPrimaryKeyValue());
        if (slave.getDatabaseShardColumn() != null && !slave.getDatabaseShardColumn().equalsIgnoreCase(context.getPrimaryKeyColumn())) {
            sql.append(" and ").append(slave.getDatabaseShardColumn()).append(" = ?");
            args.add(masterRow.get(slave.getDatabaseShardColumn()));
        }
        if (slave.getTableShardColumn() != null && !slave.getTableShardColumn().equalsIgnoreCase(context.getPrimaryKeyColumn()) && !slave.getTableShardColumn().equalsIgnoreCase(slave.getDatabaseShardColumn())) {
            sql.append(" and ").append(slave.getTableShardColumn()).append(" = ?");
            args.add(masterRow.get(slave.getTableShardColumn()));
        }
        return new SqlArgs(sql.toString(), args.toArray(new Object[args.size()]));
    }

    private static Map<String, Object> getSlaveRow(RowBasedReplicationContext context, Map<String, Object> masterRow, SlaveInfo slave) {
        SqlArgs sqlInfo = RowBasedReplicationExecutor.buildSlaveSelectSql(context, masterRow, slave);
        if (log.isDebugEnabled()) {
            log.debug((Object)("sql = [" + sqlInfo.sql + "], args = " + Arrays.asList(sqlInfo.args)));
        }
        try {
            return (Map)slave.getJdbcTemplate().queryForObject(sqlInfo.sql, sqlInfo.args, (RowMapper)new InsensitiveColumnMapRowMapper());
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public static void deleteSyncLog(RowBasedReplicationContext context) {
        if (context.getSyncLogId() == null) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("delete from sync_log_").append(SyncUtils.getSyncLogTableSuffix(context.getSyncLogId()));
        sql.append(" where id = ?");
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteSyncLog, sql = [" + sql.toString() + "], args = [" + context.getSyncLogId() + "]"));
        }
        context.getSyncLogJdbcTemplate().update(sql.toString(), new Object[]{context.getSyncLogId()});
    }

    public static void batchDeleteSyncLog(Collection<RowBasedReplicationContext> contexts) {
        long time0 = System.currentTimeMillis();
        String sqlpattern = "delete from sync_log_{0} where id = ?";
        Map<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>> sortedContexts = RowBasedReplicationExecutor.buildSortedContexts(contexts, sqlpattern.toString());
        for (Map.Entry<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>> e0 : sortedContexts.entrySet()) {
            JdbcTemplate jt = e0.getKey();
            for (Map.Entry<String, List<RowBasedReplicationContext>> e : e0.getValue().entrySet()) {
                final List<RowBasedReplicationContext> endContexts = e.getValue();
                BatchPreparedStatementSetter setter = new BatchPreparedStatementSetter(){

                    public int getBatchSize() {
                        return endContexts.size();
                    }

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        RowBasedReplicationContext context = (RowBasedReplicationContext)endContexts.get(i);
                        ps.setString(1, context.getSyncLogId());
                    }
                };
                jt.batchUpdate(e.getKey(), setter);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("[batchDeleteSyncLog], sql = [" + e.getKey() + "], batch size=" + endContexts.size()));
            }
        }
        long timeused = System.currentTimeMillis() - time0;
        log.warn((Object)(contexts.size() + " replication logs deleted, time used:" + timeused));
        Monitor.add("TDDL", "Sync", "BatchDeleteSyncLog", contexts.size(), timeused);
    }

    public static void inDeleteSyncLog(Collection<RowBasedReplicationContext> contexts, int onceSize) {
        onceSize += 5;
        long time0 = System.currentTimeMillis();
        StringBuilder sqlpattern = new StringBuilder("delete from sync_log_{0} where id in (?");
        for (int i = 0; i < onceSize - 1; ++i) {
            sqlpattern.append(", ?");
        }
        sqlpattern.append(")");
        Map<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>> sortedContexts = RowBasedReplicationExecutor.buildSortedContexts(contexts, sqlpattern.toString());
        for (Map.Entry<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>> e0 : sortedContexts.entrySet()) {
            JdbcTemplate jt = e0.getKey();
            for (Map.Entry<String, List<RowBasedReplicationContext>> e : e0.getValue().entrySet()) {
                List<RowBasedReplicationContext> endContexts = e.getValue();
                ArrayList<String> ids = new ArrayList<String>(endContexts.size());
                for (int i = 0; i < endContexts.size(); ++i) {
                    ids.add(endContexts.get(i).getSyncLogId());
                }
                RowBasedReplicationExecutor.updateIn(jt, e.getKey(), ids, onceSize, new Object[0]);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("[inDeleteSyncLog], sql = [" + e.getKey() + "], batch size=" + endContexts.size()));
            }
        }
        long timeused = System.currentTimeMillis() - time0;
        log.warn((Object)(contexts.size() + " replication logs inDeleted, time used:" + timeused));
        Monitor.add("TDDL", "Sync", "BatchDeleteSyncLog", contexts.size(), timeused);
    }

    public static <T> void updateIn(JdbcTemplate template, String sql, List<T> ids, int onceSize, Object ... externArgs) {
        int i;
        Object[] param;
        int index = 0;
        while (index + onceSize <= ids.size()) {
            param = new Object[externArgs.length + onceSize];
            for (i = 0; i < externArgs.length; ++i) {
                param[i] = externArgs[i];
            }
            for (int j = 0; j < onceSize; ++j) {
                param[i++] = ids.get(index++);
            }
            template.update(sql, param);
        }
        if (index == ids.size()) {
            return;
        }
        param = new Object[onceSize];
        for (i = 0; i < externArgs.length; ++i) {
            param[i] = externArgs[i];
        }
        while (i < onceSize && index < ids.size()) {
            param[i] = ids.get(index++);
            ++i;
        }
        while (i < onceSize) {
            param[i] = ids.get(0);
            ++i;
        }
        template.update(sql, param);
    }

    public static void updateSyncLog(RowBasedReplicationContext context, long extraPlusTime) {
        StringBuilder sql = new StringBuilder();
        sql.append("update sync_log_").append(SyncUtils.getSyncLogTableSuffix(context.getSyncLogId()));
        sql.append(" set next_sync_time=? where id = ?");
        Object[] params = new Object[]{RowBasedReplicationExecutor.getNextSyncTime(context, extraPlusTime), context.getSyncLogId()};
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateSyncLog, sql = [" + sql.toString() + "], args = [" + params[0] + "," + params[1] + "]"));
        }
        context.getSyncLogJdbcTemplate().update(sql.toString(), params);
    }

    public static void batchUpdateSyncLog(Collection<RowBasedReplicationContext> contexts, final long extraPlusTime) {
        long time0 = System.currentTimeMillis();
        String sqlpattern = "update sync_log_{0} set next_sync_time=? where id = ?";
        Map<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>> sortedContexts = RowBasedReplicationExecutor.buildSortedContexts(contexts, sqlpattern.toString());
        for (Map.Entry<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>> e0 : sortedContexts.entrySet()) {
            JdbcTemplate jt = e0.getKey();
            for (Map.Entry<String, List<RowBasedReplicationContext>> e : e0.getValue().entrySet()) {
                final List<RowBasedReplicationContext> endContexts = e.getValue();
                BatchPreparedStatementSetter setter = new BatchPreparedStatementSetter(){

                    public int getBatchSize() {
                        return endContexts.size();
                    }

                    public void setValues(PreparedStatement ps, int i) throws SQLException {
                        RowBasedReplicationContext context = (RowBasedReplicationContext)endContexts.get(i);
                        ps.setTimestamp(1, RowBasedReplicationExecutor.getNextSyncTime(context, extraPlusTime));
                        ps.setString(2, context.getSyncLogId());
                    }
                };
                jt.batchUpdate(e.getKey(), setter);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("[batchUpdateSyncLog], sql = [" + e.getKey() + "], batch size=" + endContexts.size()));
            }
        }
        long timeused = System.currentTimeMillis() - time0;
        log.warn((Object)(contexts.size() + " replication logs updated, time used:" + timeused));
        Monitor.add("TDDL", "Sync", "BatchUpdateSyncLog", contexts.size(), timeused);
    }

    public static void inUpdateSyncLog(Collection<RowBasedReplicationContext> contexts, long extraPlusTime, int onceSize) {
        onceSize += 5;
        long time0 = System.currentTimeMillis();
        StringBuilder sqlpattern = new StringBuilder("update sync_log_{0} set next_sync_time=? where id in (?");
        for (int i = 0; i < onceSize - 1; ++i) {
            sqlpattern.append(", ?");
        }
        sqlpattern.append(")");
        Map<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>> sortedContexts = RowBasedReplicationExecutor.buildSortedContexts(contexts, sqlpattern.toString());
        for (Map.Entry<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>> e0 : sortedContexts.entrySet()) {
            JdbcTemplate jt = e0.getKey();
            for (Map.Entry<String, List<RowBasedReplicationContext>> e : e0.getValue().entrySet()) {
                List<RowBasedReplicationContext> endContexts = e.getValue();
                ArrayList<String> ids = new ArrayList<String>(endContexts.size());
                for (int i = 0; i < endContexts.size(); ++i) {
                    ids.add(endContexts.get(i).getSyncLogId());
                }
                RowBasedReplicationExecutor.updateIn(jt, e.getKey(), ids, onceSize, RowBasedReplicationExecutor.getNextSyncTime(endContexts.get(0), extraPlusTime));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("[inUpdateSyncLog], sql = [" + e.getKey() + "], batch size=" + endContexts.size()));
            }
        }
        long timeused = System.currentTimeMillis() - time0;
        log.warn((Object)(contexts.size() + " replication logs inUpdated, time used:" + timeused));
        Monitor.add("TDDL", "Sync", "BatchUpdateSyncLog", contexts.size(), timeused);
    }

    private static Map<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>> buildSortedContexts(Collection<RowBasedReplicationContext> contexts, String sqlpattern) {
        HashMap<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>> sortedContexts = new HashMap<JdbcTemplate, Map<String, List<RowBasedReplicationContext>>>();
        for (RowBasedReplicationContext context : contexts) {
            Map<String, List<RowBasedReplicationContext>> sql2contexts = RowBasedReplicationExecutor.getHashMap(sortedContexts, context.getSyncLogJdbcTemplate());
            String sql = MessageFormat.format(sqlpattern, SyncUtils.getSyncLogTableSuffix(context.getSyncLogId()));
            List<RowBasedReplicationContext> endContexts = RowBasedReplicationExecutor.getArrayList(sql2contexts, sql);
            endContexts.add(context);
        }
        return sortedContexts;
    }

    private static Timestamp getNextSyncTime(RowBasedReplicationContext context, long extraPlusTime) {
        long delay = context.getNextSyncTime().getTime() - context.getCreateTime().getTime();
        return new Timestamp(System.currentTimeMillis() + delay + extraPlusTime);
    }

    private static long getSyncVersion(Object value) {
        long version = 0L;
        if (value != null) {
            if (value instanceof Integer) {
                version = ((Integer)value).longValue();
            } else if (value instanceof Long) {
                version = (Long)value;
            } else if (value instanceof BigInteger) {
                version = ((BigInteger)value).longValue();
            } else if (value instanceof BigDecimal) {
                version = ((BigDecimal)value).longValue();
            } else if (value instanceof Short) {
                version = ((Short)value).longValue();
            } else if (value instanceof Byte) {
                version = ((Byte)value).longValue();
            } else {
                throw new RuntimeException("Unsupported data type [" + value.getClass() + "] of sync_version");
            }
        }
        return version;
    }

    private static <K, V> V getHashMap(Map<K, V> m, K key) {
        Object value = m.get(key);
        if (value == null) {
            value = new HashMap();
            m.put(key, value);
        }
        return value;
    }

    private static <K, V> V getArrayList(Map<K, V> m, K key) {
        Object value = m.get(key);
        if (value == null) {
            value = new ArrayList();
            m.put(key, value);
        }
        return value;
    }

    private static class InsensitiveColumnMapRowMapper
    extends ColumnMapRowMapper {
        private InsensitiveColumnMapRowMapper() {
        }

        protected String getColumnKey(String columnName) {
            return columnName.toLowerCase();
        }

        protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
            return super.getColumnValue(rs, index);
        }
    }

    static class SqlArgs {
        public final String sql;
        public final Object[] args;
        public final String[] argNames;

        public SqlArgs(String sql, Object[] args) {
            this.sql = sql;
            this.args = args;
            this.argNames = null;
        }

        public SqlArgs(String sql, List<Object> args, List<String> argnames) {
            this.sql = sql;
            this.args = args.toArray(new Object[args.size()]);
            this.argNames = argnames.toArray(new String[argnames.size()]);
        }
    }
}

