/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.sync;

import com.taobao.tddl.common.sync.SlaveDataHandler;
import com.taobao.tddl.common.sync.SlaveReplicater;
import com.taobao.tddl.interact.rule.bean.DBType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;

public class SlaveInfo {
    private String name;
    private DBType dbType;
    private String databaseShardColumn;
    private String tableShardColumn;
    private String[] columns;
    private JdbcTemplate jdbcTemplate;
    private String dataSourceName;
    private SlaveReplicater slaveReplicater;
    private String slaveReplicaterName;
    private SlaveDataHandler slaveDataHandler = null;
    private volatile boolean allowSync = true;
    private boolean isDisableUpdate;
    private boolean isDisableInsert;
    private boolean isNoSyncVersion;
    private boolean isAutoInsert;
    private boolean isBreakOnFail = true;
    private boolean isRetryOnFail = true;
    private Map<String, Object> defaultNullValues = Collections.EMPTY_MAP;
    private Map<String, Long[]> columRanges = Collections.EMPTY_MAP;

    public String getIdentity() {
        return "_" + this.dataSourceName + "_" + this.name;
    }

    public void setDefaultValuesOnNull(String defaultValuesOnNull) {
        String[] cols = defaultValuesOnNull.split(",");
        HashMap<String, Object> colvalues = new HashMap<String, Object>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            String col = cols[i];
            String[] nv = col.split("\\:");
            if (nv[1].startsWith("'") && nv[1].endsWith("'")) {
                colvalues.put(nv[0], nv[1].substring(1, nv[1].length() - 1));
                continue;
            }
            colvalues.put(nv[0], Long.parseLong(nv[1]));
        }
        this.defaultNullValues = colvalues;
    }

    public void setColumRestrictRanges(String defaultValuesOnNull) {
        String[] cols = defaultValuesOnNull.split(",");
        HashMap<String, Long[]> colRanges = new HashMap<String, Long[]>(cols.length);
        for (int i = 0; i < cols.length; ++i) {
            String col = cols[i];
            String[] nv = col.split("\\:");
            String[] range = nv[1].split("_");
            Long min = null;
            Long max = null;
            if (range.length == 1) {
                min = Long.parseLong(range[0].trim());
            } else {
                if (!"".equals(range[0].trim())) {
                    min = Long.parseLong(range[0].trim());
                }
                if (!"".equals(range[1].trim())) {
                    max = Long.parseLong(range[1].trim());
                }
            }
            colRanges.put(nv[0], new Long[]{min, max});
        }
        this.columRanges = colRanges;
    }

    public Map<String, Long[]> getColumRanges() {
        return this.columRanges;
    }

    public Map<String, Object> getDefaultNullValues() {
        return this.defaultNullValues;
    }

    public Object changeToDefaultOnNull(String colName, Object value) {
        if (this.defaultNullValues == null) {
            return value;
        }
        if (value != null) {
            return value;
        }
        return this.defaultNullValues.get(colName);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Slave {").append("\n");
        buffer.append("name: ").append(this.name).append("\n");
        buffer.append("dbType: ").append(this.dbType).append("\n");
        buffer.append("dataSourceName: ").append(this.dataSourceName).append("\n");
        if (this.databaseShardColumn != null) {
            buffer.append("databaseShardColumn: ").append(this.databaseShardColumn).append("\n");
        }
        if (this.tableShardColumn != null) {
            buffer.append("tableShardColumn: ").append(this.tableShardColumn).append("\n");
        }
        if (this.columns != null) {
            buffer.append("columns: ").append(Arrays.asList(this.columns)).append("\n");
        }
        buffer.append("}").append("\n");
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.toLowerCase();
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public String getType() {
        return this.dbType == null ? null : this.dbType.toString();
    }

    public void setType(String type) {
        if (type != null) {
            type = type.toUpperCase();
        }
        this.dbType = DBType.valueOf((String)type);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDatabaseShardColumn() {
        return this.databaseShardColumn;
    }

    public void setDatabaseShardColumn(String databaseShardColumn) {
        this.databaseShardColumn = databaseShardColumn.toLowerCase();
    }

    public String getTableShardColumn() {
        return this.tableShardColumn;
    }

    public void setTableShardColumn(String tableShardColumn) {
        this.tableShardColumn = tableShardColumn.toLowerCase();
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = this.columns[i].toLowerCase();
        }
    }

    public void setCommaSeparatedColumns(String commaSeparatedColumns) {
        this.columns = commaSeparatedColumns.split(",");
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = this.columns[i].toLowerCase();
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate slaveJdbcTemplate) {
        this.jdbcTemplate = slaveJdbcTemplate;
    }

    public SlaveReplicater getSlaveReplicater() {
        return this.slaveReplicater;
    }

    public void setSlaveReplicater(SlaveReplicater slaveReplicater) {
        this.slaveReplicater = slaveReplicater;
    }

    public String getSlaveReplicaterName() {
        return this.slaveReplicaterName;
    }

    public void setSlaveReplicaterName(String slaveReplicaterName) {
        this.slaveReplicaterName = slaveReplicaterName;
    }

    public boolean isDisableUpdate() {
        return this.isDisableUpdate;
    }

    public void setDisableUpdate(boolean isDisableUpdate) {
        this.isDisableUpdate = isDisableUpdate;
    }

    public boolean isDisableInsert() {
        return this.isDisableInsert;
    }

    public void setDisableInsert(boolean isDisableInsert) {
        this.isDisableInsert = isDisableInsert;
    }

    public boolean isNoSyncVersion() {
        return this.isNoSyncVersion;
    }

    public void setNoSyncVersion(boolean isNoSyncVersion) {
        this.isNoSyncVersion = isNoSyncVersion;
    }

    public boolean isAutoInsert() {
        return this.isAutoInsert;
    }

    public void setAutoInsert(boolean isAutoInsert) {
        this.isAutoInsert = isAutoInsert;
    }

    public boolean isBreakOnFail() {
        return this.isBreakOnFail;
    }

    public void setBreakOnFail(boolean isBreakOnFail) {
        this.isBreakOnFail = isBreakOnFail;
    }

    public boolean isRetryOnFail() {
        return this.isRetryOnFail;
    }

    public void setRetryOnFail(boolean isRetryOnFail) {
        this.isRetryOnFail = isRetryOnFail;
    }

    public boolean isAllowSync() {
        return this.allowSync;
    }

    public void setAllowSync(boolean allowSync) {
        this.allowSync = allowSync;
    }

    public SlaveDataHandler getSlaveDataHandler() {
        return this.slaveDataHandler;
    }

    public void setSlaveDataHandler(SlaveDataHandler slaveDataHandler) {
        this.slaveDataHandler = slaveDataHandler;
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString("_8".split("_")));
        System.out.println(Arrays.toString("0_".split("_")));
        System.out.println(Arrays.toString("0_9".split("_")));
    }
}

