/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.sync;

import com.taobao.tddl.common.sync.BucketSwitcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class StrictBucketSwitcher<T>
implements BucketSwitcher<T> {
    private volatile int bucketSize;
    private volatile LinkedBlockingQueue<T> bucket;
    private final Lock full = new ReentrantLock();
    private final BucketSwitcher.BucketTaker<T> bucketTaker;
    private volatile boolean taked;
    private Thread checker;
    private volatile long checkerTime = 150000L;

    public StrictBucketSwitcher(BucketSwitcher.BucketTaker<T> taker) {
        this(taker, 64);
    }

    public StrictBucketSwitcher(BucketSwitcher.BucketTaker<T> taker, int bucketSize) {
        this.bucketTaker = taker;
        this.bucketSize = bucketSize;
        this.bucket = new LinkedBlockingQueue();
        this.checker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    if (!StrictBucketSwitcher.this.taked) {
                        Collection fulledBucket = null;
                        StrictBucketSwitcher.this.full.lock();
                        try {
                            if (StrictBucketSwitcher.this.bucket.size() != 0) {
                                fulledBucket = StrictBucketSwitcher.this.takeAway();
                            }
                        }
                        finally {
                            StrictBucketSwitcher.this.full.unlock();
                        }
                        if (fulledBucket != null) {
                            StrictBucketSwitcher.this.bucketTaker.takeAway(fulledBucket);
                        }
                    }
                    StrictBucketSwitcher.this.taked = false;
                    try {
                        1.sleep(StrictBucketSwitcher.this.checkerTime);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        this.checker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pourin(T task) {
        try {
            this.bucket.put(task);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.bucket.size() >= this.bucketSize) {
            Collection<T> fulledBucket = null;
            this.full.lock();
            try {
                if (this.bucket.size() >= this.bucketSize) {
                    fulledBucket = this.takeAway();
                }
            }
            finally {
                this.full.unlock();
            }
            if (fulledBucket != null) {
                this.bucketTaker.takeAway(fulledBucket);
            }
        }
    }

    protected Collection<T> takeAway() {
        int size = this.bucketSize;
        LinkedBlockingQueue<T> local_bucket = this.bucket;
        ArrayList<T> fulledBucket = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            T t = local_bucket.poll();
            if (t == null) continue;
            fulledBucket.add(t);
        }
        this.taked = true;
        return fulledBucket;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public synchronized void setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
    }

    public synchronized void setCheckerTime(long checkerTime) {
        this.checkerTime = checkerTime;
    }

    public long getCheckerTime() {
        return this.checkerTime;
    }
}

