/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.util;

import com.taobao.tddl.common.exception.lru.LRUHashMapException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentLRUHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1089799193141551978L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    final int segmentMask;
    final int segmentShift;
    final Segment<K, V>[] segments;
    static final int RETRIES_BEFORE_LOCK = 2;

    private static int hash(int h) {
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    final Segment<K, V> segmentFor(int hash) {
        return this.segments[hash >>> this.segmentShift & this.segmentMask];
    }

    public ConcurrentLRUHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        int cap;
        int c;
        int ssize;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (concurrencyLevel > 65536) {
            concurrencyLevel = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrencyLevel; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = Segment.newArray(ssize);
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((c = initialCapacity / ssize) * ssize < initialCapacity) {
            ++c;
        }
        for (cap = 1; cap < c; cap <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new Segment(cap, loadFactor);
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentLRUHashMap.hash(key.hashCode());
        try {
            return this.segmentFor(hash).put(key, hash, value, true);
        }
        catch (LRUHashMapException e) {
            e.printStackTrace();
            return value;
        }
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int hash = ConcurrentLRUHashMap.hash(key.hashCode());
        try {
            return this.segmentFor(hash).put(key, hash, value, false);
        }
        catch (LRUHashMapException e) {
            e.printStackTrace();
            return value;
        }
    }

    @Override
    public V get(Object key) {
        int hash = ConcurrentLRUHashMap.hash(key.hashCode());
        return this.segmentFor(hash).get(key, hash);
    }

    @Override
    public int size() {
        Segment<K, V>[] segments = this.segments;
        long sum = 0L;
        long check = 0L;
        int[] mc = new int[segments.length];
        for (int k = 0; k < 2; ++k) {
            int i;
            check = 0L;
            sum = 0L;
            int mcsum = 0;
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
                mc[i] = segments[i].modCount;
                mcsum += mc[i];
            }
            if (mcsum != 0) {
                for (i = 0; i < segments.length; ++i) {
                    check += (long)segments[i].count;
                    if (mc[i] == segments[i].modCount) continue;
                    check = -1L;
                    break;
                }
            }
            if (check == sum) break;
        }
        if (check != sum) {
            int i;
            sum = 0L;
            for (i = 0; i < segments.length; ++i) {
                segments[i].lock();
            }
            for (i = 0; i < segments.length; ++i) {
                sum += (long)segments[i].count;
            }
            for (i = 0; i < segments.length; ++i) {
                segments[i].unlock();
            }
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    @Override
    public V remove(Object key) {
        int hash = ConcurrentLRUHashMap.hash(key.hashCode());
        return this.segmentFor(hash).remove(key, hash, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        int hash = ConcurrentLRUHashMap.hash(key.hashCode());
        if (value == null) {
            return false;
        }
        return this.segmentFor(hash).remove(key, hash, value) != null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return null;
    }

    static class HashEntry<K, V> {
        final K key;
        final int hash;
        volatile V value;
        final HashEntry<K, V> next;
        HashEntry<K, V> linknext;
        HashEntry<K, V> linkpref;
        AtomicBoolean dead;

        HashEntry(K key, int hash, HashEntry<K, V> next, V value, HashEntry<K, V> linknext, HashEntry<K, V> linkpref, AtomicBoolean dead) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
            this.linknext = linknext;
            this.linkpref = linkpref;
            this.dead = dead;
        }

        static final <K, V> HashEntry<K, V>[] newArray(int i) {
            return new HashEntry[i];
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 1L;
        transient int threshold;
        volatile transient int count;
        transient int modCount;
        volatile transient HashEntry<K, V>[] table;
        final transient HashEntry<K, V> header;

        Segment(int initialCapacity, float lf) {
            this.table = HashEntry.newArray(initialCapacity);
            this.threshold = (int)((float)initialCapacity * lf);
            this.count = 0;
            this.header = new HashEntry<Object, Object>(null, -1, null, null, null, null, new AtomicBoolean(false));
            this.header.linknext = this.header;
            this.header.linkpref = this.header;
        }

        static final <K, V> Segment<K, V>[] newArray(int i) {
            return new Segment[i];
        }

        HashEntry<K, V> getFirst(int hash) {
            HashEntry<K, V>[] tab = this.table;
            return tab[hash & tab.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V readValueUnderLock(HashEntry<K, V> e) {
            this.lock();
            try {
                Object v = e.value;
                return v;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void moveNodeToHeader(HashEntry<K, V> e) {
            this.lock();
            try {
                if (!e.dead.get()) {
                    e.linkpref.linknext = e.linknext;
                    e.linknext.linkpref = e.linkpref;
                    this.header.linknext.linkpref = e;
                    e.linknext = this.header.linknext;
                    e.linkpref = this.header;
                    this.header.linknext = e;
                }
            }
            finally {
                this.unlock();
            }
        }

        V get(Object key, int hash) {
            HashEntry<K, V> e = this.getFirst(hash);
            while (e != null) {
                if (e.hash == hash && key.equals(e.key)) {
                    Object v = e.value;
                    this.moveNodeToHeader(e);
                    if (v != null) {
                        return v;
                    }
                    return this.readValueUnderLock(e);
                }
                e = e.next;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeOldNode() throws LRUHashMapException {
            this.lock();
            try {
                int c = this.count;
                HashEntry node = this.header.linkpref;
                if (node == null) {
                    throw new LRUHashMapException("segment\u4e2d\u7684\u9000\u5316\u94fe\u8868\u5d29\u6e83\uff01");
                }
                if (node == this.header) {
                    throw new LRUHashMapException("segment\u4e2d\u9000\u5316\u94fe\u8868\u5df2\u7ecf\u4e3a\u7a7a\uff01");
                }
                if (node.dead.get()) {
                    throw new LRUHashMapException("node\u975e\u6b63\u5e38\u6b7b\u4ea1");
                }
                this.remove(node.key, node.hash, node.value);
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, int hash, V value, boolean onlyIfAbsent) throws LRUHashMapException {
            this.lock();
            try {
                HashEntry<K, V> first;
                int c = this.count;
                if (c >= this.threshold) {
                    this.removeOldNode();
                    c = this.count;
                }
                HashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<K, V> e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null) {
                    Object oldValue = e.value;
                    if (!onlyIfAbsent) {
                        e.value = value;
                        this.moveNodeToHeader(e);
                    }
                } else {
                    Object oldValue = null;
                    ++this.modCount;
                    HashEntry<K, V> newNode = new HashEntry<K, V>(key, hash, first, value, this.header.linknext, this.header, new AtomicBoolean(false));
                    this.header.linknext.linkpref = newNode;
                    this.header.linknext = newNode;
                    tab[index] = newNode;
                    this.count = ++c;
                }
            }
            finally {
                this.unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object key, int hash, Object value) {
            this.lock();
            try {
                HashEntry<K, V> first;
                int c = this.count - 1;
                HashEntry<K, V>[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry<K, V> e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                V oldValue = null;
                if (e != null) {
                    e.dead.set(true);
                    e.linkpref.linknext = e.linknext;
                    e.linknext.linkpref = e.linkpref;
                    Object v = e.value;
                    if (value == null || value.equals(v)) {
                        oldValue = v;
                        ++this.modCount;
                        HashEntry newFirst = e.next;
                        HashEntry<K, V> p = first;
                        while (p != e) {
                            HashEntry newNode = new HashEntry(p.key, p.hash, newFirst, p.value, p.linknext, p.linkpref, new AtomicBoolean(false));
                            p.linknext.linkpref = newNode;
                            p.linkpref.linknext = newNode;
                            p.dead.set(true);
                            newFirst = newNode;
                            p = p.next;
                        }
                        tab[index] = newFirst;
                        this.count = c;
                    }
                }
                V v = oldValue;
                return v;
            }
            finally {
                this.unlock();
            }
        }
    }
}

