/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.util;

import com.taobao.tddl.common.ConfigServerHelper;
import com.taobao.tddl.common.util.SmoothValve;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CountPunisher {
    private static final Log log = LogFactory.getLog(CountPunisher.class);
    private final SmoothValve smoothValve;
    private final long timeWindow;
    private final long limit;
    private final long resetTime;
    private volatile long timeWindowBegin = 0L;
    private volatile long punishBeginTime = Long.MAX_VALUE;
    private final AtomicInteger count = new AtomicInteger();
    private static final String LINE_SEP = System.getProperty("line.separator");

    public CountPunisher(SmoothValve smoothValve, long timeWindow, long limit, long resetTime) {
        this.smoothValve = smoothValve;
        this.timeWindow = timeWindow;
        this.limit = limit;
        this.resetTime = resetTime;
    }

    public CountPunisher(SmoothValve smoothValve, long timeWindow, long limit) {
        this(smoothValve, timeWindow, limit, 30000L);
    }

    public void count() {
        if (this.timeWindow == 0L) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.timeWindowBegin > this.timeWindow) {
            this.resetTimeWindow();
        }
        if (this.timeWindowBegin == 0L) {
            this.timeWindowBegin = now;
        }
        if ((long)this.count.incrementAndGet() >= this.limit) {
            this.punishBeginTime = now;
            this.smoothValve.setNotAvailable();
        }
    }

    private void resetTimeWindow() {
        this.timeWindowBegin = 0L;
        this.count.set(0);
    }

    public boolean punish() {
        if (this.punishBeginTime == Long.MAX_VALUE || this.timeWindow == 0L) {
            return false;
        }
        if (System.currentTimeMillis() - this.punishBeginTime > this.resetTime) {
            this.punishBeginTime = Long.MAX_VALUE;
            this.resetTimeWindow();
            this.smoothValve.setAvailable();
            return false;
        }
        return !this.smoothValve.smoothThroughOnInitial();
    }

    public static CountPunisher parse(SmoothValve smoothValve, String str) {
        str = str.replaceAll("@@@", LINE_SEP);
        str = str.replaceAll("###", LINE_SEP);
        str = str.replaceAll("$$$", LINE_SEP);
        Properties p = ConfigServerHelper.parseProperties(str = str.replaceAll(";;;", LINE_SEP), "[CountPunisher Properties]");
        if (p == null) {
            log.warn((Object)"Empty tddlconfig");
            return null;
        }
        try {
            long timeWindow = -1L;
            long limit = -1L;
            long resetTime = -1L;
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = ((String)entry.getKey()).trim();
                String value = ((String)entry.getValue()).trim();
                switch (CreateProperties.valueOf(key)) {
                    case timeWindow: {
                        timeWindow = Long.parseLong(value);
                        break;
                    }
                    case limit: {
                        limit = Long.parseLong(value);
                        break;
                    }
                    case resetTime: {
                        resetTime = Long.parseLong(value);
                        break;
                    }
                }
            }
            if (timeWindow == -1L || limit == -1L) {
                log.error((Object)"CountPunisher Properties incomplete");
                return null;
            }
            if (resetTime == -1L) {
                return new CountPunisher(smoothValve, timeWindow, limit);
            }
            return new CountPunisher(smoothValve, timeWindow, limit, resetTime);
        }
        catch (Exception e) {
            log.error((Object)"parse CountPunisher Properties failed", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "exceed " + this.limit + " in " + this.timeWindow + "ms, and will reset in " + this.resetTime + "ms";
    }

    public static void main(String[] args) {
        SmoothValve smoothValve = new SmoothValve(20L);
        String config = "CountPunisherProperties=limit=20\\r\\ntimeWindow=3000";
        Properties p = ConfigServerHelper.parseProperties(config, "[tddlConfigListener]");
        String punisherConfig = p.getProperty("CountPunisherProperties");
        CountPunisher countPunisher = CountPunisher.parse(smoothValve, punisherConfig);
        System.out.println(countPunisher);
        smoothValve = new SmoothValve(20L);
        config = "CountPunisherProperties=limit=20@@@timeWindow=3000";
        p = ConfigServerHelper.parseProperties(config, "[tddlConfigListener]");
        punisherConfig = p.getProperty("CountPunisherProperties");
        countPunisher = CountPunisher.parse(smoothValve, punisherConfig);
        System.out.println(countPunisher);
        smoothValve = new SmoothValve(20L);
        config = "CountPunisherProperties=limit=20;;;timeWindow=3000";
        p = ConfigServerHelper.parseProperties(config, "[tddlConfigListener]");
        punisherConfig = p.getProperty("CountPunisherProperties");
        countPunisher = CountPunisher.parse(smoothValve, punisherConfig);
        System.out.println(countPunisher);
    }

    private static enum CreateProperties {
        timeWindow,
        limit,
        resetTime;

    }
}

