/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.util;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.Weighers;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class GoogleConcurrentLruCache<K, V> {
    private ConcurrentLinkedHashMap<K, V> cache;
    private static final int DEFAULT_CAPACITY = 389;
    public static final int DEFAULT_CONCURENCY_LEVEL = 64;
    private AtomicLong get = new AtomicLong(0L);
    private AtomicLong hit = new AtomicLong(0L);

    public GoogleConcurrentLruCache() {
        this(389);
    }

    public GoogleConcurrentLruCache(int capacity) {
        if (capacity <= 0) {
            capacity = 389;
        }
        this.cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)capacity).weigher(Weighers.singleton()).concurrencyLevel(64).build();
    }

    public long capacity() {
        return this.cache.capacity();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        this.cache.clear();
    }

    public V get(Object key) {
        Object v = this.cache.get(key);
        this.get.addAndGet(1L);
        if (v != null) {
            this.hit.addAndGet(1L);
        }
        return (V)v;
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.cache.putIfAbsent(key, value) == null;
    }

    public boolean replace(K key, V old, V value) {
        return this.cache.replace(key, old, value);
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    public Set<K> keySet() {
        return this.cache.keySet();
    }

    public Set<K> hotKeySet(int n) {
        return this.cache.descendingKeySetWithLimit(n);
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("current size:");
        sb.append(this.cache.size());
        sb.append(" get:");
        sb.append(this.get);
        sb.append(" hit:");
        sb.append(this.hit);
        sb.append(" hit ratio:");
        if (this.get.longValue() > 0L) {
            sb.append(this.hit.doubleValue() / this.get.doubleValue() * 100.0);
            sb.append("%");
        } else {
            sb.append("--");
        }
        this.get.set(0L);
        this.hit.set(0L);
        return sb.toString();
    }
}

