/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.util;

import com.taobao.tddl.common.ConfigServerHelper;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmoothValve {
    private static final Log log = LogFactory.getLog(SmoothValve.class);
    private volatile boolean available = true;
    private volatile boolean isInSmooth = false;
    private final AtomicInteger count = new AtomicInteger();
    private final AtomicInteger batchNo = new AtomicInteger();
    private final int[] batchLimits;
    private final AtomicInteger rejectCount = new AtomicInteger();
    private final long timeDelay;
    private volatile long timeBegin;
    private volatile boolean hasRejectInLastBatch = false;

    public SmoothValve(long timeDelay) {
        this.timeDelay = timeDelay;
        this.batchLimits = new int[]{1, 2, 4, 8, 16, 32, 64};
    }

    public SmoothValve(long timeDelay, int[] batchLimits) {
        this.timeDelay = timeDelay;
        this.batchLimits = batchLimits;
    }

    public boolean smoothThroughOnInitial() {
        if (this.timeDelay == 0L) {
            return true;
        }
        while (this.isInSmooth && this.available) {
            int batch = this.batchNo.get();
            if (batch >= this.batchLimits.length) {
                if (this.hasRejectInLastBatch) {
                    this.batchNo.set(this.batchLimits.length - 1);
                    this.hasRejectInLastBatch = false;
                    continue;
                }
                this.isInSmooth = false;
                this.count.set(0);
                this.batchNo.set(0);
                this.rejectCount.set(0);
                return this.available;
            }
            this.hasRejectInLastBatch = false;
            int limit = this.batchLimits[batch];
            if (limit < -1) {
                int randomInt = new Random().nextInt(-limit);
                if (randomInt == 0) {
                    return this.available;
                }
                this.logReject(this.rejectCount, limit);
                return false;
            }
            int current = this.count.get();
            while (current < limit) {
                if (this.count.compareAndSet(current, current + 1)) {
                    this.timeBegin = System.currentTimeMillis();
                    return this.available;
                }
                current = this.count.get();
            }
            if (System.currentTimeMillis() - this.timeBegin > this.timeDelay) {
                this.batchNo.compareAndSet(batch, batch + 1);
                continue;
            }
            this.logReject(this.rejectCount, limit);
            return false;
        }
        return this.available;
    }

    private void logReject(AtomicInteger rejectCount, int limit) {
        this.hasRejectInLastBatch = true;
        int rc = rejectCount.incrementAndGet();
        log.warn((Object)("A request reject in available switch. limit=" + limit + ",rejectCount=" + rc));
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isNotAvailable() {
        return !this.available;
    }

    public void setAvailable() {
        if (this.available) {
            return;
        }
        this.count.set(0);
        this.batchNo.set(0);
        this.isInSmooth = true;
        this.available = true;
    }

    public void setNotAvailable() {
        if (this.available) {
            this.rejectCount.set(0);
            this.available = false;
        }
    }

    public static SmoothValve parse(String str) {
        Properties p = ConfigServerHelper.parseProperties(str, "[SmoothValve Properties]");
        if (p == null) {
            log.warn((Object)"Empty tddlconfig");
            return null;
        }
        try {
            long td = 0L;
            String[] limits = null;
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = ((String)entry.getKey()).trim();
                String value = ((String)entry.getValue()).trim();
                switch (CreateProperties.valueOf(key)) {
                    case timeDelay: {
                        td = Integer.parseInt(value);
                        break;
                    }
                    case batchLimits: {
                        limits = value.split("\\|");
                        break;
                    }
                }
            }
            if (td == 0L) {
                log.error((Object)"SmoothValve Properties incomplete");
                return null;
            }
            if (limits != null) {
                int[] limitArray = new int[limits.length];
                for (int i = 0; i < limits.length; ++i) {
                    limitArray[i] = Integer.parseInt(limits[i].trim());
                }
                return new SmoothValve(td, limitArray);
            }
            return new SmoothValve(td);
        }
        catch (Exception e) {
            log.error((Object)"parse SmoothValve Properties failed", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "timeDelay=" + this.timeDelay + ",batchLimits=" + Arrays.toString(this.batchLimits);
    }

    private static enum CreateProperties {
        timeDelay,
        batchLimits;

    }
}

