/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.util;

import com.taobao.tddl.common.util.DataSourceFetcher;
import com.taobao.tddl.interact.rule.bean.DBType;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringDataSourceFetcher
implements DataSourceFetcher,
ApplicationContextAware {
    private ApplicationContext springContext;
    private DBType dbType = DBType.MYSQL;

    @Override
    public DataSource getDataSource(String key) {
        return (DataSource)this.springContext.getBean(key);
    }

    @Override
    public DBType getDataSourceDBType(String key) {
        return this.dbType;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.springContext = applicationContext;
    }

    public void setDBType(String type) {
        if ("oracle".equalsIgnoreCase(type)) {
            this.dbType = DBType.ORACLE;
        } else if ("mysql".equalsIgnoreCase(type)) {
            this.dbType = DBType.MYSQL;
        } else {
            throw new IllegalArgumentException(type + " \u4e0d\u662f\u6709\u6548\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u53ea\u80fd\u662fmysql\u6216oracle(\u4e0d\u533a\u5206\u5927\u5c0f\u5199)");
        }
    }
}

