/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TDDLMBeanServer {
    private static final Log log = LogFactory.getLog(TDDLMBeanServer.class);
    private static final String LogPrefix = "[TDDLMBeanServer]";
    private MBeanServer mbs;
    private ConcurrentHashMap<String, ConcurrentHashMap<String, AtomicLong>> idMap;
    private ReentrantLock lock;
    public static boolean shutDownMBean = true;

    private TDDLMBeanServer() {
        block7: {
            this.mbs = null;
            this.idMap = new ConcurrentHashMap();
            this.lock = new ReentrantLock();
            String hostName = null;
            try {
                InetAddress addr = InetAddress.getLocalHost();
                hostName = addr.getHostName();
            }
            catch (IOException e) {
                log.error((Object)"[TDDLMBeanServer]Get HostName Error", (Throwable)e);
                hostName = "localhost";
            }
            String host = System.getProperty("hostName", hostName);
            try {
                boolean useJmx = Boolean.parseBoolean(System.getProperty("tddl.useJMX", "true"));
                if (!useJmx) break block7;
                this.mbs = ManagementFactory.getPlatformMBeanServer();
                int port = Integer.parseInt(System.getProperty("tddl.rmi.port", "6679"));
                String rmiName = System.getProperty("tddl.rmi.name", "tddlJmxServer");
                Registry reg = null;
                try {
                    reg = LocateRegistry.getRegistry(port);
                    reg.list();
                }
                catch (Exception e) {
                    reg = null;
                }
                if (null == reg) {
                    reg = LocateRegistry.createRegistry(port);
                }
                reg.list();
                String serverURL = "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/" + rmiName;
                JMXServiceURL url = new JMXServiceURL(serverURL);
                final JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mbs);
                connectorServer.start();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            System.err.println("JMXConnector stop");
                            connectorServer.stop();
                        }
                        catch (IOException e) {
                            log.error((Object)(TDDLMBeanServer.LogPrefix + e));
                        }
                    }
                });
                log.warn((Object)("[TDDLMBeanServer]jmx url: " + serverURL));
            }
            catch (Exception e) {
                log.error((Object)"[TDDLMBeanServer]create MBServer error", (Throwable)e);
            }
        }
    }

    public static void registerMBean(Object o, String name) {
        if (!shutDownMBean) {
            Holder.instance.registerMBean0(o, name);
        }
    }

    public static void registerMBeanWithId(Object o, String id) {
        if (!shutDownMBean) {
            Holder.instance.registerMBeanWithId0(o, id);
        }
    }

    public static void registerMBeanWithIdPrefix(Object o, String idPrefix) {
        if (!shutDownMBean) {
            Holder.instance.registerMBeanWithIdPrefix0(o, idPrefix);
        }
    }

    private void registerMBean0(Object o, String name) {
        if (null != this.mbs) {
            try {
                this.mbs.registerMBean(o, new ObjectName(o.getClass().getPackage().getName() + ":type=" + o.getClass().getSimpleName() + (null == name ? ",id=" + o.hashCode() : ",name=" + name + "-" + o.hashCode())));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void registerMBeanWithId0(Object o, String id) {
        if (null == id || id.length() == 0) {
            throw new IllegalArgumentException("must set id");
        }
        if (null != this.mbs) {
            try {
                this.mbs.registerMBean(o, new ObjectName(o.getClass().getPackage().getName() + ":type=" + o.getClass().getSimpleName() + ",id=" + id));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getId(String name, String idPrefix) {
        AtomicLong indexValue;
        ConcurrentHashMap<String, AtomicLong> subMap = this.idMap.get(name);
        if (null == subMap) {
            this.lock.lock();
            try {
                subMap = this.idMap.get(name);
                if (null == subMap) {
                    subMap = new ConcurrentHashMap();
                    this.idMap.put(name, subMap);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        if (null == (indexValue = subMap.get(idPrefix))) {
            this.lock.lock();
            try {
                indexValue = subMap.get(idPrefix);
                if (null == indexValue) {
                    indexValue = new AtomicLong(0L);
                    subMap.put(idPrefix, indexValue);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        long value = indexValue.incrementAndGet();
        String result = idPrefix + "-" + value;
        return result;
    }

    private void registerMBeanWithIdPrefix0(Object o, String idPrefix) {
        if (null != this.mbs) {
            if (null == idPrefix || idPrefix.length() == 0) {
                idPrefix = "default";
            }
            idPrefix = idPrefix.replace(":", "-");
            try {
                String id = this.getId(o.getClass().getName(), idPrefix);
                this.mbs.registerMBean(o, new ObjectName(o.getClass().getPackage().getName() + ":type=" + o.getClass().getSimpleName() + ",id=" + id));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Holder {
        private static final TDDLMBeanServer instance = new TDDLMBeanServer();

        private Holder() {
        }
    }
}

