/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.common.util;

import java.util.concurrent.atomic.AtomicInteger;

public class TimesliceFlowControl {
    private static final int MAX_SLOT = 20;
    private static final int MIN_SLOT_TIME = 500;
    private final String name;
    private final AtomicInteger[] slots;
    private final int aSlotTimeMillis;
    private final int timesliceMillis;
    private final int timesliceMaxIns;
    private final AtomicInteger total = new AtomicInteger();
    private final AtomicInteger totalReject = new AtomicInteger();
    private volatile int cursor = 0;
    private volatile long cursorTimeMillis = System.currentTimeMillis();

    public TimesliceFlowControl(String name, int aSlotTimeMillis, int slotCount, int timesliceMaxIns) {
        if (slotCount < 2) {
            throw new IllegalArgumentException("slot\u81f3\u5c11\u8981\u6709\u4e24\u4e2a");
        }
        this.name = name;
        this.aSlotTimeMillis = aSlotTimeMillis;
        this.timesliceMillis = aSlotTimeMillis * slotCount;
        this.timesliceMaxIns = timesliceMaxIns;
        this.slots = new AtomicInteger[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = new AtomicInteger(0);
        }
    }

    public TimesliceFlowControl(String name, int timesliceMillis, int timesliceMaxIns) {
        if (timesliceMillis == 0) {
            timesliceMillis = 60000;
        }
        if (timesliceMillis < 1000) {
            throw new IllegalArgumentException("\u65f6\u95f4\u7247\u6700\u5c111000");
        }
        int slotCount = 20;
        int slotTime = timesliceMillis / slotCount;
        if (slotTime < 500) {
            slotTime = 500;
            slotCount = timesliceMillis / slotTime;
        }
        this.name = name;
        this.aSlotTimeMillis = slotTime;
        this.timesliceMillis = this.aSlotTimeMillis * slotCount;
        this.timesliceMaxIns = timesliceMaxIns;
        this.slots = new AtomicInteger[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = new AtomicInteger(0);
        }
    }

    public void check() {
        if (!this.allow()) {
            throw new IllegalStateException(this.reportExceed());
        }
    }

    public String reportExceed() {
        return this.name + " exceed the limit " + this.timesliceMaxIns + " in timeslice " + this.timesliceMillis;
    }

    public boolean allow() {
        long current = System.currentTimeMillis();
        int index = (int)(current % (long)this.timesliceMillis / (long)this.aSlotTimeMillis);
        if (index != this.cursor) {
            int oldCursor = this.cursor;
            this.cursor = index;
            long oldCursorTimeMillis = this.cursorTimeMillis;
            this.cursorTimeMillis = current;
            if (current - oldCursorTimeMillis > (long)this.timesliceMillis) {
                for (int i = 0; i < this.slots.length; ++i) {
                    this.slots[i].set(0);
                }
                this.total.set(0);
            } else {
                do {
                    if (++oldCursor >= this.slots.length) {
                        oldCursor = 0;
                    }
                    this.slots[oldCursor].set(0);
                } while (oldCursor != index);
                int newtotal = 0;
                for (int i = 0; i < this.slots.length; ++i) {
                    newtotal += this.slots[i].get();
                }
                this.total.set(newtotal);
            }
        } else if (current - this.cursorTimeMillis > (long)this.aSlotTimeMillis) {
            this.cursorTimeMillis = current;
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].set(0);
            }
            this.total.set(0);
        }
        if (this.timesliceMaxIns == 0) {
            return true;
        }
        if (this.total.get() < this.timesliceMaxIns) {
            this.slots[index].incrementAndGet();
            this.total.incrementAndGet();
            return true;
        }
        this.totalReject.incrementAndGet();
        return false;
    }

    public int getCurrentCount() {
        return this.total.get();
    }

    public int getTotalRejectCount() {
        return this.totalReject.get();
    }
}

