/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group;

import com.taobao.tddl.interact.rule.bean.DBType;
import com.taobao.tddl.jdbc.group.config.Weight;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceWrapper
implements DataSource {
    private final String dataSourceKey;
    private final String weightStr;
    private final Weight weight;
    private final DataSource wrappedDataSource;
    private final DBType dbType;
    private final int dataSourceIndex;

    public DataSourceWrapper(String dataSourceKey, String weightStr, DataSource wrappedDataSource, DBType dbType, int dataSourceIndex) {
        this.dataSourceKey = dataSourceKey;
        this.weight = new Weight(weightStr);
        this.weightStr = weightStr;
        this.wrappedDataSource = wrappedDataSource;
        this.dbType = dbType;
        this.dataSourceIndex = dataSourceIndex;
    }

    public DataSourceWrapper(String dataSourceKey, String weightStr, DataSource wrappedDataSource, DBType dbType) {
        this(dataSourceKey, weightStr, wrappedDataSource, dbType, -1);
    }

    public boolean isMatchDataSourceIndex(int specifiedIndex) {
        if (this.weight.indexes != null && !this.weight.indexes.isEmpty()) {
            return this.weight.indexes.contains(specifiedIndex);
        }
        return this.dataSourceIndex == specifiedIndex;
    }

    public boolean hasReadWeight() {
        return this.weight.r != 0;
    }

    public boolean hasWriteWeight() {
        return this.weight.w != 0;
    }

    public String toString() {
        return "DataSourceWrapper{dataSourceKey=" + this.dataSourceKey + ", dataSourceIndex=" + this.dataSourceIndex + ",weight=" + this.weight + "}";
    }

    public String getDataSourceKey() {
        return this.dataSourceKey;
    }

    public String getWeightStr() {
        return this.weightStr;
    }

    public Weight getWeight() {
        return this.weight;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public DataSource getWrappedDataSource() {
        return this.wrappedDataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.wrappedDataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.wrappedDataSource.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.wrappedDataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.wrappedDataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.wrappedDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.wrappedDataSource.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getClass().isAssignableFrom(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return (T)this;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }
}

