/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group;

import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.TGroupCallableStatement;
import com.taobao.tddl.jdbc.group.TGroupDataSource;
import com.taobao.tddl.jdbc.group.TGroupDatabaseMetaData;
import com.taobao.tddl.jdbc.group.TGroupPreparedStatement;
import com.taobao.tddl.jdbc.group.TGroupStatement;
import com.taobao.tddl.jdbc.group.ThreadLocalDataSourceIndex;
import com.taobao.tddl.jdbc.group.dbselector.DBSelector;
import com.taobao.tddl.jdbc.group.util.ExceptionUtils;
import com.taobao.tddl.jdbc.group.util.GroupHintParser;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TGroupConnection
implements Connection {
    private static final Log log = LogFactory.getLog(TGroupConnection.class);
    private TGroupDataSource tGroupDataSource;
    private String username;
    private String password;
    private Connection rBaseConnection;
    private Connection wBaseConnection;
    private DataSourceWrapper rBaseDsWrapper;
    private DataSourceWrapper wBaseDsWrapper;
    private Set<TGroupStatement> openedStatements = new HashSet<TGroupStatement>(2);
    private boolean closed;
    private DBSelector.DataSourceTryer<CallableStatement> getCallableStatementTryer = new DBSelector.AbstractDataSourceTryer<CallableStatement>(){

        @Override
        public CallableStatement tryOnDataSource(DataSourceWrapper dsw, Object ... args) throws SQLException {
            String sql = (String)args[0];
            int resultSetType = (Integer)args[1];
            int resultSetConcurrency = (Integer)args[2];
            int resultSetHoldability = (Integer)args[3];
            Connection conn = TGroupConnection.this.createNewConnection(dsw, false);
            return TGroupConnection.this.getCallableStatement(conn, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
    };
    private boolean isAutoCommit = true;
    private int transactionIsolation = -1;

    public TGroupConnection(TGroupDataSource tGroupDataSource) {
        this.tGroupDataSource = tGroupDataSource;
    }

    public TGroupConnection(TGroupDataSource tGroupDataSource, String username, String password) {
        this(tGroupDataSource);
        this.username = username;
        this.password = password;
    }

    Connection getBaseConnection(String sql, boolean isRead) throws SQLException {
        int dataSourceIndex = -1;
        if (sql == null) {
            dataSourceIndex = ThreadLocalDataSourceIndex.getIndex();
        } else {
            dataSourceIndex = GroupHintParser.convertHint2Index(sql);
            if (dataSourceIndex < 0) {
                dataSourceIndex = ThreadLocalDataSourceIndex.getIndex();
            }
        }
        if (dataSourceIndex != -1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("dataSourceIndex=" + dataSourceIndex));
            }
            if (!this.isAutoCommit && this.wBaseDsWrapper != null && !this.wBaseDsWrapper.isMatchDataSourceIndex(dataSourceIndex)) {
                throw new SQLException("Transaction in another dataSourceIndex: " + dataSourceIndex);
            }
            if (isRead) {
                if (this.rBaseDsWrapper != null && !this.rBaseDsWrapper.isMatchDataSourceIndex(dataSourceIndex)) {
                    this.closeReadConnection();
                }
            } else if (this.wBaseDsWrapper != null && !this.wBaseDsWrapper.isMatchDataSourceIndex(dataSourceIndex)) {
                this.closeWriteConnection();
            }
        }
        if (isRead && this.isAutoCommit) {
            return this.wBaseConnection != null && this.wBaseDsWrapper.hasReadWeight() ? this.wBaseConnection : this.rBaseConnection;
        }
        if (this.wBaseConnection != null) {
            this.tGroupDataSource.setWriteTarget(this.wBaseDsWrapper);
            return this.wBaseConnection;
        }
        if (this.rBaseConnection != null && this.rBaseDsWrapper.hasWriteWeight()) {
            this.wBaseConnection = this.rBaseConnection;
            if (this.wBaseConnection.getAutoCommit() != this.isAutoCommit) {
                this.wBaseConnection.setAutoCommit(this.isAutoCommit);
            }
            this.wBaseDsWrapper = this.rBaseDsWrapper;
            this.tGroupDataSource.setWriteTarget(this.wBaseDsWrapper);
            return this.wBaseConnection;
        }
        return null;
    }

    Connection createNewConnection(DataSourceWrapper dsw, boolean isRead) throws SQLException {
        Connection conn = this.username != null ? dsw.getConnection(this.username, this.password) : dsw.getConnection();
        this.setBaseConnection(conn, dsw, isRead && this.isAutoCommit);
        if (!isRead || !this.isAutoCommit) {
            conn.setAutoCommit(this.isAutoCommit);
        }
        return conn;
    }

    private void setBaseConnection(Connection baseConnection, DataSourceWrapper dsw, boolean isRead) {
        if (baseConnection == null) {
            log.warn((Object)"setBaseConnection to null !!");
        }
        if (isRead) {
            this.closeReadConnection();
        } else {
            this.closeWriteConnection();
        }
        if (isRead) {
            this.rBaseConnection = baseConnection;
            this.rBaseDsWrapper = dsw;
        } else {
            this.wBaseConnection = baseConnection;
            this.wBaseDsWrapper = dsw;
            this.tGroupDataSource.setWriteTarget(dsw);
        }
    }

    private void closeReadConnection() {
        if (this.rBaseConnection != null && this.rBaseConnection != this.wBaseConnection) {
            try {
                this.rBaseConnection.close();
            }
            catch (SQLException e) {
                log.error((Object)"close rBaseConnection failed.", (Throwable)e);
            }
            this.rBaseDsWrapper = null;
            this.rBaseConnection = null;
        }
    }

    private void closeWriteConnection() {
        if (this.wBaseConnection != null && this.rBaseConnection != this.wBaseConnection) {
            try {
                this.wBaseConnection.close();
            }
            catch (SQLException e) {
                log.error((Object)"close wBaseConnection failed.", (Throwable)e);
            }
            this.wBaseDsWrapper = null;
            this.wBaseConnection = null;
        }
    }

    void removeOpenedStatements(Statement statement) {
        if (!this.openedStatements.remove(statement)) {
            log.warn((Object)("current statmenet \uff1a" + statement + " doesn't exist!"));
        }
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("No operations allowed after connection closed.");
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        try {
            for (TGroupStatement stmt : this.openedStatements) {
                try {
                    stmt.close(false);
                }
                catch (SQLException e) {
                    exceptions.add(e);
                }
            }
            try {
                if (this.rBaseConnection != null && !this.rBaseConnection.isClosed()) {
                    this.rBaseConnection.close();
                }
            }
            catch (SQLException e) {
                exceptions.add(e);
            }
            try {
                if (this.wBaseConnection != null && !this.wBaseConnection.isClosed()) {
                    this.wBaseConnection.close();
                }
            }
            catch (SQLException e) {
                exceptions.add(e);
            }
        }
        finally {
            this.openedStatements.clear();
            this.rBaseConnection = null;
            this.wBaseConnection = null;
            ThreadLocalDataSourceIndex.clearIndex();
        }
        ExceptionUtils.throwSQLException(exceptions, "close tconnection", (List<Object>)Collections.EMPTY_LIST);
    }

    @Override
    public TGroupStatement createStatement() throws SQLException {
        this.checkClosed();
        TGroupStatement stmt = new TGroupStatement(this.tGroupDataSource, this);
        this.openedStatements.add(stmt);
        return stmt;
    }

    @Override
    public TGroupStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        TGroupStatement stmt = this.createStatement();
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    @Override
    public TGroupStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TGroupStatement stmt = this.createStatement(resultSetType, resultSetConcurrency);
        stmt.setResultSetHoldability(resultSetHoldability);
        return stmt;
    }

    @Override
    public TGroupPreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        TGroupPreparedStatement stmt = new TGroupPreparedStatement(this.tGroupDataSource, this, sql);
        this.openedStatements.add(stmt);
        return stmt;
    }

    @Override
    public TGroupPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        TGroupPreparedStatement stmt = this.prepareStatement(sql);
        stmt.setResultSetType(resultSetType);
        stmt.setResultSetConcurrency(resultSetConcurrency);
        return stmt;
    }

    @Override
    public TGroupPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        TGroupPreparedStatement stmt = this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        stmt.setResultSetHoldability(resultSetHoldability);
        return stmt;
    }

    @Override
    public TGroupPreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        TGroupPreparedStatement stmt = this.prepareStatement(sql);
        stmt.setAutoGeneratedKeys(autoGeneratedKeys);
        return stmt;
    }

    @Override
    public TGroupPreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        TGroupPreparedStatement stmt = this.prepareStatement(sql);
        stmt.setColumnIndexes(columnIndexes);
        return stmt;
    }

    @Override
    public TGroupPreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        TGroupPreparedStatement stmt = this.prepareStatement(sql);
        stmt.setColumnNames(columnNames);
        return stmt;
    }

    private CallableStatement getCallableStatement(Connection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType == Integer.MIN_VALUE) {
            return conn.prepareCall(sql);
        }
        if (resultSetHoldability == Integer.MIN_VALUE) {
            return conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        return conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public TGroupCallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement target;
        this.checkClosed();
        Connection conn = this.getBaseConnection(sql, false);
        if (conn != null) {
            sql = GroupHintParser.removeTddlGroupHint(sql);
            target = this.getCallableStatement(conn, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        } else {
            Integer dataSourceIndex = GroupHintParser.convertHint2Index(sql);
            sql = GroupHintParser.removeTddlGroupHint(sql);
            if (dataSourceIndex < 0) {
                dataSourceIndex = ThreadLocalDataSourceIndex.getIndex();
            }
            target = this.tGroupDataSource.getDBSelector(false).tryExecute(null, this.getCallableStatementTryer, this.tGroupDataSource.getRetryingTimes(), sql, resultSetType, resultSetConcurrency, resultSetHoldability, dataSourceIndex);
        }
        TGroupCallableStatement stmt = new TGroupCallableStatement(this.tGroupDataSource, this, target, sql);
        if (resultSetType != Integer.MIN_VALUE) {
            stmt.setResultSetType(resultSetType);
            stmt.setResultSetConcurrency(resultSetConcurrency);
        }
        if (resultSetHoldability != Integer.MIN_VALUE) {
            stmt.setResultSetHoldability(resultSetHoldability);
        }
        this.openedStatements.add(stmt);
        return stmt;
    }

    @Override
    public TGroupCallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public TGroupCallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, Integer.MIN_VALUE);
    }

    @Override
    public void setAutoCommit(boolean autoCommit0) throws SQLException {
        this.checkClosed();
        if (this.isAutoCommit == autoCommit0) {
            return;
        }
        this.isAutoCommit = autoCommit0;
        if (this.wBaseConnection != null) {
            this.wBaseConnection.setAutoCommit(autoCommit0);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.isAutoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        if (this.isAutoCommit) {
            return;
        }
        if (this.wBaseConnection != null) {
            try {
                this.wBaseConnection.commit();
            }
            catch (SQLException e) {
                log.error((Object)("Commit failed on " + this.wBaseDsWrapper.getDataSourceKey() + ":" + e.getMessage()));
                throw e;
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        if (this.isAutoCommit) {
            return;
        }
        if (this.wBaseConnection != null) {
            try {
                this.wBaseConnection.rollback();
            }
            catch (SQLException e) {
                log.error((Object)("Rollback failed on " + this.wBaseDsWrapper.getDataSourceKey() + ":" + e.getMessage()));
                throw e;
            }
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int transactionIsolation) throws SQLException {
        this.checkClosed();
        this.transactionIsolation = transactionIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        if (this.rBaseConnection != null) {
            return this.rBaseConnection.getWarnings();
        }
        if (this.wBaseConnection != null) {
            return this.wBaseConnection.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        if (this.rBaseConnection != null) {
            this.rBaseConnection.clearWarnings();
        }
        if (this.wBaseConnection != null) {
            this.wBaseConnection.clearWarnings();
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.rBaseConnection != null) {
            return this.rBaseConnection.getMetaData();
        }
        if (this.wBaseConnection != null) {
            return this.wBaseConnection.getMetaData();
        }
        return new TGroupDatabaseMetaData(this, this.tGroupDataSource);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("rollback");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException("setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException("setSavepoint");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException("releaseSavepoint");
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new UnsupportedOperationException("getCatalog");
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new UnsupportedOperationException("setCatalog");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 2;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException("setHoldability");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException("getTypeMap");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("setTypeMap");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException("nativeSQL");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getClass().isAssignableFrom(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return (T)this;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new RuntimeException("not support exception");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new RuntimeException("not support exception");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("not support exception");
    }
}

