/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group;

import com.taobao.tddl.client.util.DataSourceType;
import com.taobao.tddl.common.DataSourceChangeListener;
import com.taobao.tddl.common.util.DataSourceFetcher;
import com.taobao.tddl.common.util.TDDLMBeanServer;
import com.taobao.tddl.interact.rule.bean.DBType;
import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.TGroupConnection;
import com.taobao.tddl.jdbc.group.config.ConfigManager;
import com.taobao.tddl.jdbc.group.dbselector.DBSelector;
import com.taobao.tddl.jdbc.group.exception.TGroupDataSourceException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class TGroupDataSource
implements DataSource {
    private ConfigManager configManager;
    private String dsKeyAndWeightCommaArray;
    private DataSourceFetcher dataSourceFetcher;
    private DBType dbType = DBType.MYSQL;
    private static ThreadLocal<DataSourceWrapper> targetThreadLocal;
    private PrintWriter out = null;
    private int seconds = 0;
    private DataSourceType dataSourceType = DataSourceType.TbDataSource;
    private String appName;
    private String dbGroupKey;
    private String fullDbGroupKey = null;
    private int retryingTimes = 3;
    private long configReceiveTimeout = 10000L;
    private boolean autoSelectWriteDataSource = false;
    private static String VERSION;
    private static String PREFIX;
    private static String EXTRA_PREFIX;

    public TGroupDataSource() {
    }

    public TGroupDataSource(String dbGroupKey, String appName) {
        this.dbGroupKey = dbGroupKey;
        this.appName = appName;
    }

    public TGroupDataSource(String dbGroupKey, String appName, DataSourceType dataSourceType) {
        this.dbGroupKey = dbGroupKey;
        this.appName = appName;
        this.dataSourceType = dataSourceType;
    }

    public void init() {
        if (this.dsKeyAndWeightCommaArray != null) {
            DataSourceFetcher wrapper = new DataSourceFetcher(){

                public DataSource getDataSource(String key) {
                    return TGroupDataSource.this.dataSourceFetcher.getDataSource(key);
                }

                public DBType getDataSourceDBType(String key) {
                    DBType type = TGroupDataSource.this.dataSourceFetcher.getDataSourceDBType(key);
                    return type == null ? TGroupDataSource.this.dbType : type;
                }
            };
            List<DataSourceWrapper> dss = ConfigManager.buildDataSourceWrapper(this.dsKeyAndWeightCommaArray, wrapper);
            this.init(dss);
        } else {
            this.checkProperties();
            this.configManager = new ConfigManager(this);
            this.configManager.init();
        }
    }

    public void init(DataSourceWrapper ... dataSourceWrappers) {
        this.init(Arrays.asList(dataSourceWrappers));
    }

    public void init(List<DataSourceWrapper> dataSourceWrappers) {
        this.configManager = new ConfigManager(this);
        this.configManager.init(dataSourceWrappers);
    }

    public static TGroupDataSource build(String groupKey, String dsWeights, DataSourceFetcher fetcher, DataSourceType dataSourceType) {
        List<DataSourceWrapper> dss = ConfigManager.buildDataSourceWrapper(dsWeights, fetcher);
        TGroupDataSource tGroupDataSource = new TGroupDataSource();
        tGroupDataSource.setDataSourceType(dataSourceType);
        tGroupDataSource.setDbGroupKey(groupKey);
        tGroupDataSource.init(dss);
        return tGroupDataSource;
    }

    private void checkProperties() {
        if (this.dbGroupKey == null) {
            throw new TGroupDataSourceException("dbGroupKey\u4e0d\u80fd\u4e3anull");
        }
        this.dbGroupKey = this.dbGroupKey.trim();
        if (this.dbGroupKey.length() < 1) {
            throw new TGroupDataSourceException("dbGroupKey\u7684\u957f\u5ea6\u8981\u5927\u4e8e0\uff0c\u524d\u5bfc\u7a7a\u767d\u548c\u5c3e\u90e8\u7a7a\u767d\u4e0d\u7b97\u5728\u5185");
        }
        if (this.appName == null) {
            throw new TGroupDataSourceException("appName\u4e0d\u80fd\u4e3anull");
        }
        this.appName = this.appName.trim();
        if (this.appName.length() < 1) {
            throw new TGroupDataSourceException("appName\u7684\u957f\u5ea6\u8981\u5927\u4e8e0\uff0c\u524d\u5bfc\u7a7a\u767d\u548c\u5c3e\u90e8\u7a7a\u767d\u4e0d\u7b97\u5728\u5185");
        }
        if (this.dataSourceType == null) {
            throw new TGroupDataSourceException("dataSouceType\u4e0d\u80fd\u4e3anull");
        }
    }

    public void resetDbGroup(String configInfo) {
        this.configManager.resetDbGroup(configInfo);
    }

    DBSelector getDBSelector(boolean isRead) {
        return this.configManager.getDBSelector(isRead, this.autoSelectWriteDataSource);
    }

    public void setTracerWriteTarget(boolean isTraceTarget) {
        if (isTraceTarget) {
            if (targetThreadLocal == null) {
                targetThreadLocal = new ThreadLocal();
            }
        } else {
            targetThreadLocal = null;
        }
    }

    public DataSourceWrapper getCurrentTarget() {
        if (targetThreadLocal == null) {
            return null;
        }
        DataSourceWrapper dsw = targetThreadLocal.get();
        targetThreadLocal.remove();
        return dsw;
    }

    void setWriteTarget(DataSourceWrapper dsw) {
        if (targetThreadLocal != null) {
            targetThreadLocal.set(dsw);
        }
    }

    public Map<String, DataSource> getDataSourceMap() {
        LinkedHashMap<String, DataSource> dsMap = new LinkedHashMap<String, DataSource>();
        dsMap.putAll(this.getDBSelector(true).getDataSources());
        dsMap.putAll(this.getDBSelector(false).getDataSources());
        return dsMap;
    }

    public Map<String, DataSource> getDataSourcesMap(boolean isRead) {
        return this.getDBSelector(isRead).getDataSources();
    }

    public void setDataSourceChangeListener(DataSourceChangeListener dataSourceChangeListener) {
        this.configManager.setDataSourceChangeListener(dataSourceChangeListener);
    }

    @Override
    public TGroupConnection getConnection() throws SQLException {
        return new TGroupConnection(this);
    }

    @Override
    public TGroupConnection getConnection(String username, String password) throws SQLException {
        return new TGroupConnection(this, username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.out;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.out = out;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.seconds;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.seconds = seconds;
    }

    public static void setShutDownMBean(boolean shutDownMBean) {
        TDDLMBeanServer.shutDownMBean = shutDownMBean;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getDbGroupKey() {
        return this.dbGroupKey;
    }

    public String getFullDbGroupKey() {
        if (this.fullDbGroupKey == null) {
            this.fullDbGroupKey = PREFIX + this.getDbGroupKey();
        }
        return this.fullDbGroupKey;
    }

    public String getDbGroupExtraConfigKey() {
        return EXTRA_PREFIX + this.getDbGroupKey() + "." + this.getAppName();
    }

    public void setDbGroupKey(String dbGroupKey) {
        this.dbGroupKey = dbGroupKey;
    }

    public int getRetryingTimes() {
        return this.retryingTimes;
    }

    public void setRetryingTimes(int retryingTimes) {
        this.retryingTimes = retryingTimes;
    }

    public long getConfigReceiveTimeout() {
        return this.configReceiveTimeout;
    }

    public void setConfigReceiveTimeout(long configReceiveTimeout) {
        this.configReceiveTimeout = configReceiveTimeout;
    }

    public void setDsKeyAndWeightCommaArray(String dsKeyAndWeightCommaArray) {
        this.dsKeyAndWeightCommaArray = dsKeyAndWeightCommaArray;
    }

    public boolean getAutoSelectWriteDataSource() {
        return this.autoSelectWriteDataSource;
    }

    public void setAutoSelectWriteDataSource(boolean autoSelectWriteDataSource) {
        this.autoSelectWriteDataSource = autoSelectWriteDataSource;
    }

    public void setDataSourceFetcher(DataSourceFetcher dataSourceFetcher) {
        this.dataSourceFetcher = dataSourceFetcher;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public static String getFullDbGroupKey(String dbGroupKey) {
        return PREFIX + dbGroupKey;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getClass().isAssignableFrom(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return (T)this;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public void destroyDataSource() throws Exception {
        if (this.configManager != null) {
            this.configManager.destroyDataSource();
        }
    }

    static {
        VERSION = "2.4.1";
        PREFIX = "com.taobao.tddl.jdbc.group_V" + VERSION + "_";
        EXTRA_PREFIX = "com.taobao.tddl.jdbc.extra_config.group_V" + VERSION + "_";
    }
}

