/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group;

import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.TGroupConnection;
import com.taobao.tddl.jdbc.group.TGroupDataSource;
import com.taobao.tddl.jdbc.group.TGroupStatement;
import com.taobao.tddl.jdbc.group.ThreadLocalDataSourceIndex;
import com.taobao.tddl.jdbc.group.dbselector.DBSelector;
import com.taobao.tddl.jdbc.group.parameter.ParameterContext;
import com.taobao.tddl.jdbc.group.parameter.ParameterMethod;
import com.taobao.tddl.jdbc.group.parameter.Parameters;
import com.taobao.tddl.jdbc.group.util.GroupHintParser;
import com.taobao.tddl.jdbc.group.util.SQLParser;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TGroupPreparedStatement
extends TGroupStatement
implements PreparedStatement {
    private static final Log log = LogFactory.getLog(TGroupPreparedStatement.class);
    private String sql;
    private int autoGeneratedKeys = -1;
    private int[] columnIndexes;
    private String[] columnNames;
    protected Map<Integer, ParameterContext> parameterSettings = new HashMap<Integer, ParameterContext>();
    private DBSelector.DataSourceTryer<Integer> executeUpdateTryer = new DBSelector.AbstractDataSourceTryer<Integer>(){

        @Override
        public Integer tryOnDataSource(DataSourceWrapper dsw, Object ... args) throws SQLException {
            Connection conn = TGroupPreparedStatement.this.tGroupConnection.createNewConnection(dsw, false);
            return TGroupPreparedStatement.this.executeUpdateOnConnection(conn);
        }
    };
    private List<Map<Integer, ParameterContext>> pstArgs;
    private DBSelector.DataSourceTryer<int[]> executeBatchTryer = new DBSelector.AbstractDataSourceTryer<int[]>(){

        @Override
        public int[] tryOnDataSource(DataSourceWrapper dsw, Object ... args) throws SQLException {
            Connection conn = TGroupPreparedStatement.this.tGroupConnection.createNewConnection(dsw, false);
            return TGroupPreparedStatement.this.executeBatchOnConnection(conn);
        }
    };

    public TGroupPreparedStatement(TGroupDataSource tGroupDataSource, TGroupConnection tGroupConnection, String sql) {
        super(tGroupDataSource, tGroupConnection);
        this.sql = sql;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameterSettings.clear();
    }

    private PreparedStatement createPreparedStatementInternal(Connection conn, String sql) throws SQLException {
        PreparedStatement ps;
        if (this.autoGeneratedKeys != -1) {
            ps = conn.prepareStatement(sql, this.autoGeneratedKeys);
        } else if (this.columnIndexes != null) {
            ps = conn.prepareStatement(sql, this.columnIndexes);
        } else if (this.columnNames != null) {
            ps = conn.prepareStatement(sql, this.columnNames);
        } else {
            int resultSetHoldability = this.resultSetHoldability;
            if (resultSetHoldability == -1) {
                resultSetHoldability = conn.getHoldability();
            }
            ps = conn.prepareStatement(sql, this.resultSetType, this.resultSetConcurrency, resultSetHoldability);
        }
        this.setBaseStatement(ps);
        ps.setQueryTimeout(this.queryTimeout);
        ps.setFetchSize(this.fetchSize);
        ps.setMaxRows(this.maxRows);
        return ps;
    }

    @Override
    public boolean execute() throws SQLException {
        SqlType sqlType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("invoke execute, sql = " + this.sql));
        }
        if ((sqlType = SQLParser.getSqlType(this.sql)) == SqlType.SELECT || sqlType == SqlType.SELECT_FOR_UPDATE || sqlType == SqlType.SHOW) {
            this.executeQuery();
            return true;
        }
        if (sqlType == SqlType.INSERT || sqlType == SqlType.UPDATE || sqlType == SqlType.DELETE || sqlType == SqlType.REPLACE || sqlType == SqlType.TRUNCATE || sqlType == SqlType.CREATE || sqlType == SqlType.DROP || sqlType == SqlType.LOAD || sqlType == SqlType.MERGE || sqlType == SqlType.ALTER) {
            this.updateCount = this.executeUpdate();
            return false;
        }
        throw new SQLException("only select, insert, update, delete,truncate,create,drop,load,merge sql is supported");
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.ensureResultSetIsEmpty();
        boolean gotoRead = SqlType.SELECT.equals((Object)SQLParser.getSqlType(this.sql)) && this.tGroupConnection.getAutoCommit();
        Connection conn = this.tGroupConnection.getBaseConnection(this.sql, gotoRead);
        if (conn != null) {
            this.sql = GroupHintParser.removeTddlGroupHint(this.sql);
            return this.executeQueryOnConnection(conn, this.sql);
        }
        Integer dataSourceIndex = GroupHintParser.convertHint2Index(this.sql);
        this.sql = GroupHintParser.removeTddlGroupHint(this.sql);
        if (dataSourceIndex < 0) {
            dataSourceIndex = ThreadLocalDataSourceIndex.getIndex();
        }
        return (ResultSet)this.tGroupDataSource.getDBSelector(gotoRead).tryExecute(this.executeQueryTryer, this.retryingTimes, this.sql, dataSourceIndex);
    }

    @Override
    protected ResultSet executeQueryOnConnection(Connection conn, String sql) throws SQLException {
        PreparedStatement ps = this.createPreparedStatementInternal(conn, sql);
        Parameters.setParameters(ps, this.parameterSettings);
        this.currentResultSet = ps.executeQuery();
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        int updateCount;
        this.checkClosed();
        this.ensureResultSetIsEmpty();
        Connection conn = this.tGroupConnection.getBaseConnection(this.sql, false);
        if (conn != null) {
            int updateCount2;
            this.sql = GroupHintParser.removeTddlGroupHint(this.sql);
            this.updateCount = updateCount2 = this.executeUpdateOnConnection(conn);
            return updateCount2;
        }
        Integer dataSourceIndex = GroupHintParser.convertHint2Index(this.sql);
        this.sql = GroupHintParser.removeTddlGroupHint(this.sql);
        if (dataSourceIndex < 0) {
            dataSourceIndex = ThreadLocalDataSourceIndex.getIndex();
        }
        this.updateCount = updateCount = this.tGroupDataSource.getDBSelector(false).tryExecute(null, this.executeUpdateTryer, this.retryingTimes, this.sql, dataSourceIndex).intValue();
        return updateCount;
    }

    private int executeUpdateOnConnection(Connection conn) throws SQLException {
        PreparedStatement ps = this.createPreparedStatementInternal(conn, this.sql);
        Parameters.setParameters(ps, this.parameterSettings);
        return ps.executeUpdate();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new UnsupportedOperationException("getMetaData");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException("getParameterMetaData");
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setArray, new Object[]{i, x}));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setAsciiStream, new Object[]{parameterIndex, x, length}));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBigDecimal, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBinaryStream, new Object[]{parameterIndex, x, length}));
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setBlob, new Object[]{i, x}));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBoolean, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setByte, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setBytes, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setCharacterStream, new Object[]{parameterIndex, reader, length}));
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setClob, new Object[]{i, x}));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setDate1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setDate2, new Object[]{parameterIndex, x, cal}));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setDouble, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setFloat, new Object[]{parameterIndex, Float.valueOf(x)}));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setInt, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setLong, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setNull1, new Object[]{parameterIndex, sqlType}));
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.parameterSettings.put(paramIndex, new ParameterContext(ParameterMethod.setNull2, new Object[]{paramIndex, sqlType, typeName}));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setObject1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setObject2, new Object[]{parameterIndex, x, targetSqlType}));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setObject3, new Object[]{parameterIndex, x, targetSqlType, scale}));
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.parameterSettings.put(i, new ParameterContext(ParameterMethod.setRef, new Object[]{i, x}));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setShort, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setString, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTime1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTime2, new Object[]{parameterIndex, x, cal}));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTimestamp1, new Object[]{parameterIndex, x}));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setTimestamp2, new Object[]{parameterIndex, x, cal}));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setURL, new Object[]{parameterIndex, x}));
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.parameterSettings.put(parameterIndex, new ParameterContext(ParameterMethod.setUnicodeStream, new Object[]{parameterIndex, x, length}));
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.pstArgs == null) {
            this.pstArgs = new LinkedList<Map<Integer, ParameterContext>>();
        }
        HashMap<Integer, ParameterContext> newArg = new HashMap<Integer, ParameterContext>(this.parameterSettings.size());
        newArg.putAll(this.parameterSettings);
        this.parameterSettings.clear();
        this.pstArgs.add(newArg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.checkClosed();
            this.ensureResultSetIsEmpty();
            if (this.pstArgs == null || this.pstArgs.isEmpty()) {
                int[] nArray = new int[]{};
                return nArray;
            }
            Connection conn = this.tGroupConnection.getBaseConnection(this.sql, false);
            if (conn != null) {
                this.sql = GroupHintParser.removeTddlGroupHint(this.sql);
                int[] nArray = this.executeBatchOnConnection(conn);
                return nArray;
            }
            Integer dataSourceIndex = GroupHintParser.convertHint2Index(this.sql);
            this.sql = GroupHintParser.removeTddlGroupHint(this.sql);
            if (dataSourceIndex < 0) {
                dataSourceIndex = ThreadLocalDataSourceIndex.getIndex();
            }
            int[] nArray = this.tGroupDataSource.getDBSelector(false).tryExecute(null, this.executeBatchTryer, this.retryingTimes, dataSourceIndex);
            return nArray;
        }
        finally {
            if (this.pstArgs != null) {
                this.pstArgs.clear();
            }
        }
    }

    private int[] executeBatchOnConnection(Connection conn) throws SQLException {
        PreparedStatement ps = this.createPreparedStatementInternal(conn, this.sql);
        for (Map<Integer, ParameterContext> parameterSettings : this.pstArgs) {
            TGroupPreparedStatement.setBatchParameters(ps, parameterSettings.values());
            ps.addBatch();
        }
        return ps.executeBatch();
    }

    private static void setBatchParameters(PreparedStatement ps, Collection<ParameterContext> batchedParameters) throws SQLException {
        for (ParameterContext context : batchedParameters) {
            Parameters.parameterHandlers.get((Object)context.getParameterMethod()).setParameter(ps, context.getArgs());
        }
    }

    public int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public void setAutoGeneratedKeys(int autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public void setColumnIndexes(int[] columnIndexes) {
        this.columnIndexes = columnIndexes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLException("not support exception");
    }
}

