/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group;

import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.TGroupConnection;
import com.taobao.tddl.jdbc.group.TGroupDataSource;
import com.taobao.tddl.jdbc.group.ThreadLocalDataSourceIndex;
import com.taobao.tddl.jdbc.group.dbselector.DBSelector;
import com.taobao.tddl.jdbc.group.util.GroupHintParser;
import com.taobao.tddl.jdbc.group.util.SQLParser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TGroupStatement
implements Statement {
    private static final Log log = LogFactory.getLog(TGroupStatement.class);
    protected TGroupConnection tGroupConnection;
    protected TGroupDataSource tGroupDataSource;
    protected int retryingTimes;
    private Statement baseStatement;
    protected int queryTimeout = 0;
    protected int fetchSize;
    protected int maxRows;
    protected ResultSet currentResultSet;
    protected int updateCount;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    protected int resultSetHoldability = -1;
    private DBSelector.DataSourceTryer<Integer> executeUpdateTryer = new DBSelector.AbstractDataSourceTryer<Integer>(){

        @Override
        public Integer tryOnDataSource(DataSourceWrapper dsw, Object ... args) throws SQLException {
            Connection conn = TGroupStatement.this.tGroupConnection.createNewConnection(dsw, false);
            return TGroupStatement.this.executeUpdateOnConnection(conn, (String)args[0], (Integer)args[1], (int[])args[2], (String[])args[3]);
        }
    };
    protected List<String> batchedArgs;
    private DBSelector.DataSourceTryer<int[]> executeBatchTryer = new DBSelector.AbstractDataSourceTryer<int[]>(){

        @Override
        public int[] tryOnDataSource(DataSourceWrapper dsw, Object ... args) throws SQLException {
            Connection conn = TGroupStatement.this.tGroupConnection.createNewConnection(dsw, false);
            return TGroupStatement.this.executeBatchOnConnection(conn, TGroupStatement.this.batchedArgs);
        }
    };
    protected boolean closed;
    protected DBSelector.DataSourceTryer<ResultSet> executeQueryTryer = new DBSelector.AbstractDataSourceTryer<ResultSet>(){

        @Override
        public ResultSet tryOnDataSource(DataSourceWrapper dsw, Object ... args) throws SQLException {
            String sql = (String)args[0];
            Connection conn = TGroupStatement.this.tGroupConnection.createNewConnection(dsw, true);
            return TGroupStatement.this.executeQueryOnConnection(conn, sql);
        }
    };
    protected boolean moreResults;

    public TGroupStatement(TGroupDataSource tGroupDataSource, TGroupConnection tGroupConnection) {
        this.tGroupDataSource = tGroupDataSource;
        this.tGroupConnection = tGroupConnection;
        this.retryingTimes = tGroupDataSource.getRetryingTimes();
    }

    void setBaseStatement(Statement baseStatement) {
        if (this.baseStatement != null) {
            try {
                this.baseStatement.close();
            }
            catch (SQLException e) {
                log.error((Object)"close baseStatement failed.", (Throwable)e);
            }
        }
        this.baseStatement = baseStatement;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.executeInternal(sql, -1, null, null);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeInternal(sql, autoGeneratedKeys, null, null);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.executeInternal(sql, -1, columnIndexes, null);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.executeInternal(sql, -1, null, columnNames);
    }

    private boolean executeInternal(String sql, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        SqlType sqlType = SQLParser.getSqlType(sql);
        if (sqlType == SqlType.SELECT || sqlType == SqlType.SELECT_FOR_UPDATE || sqlType == SqlType.SHOW) {
            this.executeQuery(sql);
            return true;
        }
        if (sqlType == SqlType.INSERT || sqlType == SqlType.UPDATE || sqlType == SqlType.DELETE || sqlType == SqlType.REPLACE || sqlType == SqlType.TRUNCATE || sqlType == SqlType.CREATE || sqlType == SqlType.DROP || sqlType == SqlType.LOAD || sqlType == SqlType.MERGE || sqlType == SqlType.ALTER) {
            if (autoGeneratedKeys == -1 && columnIndexes == null && columnNames == null) {
                this.executeUpdate(sql);
            } else if (autoGeneratedKeys != -1) {
                this.executeUpdate(sql, autoGeneratedKeys);
            } else if (columnIndexes != null) {
                this.executeUpdate(sql, columnIndexes);
            } else if (columnNames != null) {
                this.executeUpdate(sql, columnNames);
            } else {
                this.executeUpdate(sql);
            }
            return false;
        }
        throw new SQLException("only select, insert, update, delete,replace,truncate,create,drop,load,merge sql is supported");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdateInternal(sql, -1, null, null);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdateInternal(sql, autoGeneratedKeys, null, null);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdateInternal(sql, -1, columnIndexes, null);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdateInternal(sql, -1, null, columnNames);
    }

    private int executeUpdateInternal(String sql, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        this.checkClosed();
        this.ensureResultSetIsEmpty();
        Connection conn = this.tGroupConnection.getBaseConnection(sql, false);
        if (conn != null) {
            sql = GroupHintParser.removeTddlGroupHint(sql);
            this.updateCount = this.executeUpdateOnConnection(conn, sql, autoGeneratedKeys, columnIndexes, columnNames);
            return this.updateCount;
        }
        Integer dataSourceIndex = GroupHintParser.convertHint2Index(sql);
        sql = GroupHintParser.removeTddlGroupHint(sql);
        if (dataSourceIndex < 0) {
            dataSourceIndex = ThreadLocalDataSourceIndex.getIndex();
        }
        this.updateCount = this.tGroupDataSource.getDBSelector(false).tryExecute(this.executeUpdateTryer, this.retryingTimes, sql, autoGeneratedKeys, columnIndexes, columnNames, dataSourceIndex);
        return this.updateCount;
    }

    private int executeUpdateOnConnection(Connection conn, String sql, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        Statement stmt = this.createStatementInternal(conn, false);
        if (autoGeneratedKeys == -1 && columnIndexes == null && columnNames == null) {
            return stmt.executeUpdate(sql);
        }
        if (autoGeneratedKeys != -1) {
            return stmt.executeUpdate(sql, autoGeneratedKeys);
        }
        if (columnIndexes != null) {
            return stmt.executeUpdate(sql, columnIndexes);
        }
        if (columnNames != null) {
            return stmt.executeUpdate(sql, columnNames);
        }
        return stmt.executeUpdate(sql);
    }

    private Statement createStatementInternal(Connection conn, boolean isBatch) throws SQLException {
        Statement stmt;
        if (isBatch) {
            stmt = conn.createStatement();
        } else {
            int resultSetHoldability = this.resultSetHoldability;
            if (resultSetHoldability == -1) {
                resultSetHoldability = conn.getHoldability();
            }
            stmt = conn.createStatement(this.resultSetType, this.resultSetConcurrency, resultSetHoldability);
        }
        this.setBaseStatement(stmt);
        stmt.setQueryTimeout(this.queryTimeout);
        stmt.setFetchSize(this.fetchSize);
        stmt.setMaxRows(this.maxRows);
        return stmt;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
        if (this.batchedArgs == null) {
            this.batchedArgs = new LinkedList<String>();
        }
        if (sql != null) {
            this.batchedArgs.add(sql);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.checkClosed();
            this.ensureResultSetIsEmpty();
            if (this.batchedArgs == null || this.batchedArgs.isEmpty()) {
                int[] nArray = new int[]{};
                return nArray;
            }
            Connection conn = this.tGroupConnection.getBaseConnection(null, false);
            if (conn != null) {
                int[] nArray = this.executeBatchOnConnection(conn, this.batchedArgs);
                return nArray;
            }
            int[] nArray = this.tGroupDataSource.getDBSelector(false).tryExecute(null, this.executeBatchTryer, this.retryingTimes, new Object[0]);
            return nArray;
        }
        finally {
            if (this.batchedArgs != null) {
                this.batchedArgs.clear();
            }
        }
    }

    private int[] executeBatchOnConnection(Connection conn, List<String> batchedSqls) throws SQLException {
        Statement stmt = this.createStatementInternal(conn, true);
        for (String sql : batchedSqls) {
            stmt.addBatch(sql);
        }
        return stmt.executeBatch();
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean removeThis) throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.currentResultSet != null) {
                this.currentResultSet.close();
            }
        }
        catch (SQLException e) {
            log.warn((Object)"Close currentResultSet failed.", (Throwable)e);
        }
        finally {
            this.currentResultSet = null;
        }
        try {
            if (this.baseStatement != null) {
                this.baseStatement.close();
            }
        }
        finally {
            this.baseStatement = null;
            if (removeThis) {
                this.tGroupConnection.removeOpenedStatements(this);
            }
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("No operations allowed after statement closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureResultSetIsEmpty() throws SQLException {
        if (this.currentResultSet != null) {
            try {
                this.currentResultSet.close();
            }
            catch (SQLException e) {
                log.error((Object)"exception on close last result set . can do nothing..", (Throwable)e);
            }
            finally {
                this.currentResultSet = null;
            }
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        this.ensureResultSetIsEmpty();
        boolean gotoRead = SqlType.SELECT.equals((Object)SQLParser.getSqlType(sql)) && this.tGroupConnection.getAutoCommit();
        Connection conn = this.tGroupConnection.getBaseConnection(sql, gotoRead);
        if (conn != null) {
            sql = GroupHintParser.removeTddlGroupHint(sql);
            return this.executeQueryOnConnection(conn, sql);
        }
        Integer dataSourceIndex = GroupHintParser.convertHint2Index(sql);
        sql = GroupHintParser.removeTddlGroupHint(sql);
        if (dataSourceIndex < 0) {
            dataSourceIndex = ThreadLocalDataSourceIndex.getIndex();
        }
        return this.tGroupDataSource.getDBSelector(gotoRead).tryExecute(this.executeQueryTryer, this.retryingTimes, sql, dataSourceIndex);
    }

    protected ResultSet executeQueryOnConnection(Connection conn, String sql) throws SQLException {
        Statement stmt = this.createStatementInternal(conn, false);
        this.currentResultSet = stmt.executeQuery(sql);
        return this.currentResultSet;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        if (this.baseStatement != null) {
            return this.baseStatement.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        if (this.baseStatement != null) {
            this.baseStatement.clearWarnings();
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.moreResults;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.currentResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.updateCount;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSetHoldability;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.tGroupConnection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException("getFetchDirection");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException("getMaxFieldSize");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        throw new UnsupportedOperationException("setCursorName");
    }

    @Override
    public void setEscapeProcessing(boolean escapeProcessing) throws SQLException {
        throw new UnsupportedOperationException("setEscapeProcessing");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException("getMoreResults");
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        throw new UnsupportedOperationException("setFetchDirection");
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.fetchSize = fetchSize;
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        throw new UnsupportedOperationException("setMaxFieldSize");
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        this.maxRows = maxRows;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.baseStatement != null) {
            return this.baseStatement.getGeneratedKeys();
        }
        throw new SQLException("\u5728\u8c03\u7528getGeneratedKeys\u524d\u672a\u6267\u884c\u8fc7\u4efb\u4f55\u66f4\u65b0\u64cd\u4f5c");
    }

    @Override
    public void cancel() throws SQLException {
        throw new UnsupportedOperationException("cancel");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getClass().isAssignableFrom(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return (T)this;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("not support exception");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("not support exception");
    }
}

