/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group;

import com.taobao.tddl.client.util.ThreadLocalMap;

public class ThreadLocalDataSourceIndex {
    public static boolean existsIndex() {
        return ThreadLocalDataSourceIndex.getIndexAsObject() != null;
    }

    public static Integer getIndexAsObject() {
        Integer indexObject = null;
        try {
            indexObject = (Integer)ThreadLocalMap.get((Object)"DATASOURCE_INDEX");
            if (indexObject == null) {
                return null;
            }
            return indexObject;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ThreadLocalDataSourceIndex.msg(indexObject));
        }
    }

    public static int getIndex() {
        Integer indexObject = null;
        try {
            indexObject = (Integer)ThreadLocalMap.get((Object)"DATASOURCE_INDEX");
            if (indexObject == null) {
                return -1;
            }
            int index = indexObject;
            if (index < 0) {
                throw new IllegalArgumentException(ThreadLocalDataSourceIndex.msg(indexObject));
            }
            return index;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ThreadLocalDataSourceIndex.msg(indexObject));
        }
    }

    public static void clearIndex() {
        ThreadLocalMap.remove((Object)"DATASOURCE_INDEX");
        ThreadLocalMap.remove((Object)"RETRY_IF_SET_DS_INDEX");
    }

    private static String msg(Integer indexObject) {
        return indexObject + " \u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u6570\u636e\u6e90\u7d22\u5f15\uff0c\u7d22\u5f15\u53ea\u80fd\u662f\u5927\u4e8e0\u7684\u6570\u5b57";
    }
}

