/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group.config;

import com.taobao.tddl.client.util.DataSourceType;
import com.taobao.tddl.common.DataSourceChangeListener;
import com.taobao.tddl.common.config.ConfigDataHandler;
import com.taobao.tddl.common.config.ConfigDataHandlerFactory;
import com.taobao.tddl.common.config.ConfigDataListener;
import com.taobao.tddl.common.config.impl.DefaultConfigDataHandlerFactory;
import com.taobao.tddl.common.util.DataSourceFetcher;
import com.taobao.tddl.common.util.TStringUtil;
import com.taobao.tddl.interact.rule.bean.DBType;
import com.taobao.tddl.jdbc.atom.TAtomDataSource;
import com.taobao.tddl.jdbc.atom.config.object.AtomDbStatusEnum;
import com.taobao.tddl.jdbc.druid.TDruidDataSource;
import com.taobao.tddl.jdbc.druid.config.object.DruidDbStatusEnum;
import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.TGroupDataSource;
import com.taobao.tddl.jdbc.group.config.GroupExtraConfig;
import com.taobao.tddl.jdbc.group.dbselector.AbstractDBSelector;
import com.taobao.tddl.jdbc.group.dbselector.DBSelector;
import com.taobao.tddl.jdbc.group.dbselector.EquityDbManager;
import com.taobao.tddl.jdbc.group.dbselector.OneDBSelector;
import com.taobao.tddl.jdbc.group.dbselector.PriorityDbGroupSelector;
import com.taobao.tddl.jdbc.group.dbselector.RuntimeWritableAtomDBSelector;
import com.taobao.tddl.jdbc.group.exception.ConfigException;
import com.taobao.tddl.jdbc.group.exception.TAtomDataSourceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigManager {
    private static final Log logger = LogFactory.getLog(ConfigManager.class);
    private final ConfigDataListener configReceiver;
    private ConfigDataHandlerFactory configFactory;
    private ConfigDataHandler globalHandler;
    private final ConfigDataListener extraGroupConfigReceiver;
    private ConfigDataHandler extraHandler;
    private ConfigDataHandlerFactory extraFactory;
    private final TGroupDataSource tGroupDataSource;
    private boolean createTAtomDataSource = true;
    private Map<String, DataSourceWrapper> dataSourceWrapperMap = new HashMap<String, DataSourceWrapper>();
    private volatile GroupExtraConfig groupExtraConfig = new GroupExtraConfig();
    private DataSourceChangeListener dataSourceChangeListener;
    private volatile DBSelector readDBSelectorWrapper;
    private volatile DBSelector writeDBSelectorWrapper;
    private volatile DBSelector runtimeWritableAtomDBSelectorWrapper;

    public ConfigManager(TGroupDataSource tGroupDataSource) {
        this.tGroupDataSource = tGroupDataSource;
        this.configReceiver = new ConfigReceiver();
        this.extraGroupConfigReceiver = new ExtraGroupConfigReceiver();
    }

    public void init() {
        this.configFactory = new DefaultConfigDataHandlerFactory();
        this.globalHandler = this.configFactory.getConfigDataHandler(this.tGroupDataSource.getFullDbGroupKey(), null);
        String dsWeightCommaStr = this.globalHandler.getData(this.tGroupDataSource.getConfigReceiveTimeout(), "firstCache");
        this.extraFactory = new DefaultConfigDataHandlerFactory();
        this.extraHandler = this.extraFactory.getConfigDataHandler(this.tGroupDataSource.getDbGroupExtraConfigKey(), null);
        String extraConfig = this.extraHandler.getData(this.tGroupDataSource.getConfigReceiveTimeout(), "firstCache");
        if (extraConfig != null) {
            this.parseExtraConfig(extraConfig);
            this.extraHandler.addListener(this.extraGroupConfigReceiver, null);
        }
        List<DataSourceWrapper> dswList = this.parse2DataSourceWrapperList(dsWeightCommaStr);
        this.resetByDataSourceWrapper(dswList);
        this.globalHandler.addListener(this.configReceiver, null);
    }

    public void init(List<DataSourceWrapper> dataSourceWrappers) {
        if (dataSourceWrappers == null || dataSourceWrappers.size() < 1) {
            throw new ConfigException("dataSourceWrappers\u4e0d\u80fd\u4e3anull\u4e14\u957f\u5ea6\u8981\u5927\u4e8e0");
        }
        this.createTAtomDataSource = false;
        this.resetByDataSourceWrapper(dataSourceWrappers);
    }

    private void parse(String dsWeightCommaStr) {
        List<DataSourceWrapper> dswList = this.parse2DataSourceWrapperList(dsWeightCommaStr);
        this.resetByDataSourceWrapper(dswList);
    }

    private void parseExtraConfig(String extraConfig) {
        if (extraConfig == null) {
            this.groupExtraConfig.getSqlForbidSet().clear();
            this.groupExtraConfig.getSqlDsIndexMap().clear();
            this.groupExtraConfig.getTableDsIndexMap().clear();
            this.groupExtraConfig.setDefaultMain(false);
        }
        try {
            int i;
            JSONArray array;
            Integer index;
            String key;
            JSONObject sqlDsIndex;
            JSONObject obj = new JSONObject(extraConfig);
            if (obj.has("sqlForbid")) {
                HashSet<String> tempSqlForbidSet = new HashSet<String>();
                JSONArray array2 = obj.getJSONArray("sqlForbid");
                for (int i2 = 0; i2 < array2.length(); ++i2) {
                    String sql = array2.getString(i2);
                    String nomalSql = TStringUtil.fillTabWithSpace((String)sql.trim().toLowerCase());
                    if (nomalSql == null || nomalSql.trim().isEmpty()) continue;
                    tempSqlForbidSet.add(nomalSql);
                }
                this.groupExtraConfig.setSqlForbidSet(tempSqlForbidSet);
            } else {
                this.groupExtraConfig.getSqlForbidSet().clear();
            }
            if (obj.has("sqlDsIndex")) {
                HashMap<String, Integer> tempSqlDsIndexMap = new HashMap<String, Integer>();
                sqlDsIndex = obj.getJSONObject("sqlDsIndex");
                Iterator it = sqlDsIndex.keys();
                while (it.hasNext()) {
                    key = String.valueOf(it.next()).trim();
                    index = Integer.valueOf(key);
                    array = sqlDsIndex.getJSONArray(key);
                    for (i = 0; i < array.length(); ++i) {
                        String sql = array.getString(i);
                        String nomalSql = TStringUtil.fillTabWithSpace((String)sql.trim().toLowerCase());
                        if (tempSqlDsIndexMap.get(nomalSql) != null) {
                            throw new ConfigException("sql can not be route to different dataSourceIndex:" + sql);
                        }
                        tempSqlDsIndexMap.put(nomalSql, index);
                    }
                }
                this.groupExtraConfig.setSqlDsIndexMap(tempSqlDsIndexMap);
            } else {
                this.groupExtraConfig.getSqlDsIndexMap().clear();
            }
            if (obj.has("tabDsIndex")) {
                HashMap<String, Integer> tempTabDsIndexMap = new HashMap<String, Integer>();
                sqlDsIndex = obj.getJSONObject("tabDsIndex");
                Iterator it = sqlDsIndex.keys();
                while (it.hasNext()) {
                    key = String.valueOf(it.next()).trim();
                    index = Integer.valueOf(key);
                    array = sqlDsIndex.getJSONArray(key);
                    for (i = 0; i < array.length(); ++i) {
                        String table = array.getString(i);
                        String nomalTable = table.trim().toLowerCase();
                        if (tempTabDsIndexMap.get(nomalTable) != null) {
                            throw new ConfigException("table can not be route to different dataSourceIndex:" + table);
                        }
                        tempTabDsIndexMap.put(nomalTable, index);
                    }
                }
                this.groupExtraConfig.setTableDsIndexMap(tempTabDsIndexMap);
            } else {
                this.groupExtraConfig.getTableDsIndexMap().clear();
            }
            if (obj.has("defaultMain")) {
                this.groupExtraConfig.setDefaultMain(obj.getBoolean("defaultMain"));
            } else {
                this.groupExtraConfig.setDefaultMain(false);
            }
        }
        catch (JSONException e) {
            throw new ConfigException("group extraConfig is not json valid string:" + extraConfig, e);
        }
    }

    private List<DataSourceWrapper> parse2DataSourceWrapperList(String dsWeightCommaStr) {
        logger.warn((Object)("[parse2DataSourceWrapperList]dsWeightCommaStr=" + dsWeightCommaStr));
        if (dsWeightCommaStr == null || (dsWeightCommaStr = dsWeightCommaStr.trim()).length() == 0) {
            throw new ConfigException("\u4e0edbGroupKey:'" + this.tGroupDataSource.getFullDbGroupKey() + "'\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3anull\u4e14\u957f\u5ea6\u8981\u5927\u4e8e0");
        }
        return ConfigManager.buildDataSourceWrapper(dsWeightCommaStr, new MyDataSourceFetcher());
    }

    private void resetByDataSourceWrapper(List<DataSourceWrapper> dswList) {
        HashMap<String, DataSourceWrapper> newDataSourceWrapperMap = new HashMap<String, DataSourceWrapper>(dswList.size());
        for (DataSourceWrapper dsw : dswList) {
            newDataSourceWrapperMap.put(dsw.getDataSourceKey(), dsw);
        }
        Map<String, DataSourceWrapper> old = this.dataSourceWrapperMap;
        this.dataSourceWrapperMap = newDataSourceWrapperMap;
        old.clear();
        old = null;
        DBSelector r_DBSelector = null;
        DBSelector w_DBSelector = null;
        if (dswList.size() == 1) {
            DataSourceWrapper dsw2 = dswList.get(0);
            r_DBSelector = new OneDBSelector(dsw2);
            r_DBSelector.setDbType(dsw2.getDBType());
            w_DBSelector = r_DBSelector;
        } else {
            HashMap<Integer, List<DataSourceWrapper>> rPriority2DswList = new HashMap<Integer, List<DataSourceWrapper>>();
            HashMap<Integer, List<DataSourceWrapper>> wPriority2DswList = new HashMap<Integer, List<DataSourceWrapper>>();
            for (DataSourceWrapper dsw1 : dswList) {
                ConfigManager.add2LinkedListMap(rPriority2DswList, dsw1.getWeight().p, dsw1);
                ConfigManager.add2LinkedListMap(wPriority2DswList, dsw1.getWeight().q, dsw1);
            }
            r_DBSelector = this.createDBSelector(rPriority2DswList, true);
            w_DBSelector = this.createDBSelector(wPriority2DswList, false);
        }
        r_DBSelector.setReadable(true);
        w_DBSelector.setReadable(false);
        this.readDBSelectorWrapper = r_DBSelector;
        this.writeDBSelectorWrapper = w_DBSelector;
        if (this.tGroupDataSource.getAutoSelectWriteDataSource()) {
            this.runtimeWritableAtomDBSelectorWrapper = new RuntimeWritableAtomDBSelector(this.dataSourceWrapperMap, this.groupExtraConfig);
        }
        if (this.dataSourceChangeListener != null) {
            this.dataSourceChangeListener.onDataSourceChanged(null);
        }
    }

    public void setDataSourceChangeListener(DataSourceChangeListener dataSourceChangeListener) {
        this.dataSourceChangeListener = dataSourceChangeListener;
    }

    private static <K, V> void add2LinkedListMap(Map<K, List<V>> m, K key, V value) {
        List<V> c = m.get(key);
        if (c == null) {
            c = new LinkedList<V>();
            m.put(key, c);
        }
        c.add(value);
    }

    public static List<DataSourceWrapper> buildDataSourceWrapper(String dsWeightCommaStr, DataSourceFetcher fetcher) {
        String[] dsWeightArray = dsWeightCommaStr.split(",");
        ArrayList<DataSourceWrapper> dss = new ArrayList<DataSourceWrapper>(dsWeightArray.length);
        for (int i = 0; i < dsWeightArray.length; ++i) {
            String[] dsAndWeight = dsWeightArray[i].split(":");
            String dsKey = dsAndWeight[0].trim();
            String weightStr = dsAndWeight.length == 2 ? dsAndWeight[1] : null;
            DataSource dataSource = fetcher.getDataSource(dsKey);
            DBType fetcherDbType = fetcher.getDataSourceDBType(dsKey);
            DataSourceWrapper dsw = new DataSourceWrapper(dsKey, weightStr, dataSource, fetcherDbType, i);
            dss.add(dsw);
        }
        return dss;
    }

    private DBSelector createDBSelector(Map<Integer, List<DataSourceWrapper>> priority2DswList, boolean isRead) {
        if (priority2DswList.size() == 1) {
            return this.createDBSelector2(priority2DswList.entrySet().iterator().next().getValue(), isRead);
        }
        LinkedList<Integer> priorityKeys = new LinkedList<Integer>();
        priorityKeys.addAll(priority2DswList.keySet());
        Collections.sort(priorityKeys);
        EquityDbManager[] priorityGroups = new EquityDbManager[priorityKeys.size()];
        for (int i = 0; i < priorityGroups.length; ++i) {
            List<DataSourceWrapper> dswList = priority2DswList.get(priorityGroups.length - 1 - i);
            priorityGroups[i] = ConfigManager.createEquityDbManager(dswList, isRead, this.groupExtraConfig);
        }
        return new PriorityDbGroupSelector(priorityGroups);
    }

    private AbstractDBSelector createDBSelector2(List<DataSourceWrapper> dswList, boolean isRead) {
        AbstractDBSelector dbSelector;
        if (dswList.size() == 1) {
            DataSourceWrapper dsw = dswList.get(0);
            dbSelector = new OneDBSelector(dsw);
            dbSelector.setDbType(dsw.getDBType());
        } else {
            dbSelector = ConfigManager.createEquityDbManager(dswList, isRead, this.groupExtraConfig);
        }
        return dbSelector;
    }

    private static EquityDbManager createEquityDbManager(List<DataSourceWrapper> list, boolean isRead, GroupExtraConfig groupExtraConfig) {
        HashMap<String, DataSourceWrapper> dataSourceMap = new HashMap<String, DataSourceWrapper>(list.size());
        HashMap<String, Integer> weightMap = new HashMap<String, Integer>(list.size());
        DBType dbType = null;
        for (DataSourceWrapper dsw : list) {
            String dsKey = dsw.getDataSourceKey();
            dataSourceMap.put(dsKey, dsw);
            weightMap.put(dsKey, isRead ? dsw.getWeight().r : dsw.getWeight().w);
            if (dbType != null) continue;
            dbType = dsw.getDBType();
        }
        EquityDbManager equityDbManager = new EquityDbManager(dataSourceMap, weightMap, groupExtraConfig);
        equityDbManager.setDbType(dbType);
        return equityDbManager;
    }

    private TAtomDataSource createTAtomDataSource(String dsKey) {
        TAtomDataSource ads = null;
        try {
            ads = new TAtomDataSource();
            ads.setAppName(this.tGroupDataSource.getAppName());
            ads.setDbKey(dsKey);
            ads.init();
            ads.setLogWriter(this.tGroupDataSource.getLogWriter());
            ads.setLoginTimeout(this.tGroupDataSource.getLoginTimeout());
        }
        catch (Exception e) {
            throw new TAtomDataSourceException("TAtomDataSource\u65e0\u6cd5\u521d\u59cb\u5316: dsKey=" + dsKey, e);
        }
        return ads;
    }

    private TDruidDataSource createTDruidDataSource(String dsKey) {
        TDruidDataSource ads = null;
        try {
            ads = new TDruidDataSource();
            ads.setAppName(this.tGroupDataSource.getAppName());
            ads.setDbKey(dsKey);
            ads.init();
            ads.setLogWriter(this.tGroupDataSource.getLogWriter());
            ads.setLoginTimeout(this.tGroupDataSource.getLoginTimeout());
        }
        catch (Exception e) {
            throw new TAtomDataSourceException("TAtomDataSource\u65e0\u6cd5\u521d\u59cb\u5316: dsKey=" + dsKey, e);
        }
        return ads;
    }

    public static boolean isDataSourceAvailable(DataSource ds, boolean isRead) {
        if (ds instanceof DataSourceWrapper) {
            ds = ((DataSourceWrapper)ds).getWrappedDataSource();
        }
        if (!(ds instanceof TAtomDataSource) && !(ds instanceof TDruidDataSource)) {
            return true;
        }
        if (ds instanceof TAtomDataSource) {
            AtomDbStatusEnum status = ((TAtomDataSource)ds).getDbStatus();
            if (status.isNaStatus()) {
                return false;
            }
            if (status.isRstatus() && isRead) {
                return true;
            }
            if (status.isWstatus() && !isRead) {
                return true;
            }
        } else if (ds instanceof TDruidDataSource) {
            DruidDbStatusEnum status = ((TDruidDataSource)ds).getDbStatus();
            if (status.isNaStatus()) {
                return false;
            }
            if (status.isRstatus() && isRead) {
                return true;
            }
            if (status.isWstatus() && !isRead) {
                return true;
            }
        }
        return false;
    }

    public DBSelector getDBSelector(boolean isRead, boolean autoSelectWriteDataSource) {
        DBSelector dbSelector;
        DBSelector dBSelector = dbSelector = isRead ? this.readDBSelectorWrapper : this.writeDBSelectorWrapper;
        if (!isRead && autoSelectWriteDataSource) {
            dbSelector = this.runtimeWritableAtomDBSelectorWrapper;
        }
        return dbSelector;
    }

    public void receiveConfigInfo(String configInfo) {
        this.configReceiver.onDataRecieved(null, configInfo);
    }

    public void resetDbGroup(String configInfo) {
        try {
            this.parse(configInfo);
        }
        catch (Throwable t) {
            logger.error((Object)("resetDbGroup failed:" + configInfo), t);
        }
    }

    public void destroyDataSource() throws Exception {
        if (this.dataSourceWrapperMap != null) {
            for (DataSourceWrapper dsw : this.dataSourceWrapperMap.values()) {
                try {
                    DataSource ds = dsw.getWrappedDataSource();
                    if (ds instanceof TAtomDataSource) {
                        TAtomDataSource tads = (TAtomDataSource)ds;
                        tads.destroyDataSource();
                        continue;
                    }
                    if (ds instanceof TDruidDataSource) {
                        TDruidDataSource tdds = (TDruidDataSource)ds;
                        tdds.destroyDataSource();
                        continue;
                    }
                    logger.error((Object)"target datasource is not a TAtom Data Source");
                }
                catch (Exception e) {
                    logger.error((Object)("we got exception when close datasource : " + dsw.getDataSourceKey()), (Throwable)e);
                }
            }
        }
        try {
            if (this.globalHandler != null) {
                this.globalHandler.closeUnderManager();
            }
        }
        catch (Exception e) {
            logger.error((Object)"we got exception when close datasource .", (Throwable)e);
        }
        try {
            if (this.extraHandler != null) {
                this.extraHandler.closeUnderManager();
            }
        }
        catch (Exception e) {
            logger.error((Object)"we got exception when close datasource .", (Throwable)e);
        }
    }

    private class ExtraGroupConfigReceiver
    implements ConfigDataListener {
        private ExtraGroupConfigReceiver() {
        }

        public void onDataRecieved(String dataId, String data) {
            logger.info((Object)("receive group extra data:" + data));
            ConfigManager.this.parseExtraConfig(data);
        }
    }

    private class ConfigReceiver
    implements ConfigDataListener {
        private ConfigReceiver() {
        }

        public void onDataRecieved(String dataId, String data) {
            try {
                logger.warn((Object)("group ds data received !dataId:" + dataId + " data:" + data));
                ConfigManager.this.parse(data);
            }
            catch (Throwable t) {
                logger.error((Object)("\u52a8\u6001\u89e3\u6790\u914d\u7f6e\u4fe1\u606f\u65f6\u51fa\u73b0\u9519\u8bef:" + data), t);
            }
        }
    }

    private class MyDataSourceFetcher
    implements DataSourceFetcher {
        private DBType dbType = DBType.MYSQL;

        private MyDataSourceFetcher() {
        }

        public DataSource getDataSource(String dsKey) {
            DataSourceWrapper dsw = (DataSourceWrapper)ConfigManager.this.dataSourceWrapperMap.get(dsKey);
            if (dsw != null) {
                this.dbType = dsw.getDBType();
                return dsw.getWrappedDataSource();
            }
            if (ConfigManager.this.createTAtomDataSource) {
                if (ConfigManager.this.tGroupDataSource.getDataSourceType().equals((Object)DataSourceType.TbDataSource)) {
                    TAtomDataSource atom = ConfigManager.this.createTAtomDataSource(dsKey);
                    this.dbType = DBType.valueOf((String)atom.getDbType().name());
                    return atom;
                }
                if (ConfigManager.this.tGroupDataSource.getDataSourceType().equals((Object)DataSourceType.DruidDataSource)) {
                    TDruidDataSource druid = ConfigManager.this.createTDruidDataSource(dsKey);
                    this.dbType = DBType.valueOf((String)druid.getDbType().name());
                    return druid;
                }
                throw new IllegalArgumentException("do not havae this datasource type : " + ConfigManager.this.tGroupDataSource.getDataSourceType());
            }
            throw new IllegalArgumentException(dsKey + " not exist!");
        }

        public DBType getDataSourceDBType(String key) {
            return this.dbType;
        }
    }
}

