/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group.config;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Weight {
    private static final Pattern weightPattern_r = Pattern.compile("[R](\\d*)");
    private static final Pattern weightPattern_w = Pattern.compile("[W](\\d*)");
    private static final Pattern weightPattern_p = Pattern.compile("[P](\\d*)");
    private static final Pattern weightPattern_q = Pattern.compile("[Q](\\d*)");
    private static final Pattern weightPattern_i = Pattern.compile("[I](\\d*)");
    public final int r;
    public final int w;
    public final int p;
    public final int q;
    public final Set<Integer> indexes;

    public Weight(String weightStr) {
        if (weightStr == null) {
            this.r = 10;
            this.w = 10;
            this.p = 0;
            this.q = 0;
            this.indexes = null;
        } else {
            weightStr = weightStr.trim().toUpperCase();
            this.r = Weight.getUnitWeight(weightStr, 'R', weightPattern_r, 0, 10);
            this.w = Weight.getUnitWeight(weightStr, 'W', weightPattern_w, 0, 10);
            this.p = Weight.getUnitWeight(weightStr, 'P', weightPattern_p, 0, 0);
            this.q = Weight.getUnitWeight(weightStr, 'Q', weightPattern_q, 0, 0);
            this.indexes = Weight.getUnitWeights(weightStr, 'I', weightPattern_i);
        }
    }

    public String toString() {
        return "Weight[r=" + this.r + ", w=" + this.w + ", p=" + this.p + ", q=" + this.q + ", indexes=" + this.indexes + "]";
    }

    private static int getUnitWeight(String weightStr, char c, Pattern p, int defaultValue1, int defaultValue2) {
        if (weightStr.indexOf(c) == -1) {
            return defaultValue1;
        }
        Matcher m = p.matcher(weightStr);
        m.find();
        if (m.group(1).length() == 0) {
            return defaultValue2;
        }
        return Integer.parseInt(m.group(1));
    }

    private static Set<Integer> getUnitWeights(String weightStr, char c, Pattern p) {
        if (weightStr.indexOf(c) == -1) {
            return null;
        }
        HashSet<Integer> is = new HashSet<Integer>();
        int start = 0;
        Matcher m = p.matcher(weightStr);
        while (m.find(start)) {
            if (m.group(1).length() != 0) {
                is.add(Integer.valueOf(m.group(1)));
            }
            start = m.end();
        }
        return is;
    }

    public static void main(String[] args) {
        System.out.println(new Weight("wr0i1"));
        System.out.println(new Weight("wr0i0I1"));
        System.out.println(new Weight("i0w10I1r20"));
        System.out.println(new Weight("i0w10I1r20i3"));
    }
}

