/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group.dbselector;

import com.taobao.tddl.client.jdbc.sorter.ExceptionSorter;
import com.taobao.tddl.client.jdbc.sorter.MySQLExceptionSorter;
import com.taobao.tddl.client.jdbc.sorter.OracleExceptionSorter;
import com.taobao.tddl.client.util.ThreadLocalMap;
import com.taobao.tddl.common.SQLPreParser;
import com.taobao.tddl.common.util.NagiosUtils;
import com.taobao.tddl.common.util.TStringUtil;
import com.taobao.tddl.interact.rule.bean.DBType;
import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.config.GroupExtraConfig;
import com.taobao.tddl.jdbc.group.dbselector.DBSelector;
import com.taobao.tddl.jdbc.group.dbselector.NoMoreDataSourceException;
import com.taobao.tddl.jdbc.group.exception.SqlForbidException;
import com.taobao.tddl.jdbc.group.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDBSelector
implements DBSelector {
    private static final Log logger = LogFactory.getLog(AbstractDBSelector.class);
    private static final Map<DBType, ExceptionSorter> exceptionSorters = new HashMap<DBType, ExceptionSorter>(2);
    private DBType dbType = DBType.MYSQL;
    protected ExceptionSorter exceptionSorter = exceptionSorters.get(this.dbType);
    private String id = "undefined";
    private static final int default_retryBadDbInterval = 2000;
    protected static int retryBadDbInterval;
    protected boolean readable = false;
    protected boolean isSupportRetry = true;
    protected GroupExtraConfig groupExtraConfig;

    @Override
    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    @Override
    public boolean isSupportRetry() {
        return this.isSupportRetry;
    }

    public void setSupportRetry(boolean isSupportRetry) {
        this.isSupportRetry = isSupportRetry;
    }

    public AbstractDBSelector() {
    }

    public AbstractDBSelector(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T tryOnDataSourceHolder(DataSourceHolder dsHolder, Map<DataSource, SQLException> failedDataSources, DBSelector.DataSourceTryer<T> tryer, int times, Object ... args) throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        if (failedDataSources != null) {
            exceptions.addAll(failedDataSources.values());
        }
        if (failedDataSources != null && failedDataSources.containsKey(dsHolder.dsw)) {
            return tryer.onSQLException(exceptions, this.exceptionSorter, args);
        }
        try {
            boolean toTry;
            if (!dsHolder.isNotAvailable) return tryer.tryOnDataSource(dsHolder.dsw, args);
            boolean bl = toTry = System.currentTimeMillis() - dsHolder.lastRetryTime > (long)retryBadDbInterval;
            if (toTry && dsHolder.lock.tryLock()) {
                try {
                    T t = tryer.tryOnDataSource(dsHolder.dsw, args);
                    dsHolder.isNotAvailable = false;
                    T t2 = t;
                    return t2;
                }
                finally {
                    dsHolder.lastRetryTime = System.currentTimeMillis();
                    dsHolder.lock.unlock();
                }
            }
            exceptions.add(new NoMoreDataSourceException("dsKey:" + dsHolder.dsw.getDataSourceKey() + " not Available,toTry:" + toTry));
            return tryer.onSQLException(exceptions, this.exceptionSorter, args);
        }
        catch (SQLException e) {
            if (this.exceptionSorter.isExceptionFatal(e)) {
                NagiosUtils.addNagiosLog((String)("DB_NOT_AVAILABLE|" + dsHolder.dsw.getDataSourceKey()), (String)e.getMessage());
                dsHolder.isNotAvailable = true;
            }
            exceptions.add(e);
            return tryer.onSQLException(exceptions, this.exceptionSorter, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T tryOnDataSourceHolderWithIndex(DataSourceHolder dsHolder, Map<DataSource, SQLException> failedDataSources, DBSelector.DataSourceTryer<T> tryer, int times, Object ... args) throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        if (failedDataSources != null) {
            exceptions.addAll(failedDataSources.values());
        }
        if (failedDataSources != null && failedDataSources.containsKey(dsHolder.dsw)) {
            return tryer.onSQLException(exceptions, this.exceptionSorter, args);
        }
        try {
            if (!dsHolder.isNotAvailable) return tryer.tryOnDataSource(dsHolder.dsw, args);
            boolean toTry = System.currentTimeMillis() - dsHolder.lastRetryTime > (long)retryBadDbInterval;
            Boolean failOver = (Boolean)ThreadLocalMap.get((Object)"RETRY_IF_SET_DS_INDEX");
            if (toTry && dsHolder.lock.tryLock()) {
                try {
                    T t = tryer.tryOnDataSource(dsHolder.dsw, args);
                    dsHolder.isNotAvailable = false;
                    T t2 = t;
                    return t2;
                }
                finally {
                    dsHolder.lastRetryTime = System.currentTimeMillis();
                    dsHolder.lock.unlock();
                }
            }
            if (failOver != null && failOver.booleanValue()) {
                return this.tryExecuteInternal(failedDataSources, tryer, times, args);
            }
            exceptions.add(new NoMoreDataSourceException("dsKey:" + dsHolder.dsw.getDataSourceKey() + " not Available,toTry:" + toTry));
            return tryer.onSQLException(exceptions, this.exceptionSorter, args);
        }
        catch (SQLException e) {
            if (this.exceptionSorter.isExceptionFatal(e)) {
                NagiosUtils.addNagiosLog((String)("DB_NOT_AVAILABLE|" + dsHolder.dsw.getDataSourceKey()), (String)e.getMessage());
                dsHolder.isNotAvailable = true;
            }
            exceptions.add(e);
            return tryer.onSQLException(exceptions, this.exceptionSorter, args);
        }
    }

    @Override
    public <T> T tryExecute(Map<DataSource, SQLException> failedDataSources, DBSelector.DataSourceTryer<T> tryer, int times, Object ... args) throws SQLException {
        Integer dataSourceIndex = null;
        if (args != null && args.length > 0) {
            dataSourceIndex = (Integer)args[args.length - 1];
        }
        if (this.groupExtraConfig != null) {
            Boolean defaultMain = this.groupExtraConfig.isDefaultMain();
            Map<String, Integer> tableDsIndexMap = this.groupExtraConfig.getTableDsIndexMap();
            Map<String, Integer> sqlDsIndexMap = this.groupExtraConfig.getSqlDsIndexMap();
            Set<String> sqlForbidSet = this.groupExtraConfig.getSqlForbidSet();
            if (args != null && args.length > 0 && args[0] instanceof String) {
                String actualTable;
                String actualConfigTable;
                String nomalConfigSql;
                String nomalSql;
                String sql;
                if (sqlForbidSet != null && sqlForbidSet.size() > 0) {
                    sql = (String)args[0];
                    nomalSql = TStringUtil.fillTabWithSpace((String)sql);
                    boolean isForbidden = false;
                    if (sqlForbidSet.contains(nomalSql)) {
                        isForbidden = true;
                    }
                    if (!isForbidden) {
                        String actualTable2 = SQLPreParser.findTableName((String)nomalSql);
                        for (String configSql : sqlForbidSet) {
                            nomalConfigSql = TStringUtil.fillTabWithSpace((String)configSql);
                            actualConfigTable = SQLPreParser.findTableName((String)nomalConfigSql);
                            if (StringUtils.isTableFatherAndSon(actualConfigTable, actualTable2)) {
                                nomalConfigSql = nomalConfigSql.replaceAll(actualConfigTable, actualTable2);
                            }
                            if (!nomalConfigSql.equals(nomalSql)) continue;
                            isForbidden = true;
                            break;
                        }
                    }
                    if (isForbidden) {
                        String message = "sql : '" + sql + "' is in forbidden set.";
                        logger.error((Object)message);
                        throw new SqlForbidException(message);
                    }
                }
                if (!(tableDsIndexMap == null || tableDsIndexMap.size() <= 0 || dataSourceIndex != null && dataSourceIndex != -1 || (dataSourceIndex = tableDsIndexMap.get(actualTable = SQLPreParser.findTableName((String)(sql = (String)args[0])))) != null && dataSourceIndex != -1)) {
                    Set<String> tableSet = tableDsIndexMap.keySet();
                    for (String configTable : tableSet) {
                        if (!StringUtils.isTableFatherAndSon(configTable, actualTable)) continue;
                        dataSourceIndex = tableDsIndexMap.get(configTable);
                        break;
                    }
                }
                if (!(sqlDsIndexMap == null || sqlDsIndexMap.size() <= 0 || dataSourceIndex != null && dataSourceIndex != -1 || (dataSourceIndex = sqlDsIndexMap.get(nomalSql = TStringUtil.fillTabWithSpace((String)(sql = ((String)args[0]).toLowerCase())))) != null && dataSourceIndex != -1)) {
                    String actualTable3 = SQLPreParser.findTableName((String)nomalSql);
                    Set<String> sqlSet = sqlDsIndexMap.keySet();
                    for (String configSql : sqlSet) {
                        nomalConfigSql = TStringUtil.fillTabWithSpace((String)configSql);
                        actualConfigTable = SQLPreParser.findTableName((String)nomalConfigSql);
                        if (StringUtils.isTableFatherAndSon(actualConfigTable, actualTable3)) {
                            nomalConfigSql = nomalConfigSql.replaceAll(actualConfigTable, actualTable3);
                        }
                        if (!nomalConfigSql.equals(nomalSql)) continue;
                        dataSourceIndex = sqlDsIndexMap.get(configSql);
                        break;
                    }
                }
            }
            if ((dataSourceIndex == null || dataSourceIndex == -1) && defaultMain.booleanValue()) {
                dataSourceIndex = 0;
            }
        }
        if (dataSourceIndex != null && dataSourceIndex != -1) {
            DataSourceHolder dsHolder = this.findDataSourceWrapperByIndex(dataSourceIndex);
            if (dsHolder == null) {
                throw new IllegalArgumentException("\u627e\u4e0d\u5230\u7d22\u5f15\u7f16\u53f7\u4e3a '" + dataSourceIndex + "'\u7684\u6570\u636e\u6e90");
            }
            return this.tryOnDataSourceHolderWithIndex(dsHolder, failedDataSources, tryer, times, args);
        }
        return this.tryExecuteInternal(failedDataSources, tryer, times, args);
    }

    @Override
    public <T> T tryExecute(DBSelector.DataSourceTryer<T> tryer, int times, Object ... args) throws SQLException {
        return this.tryExecute(new LinkedHashMap<DataSource, SQLException>(0), tryer, times, args);
    }

    public DBType getDbType() {
        return this.dbType;
    }

    @Override
    public void setDbType(DBType dbType) {
        this.dbType = dbType;
        this.exceptionSorter = exceptionSorters.get(this.dbType);
    }

    public final void setExceptionSorter(ExceptionSorter exceptionSorter) {
        this.exceptionSorter = exceptionSorter;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected abstract DataSourceHolder findDataSourceWrapperByIndex(int var1);

    protected <T> T tryExecuteInternal(DBSelector.DataSourceTryer<T> tryer, int times, Object ... args) throws SQLException {
        return this.tryExecuteInternal(new LinkedHashMap<DataSource, SQLException>(0), tryer, times, args);
    }

    protected abstract <T> T tryExecuteInternal(Map<DataSource, SQLException> var1, DBSelector.DataSourceTryer<T> var2, int var3, Object ... var4) throws SQLException;

    static {
        exceptionSorters.put(DBType.ORACLE, (ExceptionSorter)new OracleExceptionSorter());
        exceptionSorters.put(DBType.MYSQL, (ExceptionSorter)new MySQLExceptionSorter());
        int interval = 2000;
        String propvalue = System.getProperty("com.taobao.tddl.DBSelector.retryBadDbInterval");
        if (propvalue != null) {
            try {
                interval = Integer.valueOf(propvalue.trim());
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        retryBadDbInterval = interval;
    }

    protected static class DataSourceHolder {
        public final DataSourceWrapper dsw;
        public final ReentrantLock lock = new ReentrantLock();
        public volatile boolean isNotAvailable = false;
        public volatile long lastRetryTime = 0L;

        public DataSourceHolder(DataSourceWrapper dsw) {
            this.dsw = dsw;
        }
    }
}

