/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group.dbselector;

import com.taobao.tddl.common.WeightRandom;
import com.taobao.tddl.common.util.NagiosUtils;
import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.config.ConfigManager;
import com.taobao.tddl.jdbc.group.config.GroupExtraConfig;
import com.taobao.tddl.jdbc.group.dbselector.AbstractDBSelector;
import com.taobao.tddl.jdbc.group.dbselector.DBSelector;
import com.taobao.tddl.jdbc.group.dbselector.NoMoreDataSourceException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EquityDbManager
extends AbstractDBSelector {
    private static final Log logger = LogFactory.getLog(EquityDbManager.class);
    private Map<String, AbstractDBSelector.DataSourceHolder> dataSourceMap;
    private WeightRandom weightRandom;
    private final Random random = new Random();

    public EquityDbManager(Map<String, DataSourceWrapper> dataSourceWrapperMap, Map<String, Integer> weightMap) {
        this.dataSourceMap = new HashMap<String, AbstractDBSelector.DataSourceHolder>(dataSourceWrapperMap.size());
        for (Map.Entry<String, DataSourceWrapper> e : dataSourceWrapperMap.entrySet()) {
            this.dataSourceMap.put(e.getKey(), new AbstractDBSelector.DataSourceHolder(e.getValue()));
        }
        this.weightRandom = new WeightRandom(weightMap);
    }

    public EquityDbManager(Map<String, DataSourceWrapper> dataSourceWrapperMap, Map<String, Integer> weightMap, GroupExtraConfig groupExtraConfig) {
        this.groupExtraConfig = groupExtraConfig;
        this.dataSourceMap = new HashMap<String, AbstractDBSelector.DataSourceHolder>(dataSourceWrapperMap.size());
        for (Map.Entry<String, DataSourceWrapper> e : dataSourceWrapperMap.entrySet()) {
            this.dataSourceMap.put(e.getKey(), new AbstractDBSelector.DataSourceHolder(e.getValue()));
        }
        this.weightRandom = new WeightRandom(weightMap);
    }

    private static String selectAliveKey(WeightRandom weightRandom, List<String> excludeKeys) {
        if (null == excludeKeys) {
            excludeKeys = new ArrayList<String>();
        }
        return weightRandom.select(excludeKeys);
    }

    @Override
    public DataSource select() {
        String key = EquityDbManager.selectAliveKey(this.weightRandom, null);
        if (null != key) {
            return this.get(key);
        }
        return null;
    }

    @Override
    public DataSourceWrapper get(String dsKey) {
        AbstractDBSelector.DataSourceHolder holder = this.dataSourceMap.get(dsKey);
        Integer weigthValue = (Integer)this.weightRandom.getWeightConfig().get(dsKey);
        if (weigthValue == null || weigthValue.equals(0)) {
            return null;
        }
        return holder == null ? null : holder.dsw;
    }

    @Override
    public Map<String, DataSource> getDataSources() {
        HashMap<String, DataSource> dsMap = new HashMap<String, DataSource>(this.dataSourceMap.size());
        for (Map.Entry<String, AbstractDBSelector.DataSourceHolder> e : this.dataSourceMap.entrySet()) {
            dsMap.put(e.getKey(), e.getValue().dsw);
        }
        return dsMap;
    }

    public Map<String, Integer> getWeights() {
        return this.weightRandom.getWeightConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> T tryExecuteInternal(Map<DataSource, SQLException> failedDataSources, DBSelector.DataSourceTryer<T> tryer, int times, Object ... args) throws SQLException {
        if (!this.isSupportRetry) {
            times = 1;
        }
        WeightRandom wr = this.weightRandom;
        ArrayList<SQLException> exceptions = new ArrayList<SQLException>(0);
        ArrayList<String> excludeKeys = new ArrayList<String>(0);
        if (failedDataSources != null) {
            exceptions.addAll(failedDataSources.values());
            times -= failedDataSources.size();
            for (SQLException e : failedDataSources.values()) {
                if (this.exceptionSorter.isExceptionFatal(e)) continue;
                return tryer.onSQLException(exceptions, this.exceptionSorter, args);
            }
        }
        int i = 0;
        while (i < times) {
            String name = EquityDbManager.selectAliveKey(wr, excludeKeys);
            if (name == null) {
                exceptions.add(new NoMoreDataSourceException("tryTime:" + i + ", excludeKeys:" + excludeKeys + ", weightConfig:" + wr.getWeightConfig()));
                return tryer.onSQLException(exceptions, this.exceptionSorter, args);
            }
            AbstractDBSelector.DataSourceHolder dsHolder = this.dataSourceMap.get(name);
            if (dsHolder == null) {
                throw new IllegalStateException("Can't find DataSource for name:" + name);
            }
            if (failedDataSources != null && failedDataSources.containsKey(dsHolder.dsw)) {
                excludeKeys.add(name);
                --i;
            } else if (!ConfigManager.isDataSourceAvailable(dsHolder.dsw, this.readable)) {
                excludeKeys.add(name);
                --i;
            } else {
                try {
                    boolean toTry;
                    if (!dsHolder.isNotAvailable) return tryer.tryOnDataSource(dsHolder.dsw, args);
                    boolean bl = toTry = System.currentTimeMillis() - dsHolder.lastRetryTime > (long)retryBadDbInterval;
                    if (toTry && dsHolder.lock.tryLock()) {
                        try {
                            T t = tryer.tryOnDataSource(dsHolder.dsw, args);
                            dsHolder.isNotAvailable = false;
                            T t2 = t;
                            return t2;
                        }
                        finally {
                            dsHolder.lastRetryTime = System.currentTimeMillis();
                            dsHolder.lock.unlock();
                        }
                    }
                    excludeKeys.add(name);
                    --i;
                }
                catch (SQLException e) {
                    exceptions.add(e);
                    boolean isFatal = this.exceptionSorter.isExceptionFatal(e);
                    if (isFatal) {
                        NagiosUtils.addNagiosLog((String)("DB_NOT_AVAILABLE|" + name), (String)e.getMessage());
                        dsHolder.isNotAvailable = true;
                    }
                    if (!isFatal) return tryer.onSQLException(exceptions, this.exceptionSorter, args);
                    if (failedDataSources == null) {
                        return tryer.onSQLException(exceptions, this.exceptionSorter, args);
                    }
                    logger.warn((Object)(i + 1 + "th try locate on [" + name + "] failed:" + e.getMessage()));
                    excludeKeys.add(name);
                }
            }
            ++i;
        }
        return tryer.onSQLException(exceptions, this.exceptionSorter, args);
    }

    @Override
    protected AbstractDBSelector.DataSourceHolder findDataSourceWrapperByIndex(int dataSourceIndex) {
        ArrayList<AbstractDBSelector.DataSourceHolder> holders = new ArrayList<AbstractDBSelector.DataSourceHolder>();
        for (AbstractDBSelector.DataSourceHolder dsh : this.dataSourceMap.values()) {
            if (!dsh.dsw.isMatchDataSourceIndex(dataSourceIndex)) continue;
            holders.add(dsh);
        }
        if (!holders.isEmpty()) {
            return (AbstractDBSelector.DataSourceHolder)holders.get(this.random.nextInt(holders.size()));
        }
        return null;
    }
}

