/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group.dbselector;

import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.dbselector.AbstractDBSelector;
import com.taobao.tddl.jdbc.group.dbselector.DBSelector;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;

public class OneDBSelector
extends AbstractDBSelector {
    private final AbstractDBSelector.DataSourceHolder dsHolder;
    private final Map<String, DataSource> dsMap;

    public OneDBSelector(DataSourceWrapper dsw) {
        this.dsHolder = new AbstractDBSelector.DataSourceHolder(dsw);
        this.dsMap = new LinkedHashMap<String, DataSource>();
        this.dsMap.put(dsw.getDataSourceKey(), dsw.getWrappedDataSource());
    }

    @Override
    public DataSource select() {
        return this.dsHolder.dsw;
    }

    @Override
    public Map<String, DataSource> getDataSources() {
        return this.dsMap;
    }

    @Override
    protected <T> T tryExecuteInternal(Map<DataSource, SQLException> failedDataSources, DBSelector.DataSourceTryer<T> tryer, int times, Object ... args) throws SQLException {
        if (failedDataSources != null && failedDataSources.containsKey(this.dsHolder.dsw)) {
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>(failedDataSources.size());
            exceptions.addAll(failedDataSources.values());
            return tryer.onSQLException(exceptions, this.exceptionSorter, args);
        }
        try {
            return this.tryOnDataSourceHolder(this.dsHolder, failedDataSources, tryer, times, args);
        }
        catch (SQLException e) {
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>(1);
            exceptions.add(e);
            return tryer.onSQLException(exceptions, this.exceptionSorter, args);
        }
    }

    @Override
    protected <T> T tryExecuteInternal(DBSelector.DataSourceTryer<T> tryer, int times, Object ... args) throws SQLException {
        return this.tryExecute(null, tryer, times, args);
    }

    @Override
    public DataSourceWrapper get(String dsKey) {
        return this.dsHolder.dsw.getDataSourceKey().equals(dsKey) ? this.dsHolder.dsw : null;
    }

    @Override
    protected AbstractDBSelector.DataSourceHolder findDataSourceWrapperByIndex(int dataSourceIndex) {
        return this.dsHolder.dsw.isMatchDataSourceIndex(dataSourceIndex) ? this.dsHolder : null;
    }
}

