/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group.dbselector;

import com.taobao.tddl.client.jdbc.sorter.ExceptionSorter;
import com.taobao.tddl.common.exception.runtime.NotSupportException;
import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.dbselector.AbstractDBSelector;
import com.taobao.tddl.jdbc.group.dbselector.DBSelector;
import com.taobao.tddl.jdbc.group.dbselector.EquityDbManager;
import com.taobao.tddl.jdbc.group.dbselector.NoMoreDataSourceException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PriorityDbGroupSelector
extends AbstractDBSelector {
    private static final Log logger = LogFactory.getLog(PriorityDbGroupSelector.class);
    private EquityDbManager[] priorityGroups;

    public PriorityDbGroupSelector(EquityDbManager[] priorityGroups) {
        this.priorityGroups = priorityGroups;
        if (priorityGroups == null || priorityGroups.length == 0) {
            throw new IllegalArgumentException("EquityDbManager[] priorityGroups is null or empty");
        }
    }

    @Override
    public DataSource select() {
        for (int i = 0; i < this.priorityGroups.length; ++i) {
            DataSource ds = this.priorityGroups[i].select();
            if (ds == null) continue;
            return ds;
        }
        return null;
    }

    @Override
    public DataSourceWrapper get(String dsKey) {
        for (int i = 0; i < this.priorityGroups.length; ++i) {
            DataSourceWrapper ds = this.priorityGroups[i].get(dsKey);
            if (ds == null) continue;
            return ds;
        }
        return null;
    }

    public void setWeight(Map<String, Integer> weightMap) {
    }

    @Override
    protected <T> T tryExecuteInternal(Map<DataSource, SQLException> failedDataSources, DBSelector.DataSourceTryer<T> tryer, int times, Object ... args) throws SQLException {
        ArrayList<SQLException> historyExceptions = new ArrayList<SQLException>(0);
        DataSourceTryerWrapper<T> wrapperTryer = new DataSourceTryerWrapper<T>(tryer, historyExceptions);
        for (int i = 0; i < this.priorityGroups.length; ++i) {
            try {
                return this.priorityGroups[i].tryExecute(failedDataSources, wrapperTryer, times, args);
            }
            catch (NoMoreDataSourceException e) {
                logger.warn((Object)("NoMoreDataSource for retry for priority group " + i));
                continue;
            }
        }
        return tryer.onSQLException(historyExceptions, this.exceptionSorter, args);
    }

    @Override
    public void setSupportRetry(boolean isSupportRetry) {
        for (int i = 0; i < this.priorityGroups.length; ++i) {
            this.priorityGroups[i].setSupportRetry(isSupportRetry);
        }
        this.isSupportRetry = isSupportRetry;
    }

    @Override
    public void setReadable(boolean readable) {
        for (int i = 0; i < this.priorityGroups.length; ++i) {
            this.priorityGroups[i].setReadable(readable);
        }
        this.readable = readable;
    }

    @Override
    public Map<String, DataSource> getDataSources() {
        throw new NotSupportException("getDataSources()");
    }

    @Override
    protected AbstractDBSelector.DataSourceHolder findDataSourceWrapperByIndex(int dataSourceIndex) {
        for (int i = 0; i < this.priorityGroups.length; ++i) {
            AbstractDBSelector.DataSourceHolder holder = this.priorityGroups[i].findDataSourceWrapperByIndex(dataSourceIndex);
            if (holder == null) continue;
            return holder;
        }
        return null;
    }

    private static class DataSourceTryerWrapper<T>
    implements DBSelector.DataSourceTryer<T> {
        private final List<SQLException> historyExceptions;
        private final DBSelector.DataSourceTryer<T> tryer;

        public DataSourceTryerWrapper(DBSelector.DataSourceTryer<T> tryer, List<SQLException> historyExceptions) {
            this.tryer = tryer;
            this.historyExceptions = historyExceptions;
        }

        @Override
        public T onSQLException(List<SQLException> exceptions, ExceptionSorter exceptionSorter, Object ... args) throws SQLException {
            Exception last = exceptions.get(exceptions.size() - 1);
            if (last instanceof NoMoreDataSourceException) {
                if (exceptions.size() > 1) {
                    exceptions.remove(exceptions.size() - 1);
                }
                this.historyExceptions.addAll(exceptions);
                throw (NoMoreDataSourceException)last;
            }
            return this.tryer.onSQLException(exceptions, exceptionSorter, args);
        }

        @Override
        public T tryOnDataSource(DataSourceWrapper dsw, Object ... args) throws SQLException {
            return this.tryer.tryOnDataSource(dsw, args);
        }
    }
}

