/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group.dbselector;

import com.taobao.tddl.jdbc.group.DataSourceWrapper;
import com.taobao.tddl.jdbc.group.config.ConfigManager;
import com.taobao.tddl.jdbc.group.config.GroupExtraConfig;
import com.taobao.tddl.jdbc.group.dbselector.AbstractDBSelector;
import com.taobao.tddl.jdbc.group.dbselector.DBSelector;
import com.taobao.tddl.jdbc.group.dbselector.EquityDbManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class RuntimeWritableAtomDBSelector
extends AbstractDBSelector {
    private Map<String, DataSourceWrapper> dataSourceWrapperMap = new HashMap<String, DataSourceWrapper>();
    private EquityDbManager equityDbManager;

    public RuntimeWritableAtomDBSelector(Map<String, DataSourceWrapper> dataSourceWrapperMap, GroupExtraConfig groupExtraConfig) {
        HashMap<String, Integer> dummyWeightMap = new HashMap<String, Integer>(dataSourceWrapperMap.size());
        for (String dsKey : dataSourceWrapperMap.keySet()) {
            dummyWeightMap.put(dsKey, 10);
        }
        this.equityDbManager = new EquityDbManager(dataSourceWrapperMap, dummyWeightMap, groupExtraConfig);
        this.readable = false;
        this.dataSourceWrapperMap = dataSourceWrapperMap;
    }

    @Override
    public DataSource select() {
        for (Map.Entry<String, DataSourceWrapper> e : this.dataSourceWrapperMap.entrySet()) {
            if (!ConfigManager.isDataSourceAvailable(e.getValue(), false)) continue;
            return e.getValue();
        }
        return null;
    }

    public Map getDataSources() {
        return this.dataSourceWrapperMap;
    }

    @Override
    protected <T> T tryExecuteInternal(Map<DataSource, SQLException> failedDataSources, DBSelector.DataSourceTryer<T> tryer, int times, Object ... args) throws SQLException {
        return this.equityDbManager.tryExecuteInternal(failedDataSources, tryer, times, args);
    }

    @Override
    public DataSourceWrapper get(String dsKey) {
        return this.dataSourceWrapperMap.get(dsKey);
    }

    @Override
    protected AbstractDBSelector.DataSourceHolder findDataSourceWrapperByIndex(int dataSourceIndex) {
        return this.equityDbManager.findDataSourceWrapperByIndex(dataSourceIndex);
    }
}

