/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group.util;

import com.taobao.tddl.common.util.TStringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupHintParser {
    public static Log log = LogFactory.getLog(GroupHintParser.class);

    public static Integer convertHint2Index(String sql) {
        String groupIndexHint = GroupHintParser.extractTDDLGroupHintString(sql);
        if (null != groupIndexHint && !groupIndexHint.equals("")) {
            String[] piece = groupIndexHint.split(":");
            return Integer.valueOf(piece[1]);
        }
        return -1;
    }

    private static String extractTDDLGroupHintString(String sql) {
        return TStringUtil.getBetween((String)sql.toLowerCase(), (String)"/*+tddl_group({", (String)"})*/");
    }

    public static String removeTddlGroupHint(String sql) {
        String tddlHint = GroupHintParser.extractTDDLGroupHintString(sql);
        if (null == tddlHint || "".equals(tddlHint)) {
            return sql;
        }
        sql = TStringUtil.removeBetweenWithSplitor((String)sql.toLowerCase(), (String)"/*+tddl_group({", (String)"})*/");
        return sql;
    }

    public static void main(String[] args) {
        String sql = "/*+TDDL_GROUP({groupIndex:12})*/select * from tab";
        System.out.println(GroupHintParser.convertHint2Index(sql));
        System.out.println(GroupHintParser.removeTddlGroupHint(sql));
    }
}

