/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group.util;

import com.taobao.tddl.interact.rule.bean.SqlType;
import com.taobao.tddl.rule.ruleengine.util.StringUtils;
import java.sql.SQLException;
import java.util.regex.Pattern;

public class SQLParser {
    private static final Pattern SELECT_FOR_UPDATE_PATTERN = Pattern.compile("^select\\s+.*\\s+for\\s+update.*$", 2);

    public static SqlType getSqlType(String sql) throws SQLException {
        SqlType sqlType = null;
        String noCommentsSql = sql;
        if (sql.contains("/*")) {
            noCommentsSql = StringUtils.stripComments((String)sql, (String)"'\"", (String)"'\"", (boolean)true, (boolean)false, (boolean)true, (boolean)true).trim();
        }
        if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"select")) {
            sqlType = noCommentsSql.toLowerCase().contains(" for ") && SELECT_FOR_UPDATE_PATTERN.matcher(noCommentsSql).matches() ? SqlType.SELECT_FOR_UPDATE : SqlType.SELECT;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"show")) {
            sqlType = SqlType.SHOW;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"insert")) {
            sqlType = SqlType.INSERT;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"update")) {
            sqlType = SqlType.UPDATE;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"delete")) {
            sqlType = SqlType.DELETE;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"replace")) {
            sqlType = SqlType.REPLACE;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"truncate")) {
            sqlType = SqlType.TRUNCATE;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"create")) {
            sqlType = SqlType.CREATE;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"drop")) {
            sqlType = SqlType.DROP;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"load")) {
            sqlType = SqlType.LOAD;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"merge")) {
            sqlType = SqlType.MERGE;
        } else if (StringUtils.startsWithIgnoreCaseAndWs((String)noCommentsSql, (String)"alter")) {
            sqlType = SqlType.ALTER;
        } else {
            throw new SQLException("only select, insert, update, delete,replace,truncate,create,drop,load,merge sql is supported");
        }
        return sqlType;
    }
}

