/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.jdbc.group.util;

import com.taobao.tddl.common.exception.runtime.InputStringIsNotValidException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String NL = System.getProperty("line.separator");

    public static String validAndTrim(String str, String errMsg) {
        String ret = null;
        if (str == null || (ret = str.trim()).equals("")) {
            throw new InputStringIsNotValidException(errMsg);
        }
        return ret;
    }

    public static String trim(String str) {
        if (str != null) {
            return str.trim();
        }
        return null;
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        return StringUtils.startsWithIgnoreCaseAndWs(searchIn, searchFor, 0);
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor, int beginPos) {
        if (searchIn == null) {
            return searchFor == null;
        }
        int inLength = searchIn.length();
        while (beginPos < inLength && Character.isWhitespace(searchIn.charAt(beginPos))) {
            ++beginPos;
        }
        return StringUtils.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, startAt, searchFor, 0, searchFor.length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String stripComments(String src, String stringOpens, String stringCloses, boolean slashStarComments, boolean slashSlashComments, boolean hashComments, boolean dashDashComments) {
        if (src == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(src.length());
        StringReader sourceReader = new StringReader(src);
        char contextMarker = '\u0000';
        boolean escaped = false;
        int markerTypeFound = -1;
        int ind = 0;
        char currentChar = '\u0000';
        try {
            block2: while ((currentChar = sourceReader.read()) != '\uffffffff') {
                char prevChar;
                block22: {
                    block23: {
                        block20: {
                            block21: {
                                if (markerTypeFound != -1 && currentChar == stringCloses.charAt(markerTypeFound) && !escaped) {
                                    contextMarker = '\u0000';
                                    markerTypeFound = -1;
                                } else {
                                    ind = stringOpens.indexOf(currentChar);
                                    if (ind != -1 && !escaped && contextMarker == '\u0000') {
                                        markerTypeFound = ind;
                                        contextMarker = currentChar;
                                    }
                                }
                                if (contextMarker != '\u0000' || currentChar != '/' || !slashSlashComments && !slashStarComments) break block20;
                                currentChar = sourceReader.read();
                                if (currentChar != '*' || !slashStarComments) break block21;
                                prevChar = '\u0000';
                                break block22;
                            }
                            if (currentChar == '/' && slashSlashComments) {
                                while ((currentChar = sourceReader.read()) != '\n' && currentChar != '\r' && currentChar >= '\u0000') {
                                }
                            }
                            break block23;
                        }
                        if (contextMarker == '\u0000' && currentChar == '#' && hashComments) {
                            while ((currentChar = sourceReader.read()) != '\n' && currentChar != '\r' && currentChar >= '\u0000') {
                            }
                        } else if (contextMarker == '\u0000' && currentChar == '-' && dashDashComments) {
                            currentChar = sourceReader.read();
                            if (currentChar == '\uffffffff' || currentChar != '-') {
                                buf.append('-');
                                if (currentChar == '\uffffffff') continue;
                                buf.append((int)currentChar);
                                continue;
                            }
                            while ((currentChar = sourceReader.read()) != '\n' && currentChar != '\r' && currentChar >= '\u0000') {
                            }
                        }
                    }
                    if (currentChar == '\uffffffff') continue;
                    buf.append(currentChar);
                    continue;
                }
                while ((currentChar = sourceReader.read()) != '/' || prevChar != '*') {
                    if (currentChar == '\r') {
                        currentChar = sourceReader.read();
                        if (currentChar == '\n') {
                            currentChar = sourceReader.read();
                        }
                    } else if (currentChar == '\n') {
                        currentChar = sourceReader.read();
                    }
                    if (currentChar < '\u0000') continue block2;
                    prevChar = currentChar;
                }
            }
            return buf.toString();
        }
        catch (IOException ioEx) {
            // empty catch block
        }
        return buf.toString();
    }

    public static boolean endsWithIgnoreCase(String s, String suffix) {
        return s.regionMatches(true, s.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static String replaceIgnoreCase(String s, String oldPattern, String newPattern) {
        return Pattern.compile(oldPattern, 2).matcher(s).replaceAll(newPattern);
    }

    public static String[] split(String str, String delimiter) {
        String[] strs = str.split(delimiter);
        ArrayList<String> list = new ArrayList<String>(strs.length);
        for (String s : strs) {
            if (s == null || (s = s.trim()).length() <= 0) continue;
            list.add(s);
        }
        return list.toArray(new String[0]);
    }

    public static boolean isTableFatherAndSon(String fatherTable, String sonTable) {
        if (fatherTable == null || fatherTable.trim().isEmpty() || sonTable == null || sonTable.trim().isEmpty()) {
            return false;
        }
        if (!sonTable.startsWith(fatherTable) || fatherTable.length() + 2 > sonTable.length()) {
            return false;
        }
        String suffix = sonTable.substring(fatherTable.length());
        return suffix.matches("_[\\d]+");
    }
}

