/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.monitor;

import java.io.File;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class TotalLogInit {
    public static final Logger DB_TAB_LOG = Logger.getLogger((String)"DB_TAB_LOG");
    public static final Logger VSLOT_LOG = Logger.getLogger((String)"VSLOT_LOG");
    public static final Logger DYNAMIC_RULE_LOG = Logger.getLogger((String)"DYNAMIC_RULE_LOG");
    private static volatile boolean initOK = false;

    private static String getLogPath() {
        String path;
        File dir;
        String userHome = System.getProperty("user.home");
        if (!userHome.endsWith(File.separator)) {
            userHome = userHome + File.separator;
        }
        if (!(dir = new File(path = userHome + "logs" + File.separator + "tddl" + File.separator)).exists()) {
            dir.mkdirs();
        }
        return path;
    }

    private static Appender buildAppender(String name, String fileName, String pattern) {
        DailyRollingFileAppender appender = new DailyRollingFileAppender();
        appender.setName(name);
        appender.setAppend(true);
        appender.setEncoding("GBK");
        appender.setLayout((Layout)new PatternLayout(pattern));
        appender.setFile(new File(TotalLogInit.getLogPath(), fileName).getAbsolutePath());
        appender.activateOptions();
        return appender;
    }

    public static void initTddlLog() {
        if (initOK) {
            return;
        }
        Appender dbTabAppender = TotalLogInit.buildAppender("TDDL_Vtab_Appender", "tddl-db-tab.log", "%m");
        Appender vSlotAppender = TotalLogInit.buildAppender("TDDL_Vtab_Appender", "tddl-vslot.log", "%m");
        Appender dynamicRuleAppender = TotalLogInit.buildAppender("TDDL_DynamicRule_Appender", "tddl-dynamic-rule.log", "%m");
        DB_TAB_LOG.setAdditivity(false);
        DB_TAB_LOG.removeAllAppenders();
        DB_TAB_LOG.addAppender(dbTabAppender);
        DB_TAB_LOG.setLevel(Level.INFO);
        VSLOT_LOG.setAdditivity(false);
        VSLOT_LOG.removeAllAppenders();
        VSLOT_LOG.addAppender(vSlotAppender);
        VSLOT_LOG.setLevel(Level.INFO);
        DYNAMIC_RULE_LOG.setAdditivity(false);
        DYNAMIC_RULE_LOG.removeAllAppenders();
        DYNAMIC_RULE_LOG.addAppender(dynamicRuleAppender);
        DYNAMIC_RULE_LOG.setLevel(Level.INFO);
    }

    static {
        TotalLogInit.initTddlLog();
    }
}

