/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.interact.monitor;

import com.taobao.tddl.interact.monitor.TotalLogInit;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TotalStatMonitor {
    private static Log logger = LogFactory.getLog(TotalStatMonitor.class);
    private volatile long statInterval = 30000L;
    public static final String logFieldSep = "#@#";
    public static final String linesep = System.getProperty("line.separator");
    private static String appName = "TDDL";
    private static volatile ConcurrentHashMap<String, AtomicLong> dbTabMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, AtomicLong> dbTablastMap;
    private static volatile ConcurrentHashMap<String, AtomicLong> virtualSlotMap;
    private static ConcurrentHashMap<String, AtomicLong> virtualSlotlastMap;
    private static TotalStatMonitor instance;
    private boolean started = false;
    private Thread dbTabFlushTask = new Thread("TotalStatMonitor.dbTab"){

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(TotalStatMonitor.this.statInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ConcurrentHashMap tempMap = new ConcurrentHashMap();
                dbTablastMap = new ConcurrentHashMap();
                dbTablastMap = dbTabMap;
                dbTabMap = tempMap;
                TotalStatMonitor.flushDbTabLogMapToFile(dbTablastMap);
            }
        }
    };
    private Thread virtualSlotFlushTask = new Thread("TotalStatMonitor.virtualSlot"){

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(TotalStatMonitor.this.statInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ConcurrentHashMap tempMap = new ConcurrentHashMap();
                virtualSlotlastMap = new ConcurrentHashMap();
                virtualSlotlastMap = virtualSlotMap;
                virtualSlotMap = tempMap;
                TotalStatMonitor.flushVSlotLogMapToFile(virtualSlotlastMap);
            }
        }
    };

    private TotalStatMonitor() {
    }

    public static TotalStatMonitor getInstance() {
        return instance;
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.dbTabFlushTask.setDaemon(true);
        this.dbTabFlushTask.start();
        this.virtualSlotFlushTask.setDaemon(true);
        this.virtualSlotFlushTask.start();
        this.started = true;
        logger.info((Object)"Le Log Monitor Start...");
    }

    public static void dbTabIncrement(String key) {
        AtomicLong incre = dbTabMap.putIfAbsent(key, new AtomicLong(0L));
        if (incre != null) {
            incre.addAndGet(1L);
        }
    }

    public static void virtualSlotIncrement(String key) {
        AtomicLong incre = virtualSlotMap.putIfAbsent(key, new AtomicLong(0L));
        if (incre != null) {
            incre.addAndGet(1L);
        }
    }

    public static void recieveRuleLog(String version) {
        SimpleDateFormat df = new SimpleDateFormat("yyy-MM-dd HH:mm:ss:SSS");
        String time = df.format(new Date());
        StringBuilder sb = new StringBuilder().append(appName).append(logFieldSep).append(version).append(logFieldSep).append(time).append(logFieldSep).append(1).append(linesep);
        TotalLogInit.DYNAMIC_RULE_LOG.info((Object)sb.toString());
    }

    private static void flushDbTabLogMapToFile(ConcurrentHashMap<String, AtomicLong> map) {
        SimpleDateFormat df = new SimpleDateFormat("yyy-MM-dd HH:mm:ss:SSS");
        String time = df.format(new Date());
        for (Map.Entry<String, AtomicLong> entry : map.entrySet()) {
            String key = entry.getKey();
            StringBuilder sb = new StringBuilder().append(appName).append(logFieldSep).append(key).append(logFieldSep).append(entry.getValue()).append(logFieldSep).append(time).append(linesep);
            TotalLogInit.DB_TAB_LOG.info((Object)sb.toString());
        }
    }

    private static void flushVSlotLogMapToFile(ConcurrentHashMap<String, AtomicLong> map) {
        SimpleDateFormat df = new SimpleDateFormat("yyy-MM-dd HH:mm:ss:SSS");
        String time = df.format(new Date());
        for (Map.Entry<String, AtomicLong> entry : map.entrySet()) {
            String key = entry.getKey();
            StringBuilder sb = new StringBuilder().append(appName).append(logFieldSep).append(key).append(logFieldSep).append(entry.getValue()).append(logFieldSep).append(time).append(linesep);
            TotalLogInit.VSLOT_LOG.info((Object)sb.toString());
        }
    }

    public void setAppName(String appName) {
        TotalStatMonitor.appName = appName;
    }

    public static void main(String[] args) {
        TotalStatMonitor monitor = new TotalStatMonitor();
        monitor.start();
        for (int i = 0; i < 1000000000; ++i) {
            TotalStatMonitor.virtualSlotIncrement("tab_slot_1");
            TotalStatMonitor.virtualSlotIncrement("tab_slot_2");
        }
        TotalStatMonitor.recieveRuleLog("V1,V2");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TotalStatMonitor.recieveRuleLog("V1");
    }

    static {
        virtualSlotMap = new ConcurrentHashMap();
        instance = new TotalStatMonitor();
    }
}

